/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import org.jetbrains.annotations.Nullable;

public class SpellUniversalParticle
extends TextureSheetParticle {
    private static final RandomSource RANDOM = RandomSource.create();
    private final SpriteSet spriteProvider;
    private final SpellEngineParticles.MagicParticles.Motion motion;
    private boolean animated = false;
    public boolean glows = true;
    public boolean translucent = true;
    @Nullable
    Entity followEntity;

    SpellUniversalParticle(ClientLevel world, SpriteSet spriteProvider, SpellEngineParticles.MagicParticles.Motion motion, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, 0.5 - RANDOM.nextDouble(), velocityY, 0.5 - RANDOM.nextDouble());
        this.spriteProvider = spriteProvider;
        this.motion = motion;
        switch (motion) {
            case FLOAT: 
            case DECELERATE: {
                this.friction = 0.96f;
                this.xd = this.xd * (double)0.01f + velocityX;
                this.yd = this.yd * (double)0.01f + velocityY;
                this.zd = this.zd * (double)0.01f + velocityZ;
                this.x += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                this.y += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                this.z += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                if (motion == SpellEngineParticles.MagicParticles.Motion.DECELERATE) {
                    this.friction *= 0.8f;
                }
                this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case ASCEND: {
                this.friction = 0.96f;
                this.gravity = -0.1f;
                this.speedUpWhenYMotionIsBlocked = true;
                this.yd *= 0.2;
                if (velocityX == 0.0 && velocityZ == 0.0) {
                    this.xd *= (double)0.1f;
                    this.zd *= (double)0.1f;
                }
                this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case BURST: {
                this.friction = 0.7f;
                this.gravity = 0.5f;
                this.xd *= (double)0.1f;
                this.yd *= (double)0.1f;
                this.zd *= (double)0.1f;
                this.xd += velocityX * 0.4;
                this.yd += velocityY * 0.4;
                this.zd += velocityZ * 0.4;
                this.lifetime = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
            }
        }
        this.setSpriteFromAge(spriteProvider);
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        if (this.glows) {
            if (this.translucent) {
                return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
            }
            return ParticleRenderType.PARTICLE_SHEET_LIT;
        }
        if (this.translucent) {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float tint) {
        if (this.glows) {
            return 255;
        }
        return super.getLightColor(tint);
    }

    public void move(double dx, double dy, double dz) {
        if (this.followEntity != null && !this.followEntity.isRemoved()) {
            dx += this.followEntity.getX() - this.followEntity.xo;
            dy += this.followEntity.getY() - this.followEntity.yo;
            dz += this.followEntity.getZ() - this.followEntity.zo;
        }
        super.move(dx, dy, dz);
    }

    public void tick() {
        super.tick();
        if (this.animated) {
            this.setSpriteFromAge(this.spriteProvider);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MagicVariant
    implements ParticleProvider<TemplateParticleType> {
        private final SpriteSet spriteProvider;
        private final SpellEngineParticles.MagicParticles.Variant particleVariant;

        public MagicVariant(SpriteSet spriteProvider, SpellEngineParticles.MagicParticles.Variant particleVariant) {
            this.spriteProvider = spriteProvider;
            this.particleVariant = particleVariant;
        }

        public Particle createParticle(TemplateParticleType particleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellUniversalParticle particle = new SpellUniversalParticle(clientWorld, this.spriteProvider, this.particleVariant.motion(), d, e, f, g, h, i);
            particle.glows = true;
            particle.animated = this.particleVariant.shape().animated;
            particle.rCol = 1.0f;
            particle.gCol = 1.0f;
            particle.bCol = 1.0f;
            particle.quadSize *= 0.75f;
            switch (this.particleVariant.shape()) {
                case SPELL: 
                case STRIPE: {
                    particle.alpha = 1.0f;
                    break;
                }
                default: {
                    particle.alpha = 0.75f;
                }
            }
            TemplateParticleType.apply(particleType, (Particle)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.alpha *= appearance.color.alpha();
                }
                particle.quadSize *= appearance.scale;
                particle.lifetime = (int)((float)particle.lifetime * appearance.max_age);
                particle.followEntity = appearance.entityFollowed;
            }
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(particle.rCol * j, particle.gCol * j, particle.bCol * j);
            return particle;
        }
    }
}

