/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import com.mojang.serialization.MapCodec;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.util.Color;

public class TemplateParticleType
extends ParticleType<TemplateParticleType>
implements ParticleOptions,
TemplateParticleEffect {
    private final MapCodec<TemplateParticleType> codec = MapCodec.unit(this::getType);
    private final StreamCodec<RegistryFriendlyByteBuf, TemplateParticleType> packetCodec = StreamCodec.unit((Object)this);
    private TemplateParticleType type;
    private TemplateParticleEffect.Appearance appearance = new TemplateParticleEffect.Appearance();

    public TemplateParticleType() {
        this(true);
    }

    public TemplateParticleType(boolean alwaysShow) {
        super(alwaysShow);
        this.type = this;
    }

    public TemplateParticleType getType() {
        return this.type;
    }

    public MapCodec<TemplateParticleType> codec() {
        return this.codec;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, TemplateParticleType> streamCodec() {
        return this.packetCodec;
    }

    @Override
    public void setAppearance(TemplateParticleEffect.Appearance appearance) {
        this.appearance = appearance;
    }

    @Override
    public TemplateParticleEffect.Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    public TemplateParticleEffect copy() {
        TemplateParticleType copy = new TemplateParticleType(this.getOverrideLimiter());
        copy.type = this.type;
        return copy;
    }

    public static void apply(TemplateParticleType templateParticleType, Particle particle) {
        Color color;
        TemplateParticleEffect.Appearance appearance = templateParticleType.getAppearance();
        if (appearance != null && (color = appearance.color) != null) {
            particle.setColor(color.red(), color.green(), color.blue());
        }
    }
}

