/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;

public class UniversalSpellParticle
extends TextureSheetParticle {
    private static final RandomSource RANDOM = RandomSource.create();
    private final SpriteSet spriteProvider;
    private final SpellEngineParticles.MagicParticleFamily.Motion motion;
    public boolean glows = true;
    public boolean translucent = true;

    UniversalSpellParticle(ClientLevel world, SpriteSet spriteProvider, SpellEngineParticles.MagicParticleFamily.Motion motion, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, 0.5 - RANDOM.nextDouble(), velocityY, 0.5 - RANDOM.nextDouble());
        this.spriteProvider = spriteProvider;
        this.motion = motion;
        switch (motion) {
            case FLOAT: 
            case DECELERATE: {
                this.friction = 0.96f;
                this.xd = this.xd * (double)0.01f + velocityX;
                this.yd = this.yd * (double)0.01f + velocityY;
                this.zd = this.zd * (double)0.01f + velocityZ;
                this.x += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                this.y += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                this.z += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.05f);
                if (motion == SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE) {
                    this.friction *= 0.8f;
                }
                this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case ASCEND: {
                this.friction = 0.96f;
                this.gravity = -0.1f;
                this.speedUpWhenYMotionIsBlocked = true;
                this.yd *= 0.2;
                if (velocityX == 0.0 && velocityZ == 0.0) {
                    this.xd *= (double)0.1f;
                    this.zd *= (double)0.1f;
                }
                this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
                break;
            }
            case BURST: {
                this.friction = 0.7f;
                this.gravity = 0.5f;
                this.xd *= (double)0.1f;
                this.yd *= (double)0.1f;
                this.zd *= (double)0.1f;
                this.xd += velocityX * 0.4;
                this.yd += velocityY * 0.4;
                this.zd += velocityZ * 0.4;
                this.lifetime = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
            }
        }
        this.setSpriteFromAge(spriteProvider);
        this.hasPhysics = false;
    }

    public ParticleRenderType getRenderType() {
        if (this.glows) {
            if (this.translucent) {
                return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
            }
            return ParticleRenderType.PARTICLE_SHEET_LIT;
        }
        if (this.translucent) {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float tint) {
        if (this.glows) {
            return 255;
        }
        return super.getLightColor(tint);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Opaque
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        private final SpellEngineParticles.MagicParticleFamily.Motion motion;

        public Opaque(SpriteSet spriteProvider, SpellEngineParticles.MagicParticleFamily.Motion motion) {
            this.spriteProvider = spriteProvider;
            this.motion = motion;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            UniversalSpellParticle particle = new UniversalSpellParticle(clientWorld, this.spriteProvider, this.motion, d, e, f, g, h, i);
            float j = clientWorld.random.nextFloat() * 0.25f + 0.7f;
            particle.setColor(j, j, j);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MagicVariant
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        private final SpellEngineParticles.MagicParticleFamily.Variant particleVariant;

        public MagicVariant(SpriteSet spriteProvider, SpellEngineParticles.MagicParticleFamily.Variant particleVariant) {
            this.spriteProvider = spriteProvider;
            this.particleVariant = particleVariant;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            UniversalSpellParticle particle = new UniversalSpellParticle(clientWorld, this.spriteProvider, this.particleVariant.motion(), d, e, f, g, h, i);
            particle.glows = true;
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            Color color = this.particleVariant.color();
            particle.setColor(color.red() * j, color.green() * j, color.blue() * j);
            particle.quadSize *= 0.75f;
            switch (this.particleVariant.shape()) {
                case SPELL: 
                case STRIPE: {
                    particle.alpha = 1.0f;
                    break;
                }
                default: {
                    particle.alpha = 0.75f;
                }
            }
            return particle;
        }
    }
}

