/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.render.SpellModelHelper;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.mixin.client.render.ItemRendererAccessor;
import org.jetbrains.annotations.Nullable;

public class SpellProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final boolean lit;

    public SpellProjectileRenderer(EntityRendererProvider.Context ctx, float scale, boolean lit) {
        super(ctx);
        this.itemRenderer = ctx.getItemRenderer();
        this.scale = scale;
        this.lit = lit;
    }

    public SpellProjectileRenderer(EntityRendererProvider.Context arg) {
        this(arg, 1.0f, false);
    }

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return this.lit ? 15 : super.getBlockLightLevel(entity, pos);
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        Spell.ProjectileModel renderData;
        boolean rendered;
        SpellProjectile projectile;
        if (entity instanceof SpellProjectile && (projectile = (SpellProjectile)entity).renderData() != null && (rendered = SpellProjectileRenderer.render(this.scale, this.entityRenderDispatcher, this.itemRenderer, renderData = projectile.renderData(), projectile.previousVelocity, entity, yaw, tickDelta, true, matrices, vertexConsumers, light))) {
            super.render(entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public static boolean render(float scale, EntityRenderDispatcher dispatcher, ItemRenderer itemRenderer, Spell.ProjectileModel renderData, @Nullable Vec3 previousVelocity, Entity entity, float yaw, float tickDelta, boolean allowSpin, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.tickCount >= 2 || !(dispatcher.camera.getEntity().distanceToSqr(entity) < 12.25)) {
            SpellProjectile spellProjectile;
            matrices.pushPose();
            matrices.scale(scale, scale, scale);
            switch (renderData.orientation) {
                case TOWARDS_CAMERA: {
                    matrices.mulPose(dispatcher.cameraOrientation());
                    matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case TOWARDS_MOTION: 
                case ALONG_MOTION: {
                    Vec3 velocity = entity.getDeltaMovement();
                    if (previousVelocity != null) {
                        velocity = previousVelocity.lerp(velocity, (double)tickDelta);
                    }
                    velocity = velocity.normalize();
                    double directionBasedYaw = Math.toDegrees(Math.atan2(velocity.x, velocity.z)) + 180.0;
                    if (renderData.orientation == Spell.ProjectileModel.Orientation.ALONG_MOTION) {
                        directionBasedYaw += 90.0;
                    }
                    double directionBasedPitch = Math.toDegrees(Math.asin(velocity.y));
                    matrices.mulPose(Axis.YP.rotationDegrees((float)directionBasedYaw));
                    matrices.mulPose(Axis.XP.rotationDegrees((float)directionBasedPitch));
                }
            }
            if (allowSpin) {
                matrices.mulPose(Axis.ZP.rotationDegrees(renderData.rotate_degrees_offset + ((float)entity.tickCount + tickDelta) * renderData.rotate_degrees_per_tick));
            }
            matrices.scale(renderData.scale, renderData.scale, renderData.scale);
            ResourceLocation modelId = null;
            ItemStack modelItemStack = null;
            if (entity instanceof SpellProjectile && (spellProjectile = (SpellProjectile)entity).getItemStackModel() != null) {
                modelItemStack = spellProjectile.getItemStackModel();
            } else if (renderData.model_id != null && !renderData.model_id.isEmpty()) {
                modelId = ResourceLocation.parse((String)renderData.model_id);
            }
            RenderType layer = SpellModelHelper.LAYERS.get((Object)renderData.light_emission);
            if (modelItemStack != null) {
                BakedModel model = itemRenderer.getModel(modelItemStack, entity.level(), null, entity.getId());
                model.getTransforms().getTransform(ItemDisplayContext.FIXED).apply(false, matrices);
                CustomModels.renderModel(layer, (ItemRendererAccessor)itemRenderer, matrices, vertexConsumers, light, model);
            } else if (modelId != null) {
                CustomModels.render(layer, itemRenderer, modelId, matrices, vertexConsumers, light, entity.getId());
            }
            matrices.popPose();
            return true;
        }
        return false;
    }

    public ResourceLocation getTextureLocation(Entity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

