/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.sound;

import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.jetbrains.annotations.Nullable;

public class SpellCastingSound
extends SimpleSoundInstance
implements SoundInstance,
TickableSoundInstance {
    private LivingEntity emitter;
    private boolean done;
    @Nullable
    public Listener listener;

    public SpellCastingSound(LivingEntity emitter, ResourceLocation id, float volume, float pitch) {
        super(id, SoundSource.PLAYERS, volume, pitch, SoundInstance.createUnseededRandom(), true, 0, SoundInstance.Attenuation.LINEAR, emitter.getX(), emitter.getY(), emitter.getZ(), false);
        this.emitter = emitter;
    }

    private boolean isEmitterCasting() {
        SpellCasterEntity caster;
        LivingEntity livingEntity;
        return this.emitter != null && this.emitter.isAlive() && (livingEntity = this.emitter) instanceof SpellCasterEntity && (caster = (SpellCasterEntity)livingEntity).isCastingSpell();
    }

    public boolean isStopped() {
        return this.done;
    }

    protected final void setDone() {
        this.done = true;
        this.looping = false;
        this.volume = 0.0f;
        if (this.listener != null) {
            this.listener.onSpellCastingSoundDone();
        }
    }

    public void tick() {
        if (!this.isEmitterCasting()) {
            this.setDone();
        }
    }

    public double getX() {
        return this.emitter.getX();
    }

    public double getY() {
        return this.emitter.getY();
    }

    public double getZ() {
        return this.emitter.getZ();
    }

    public static interface Listener {
        public void onSpellCastingSoundDone();
    }
}

