/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.internals.target.EntityRelations;

public class FTBTeamsCompat {
    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("ftbteams")) {
            EntityRelations.registerTeamMatcher("ftb", (attack, target) -> {
                if (attack instanceof Player) {
                    Player attackerPlayer = (Player)attack;
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (attackerPlayer.level().isClientSide()) {
                            return FTBTeamsCompat.checkClientTeamRelation(attackerPlayer, targetPlayer);
                        }
                        return FTBTeamsCompat.checkServerTeamRelation(attackerPlayer, targetPlayer);
                    }
                }
                return null;
            });
        }
    }

    private static EntityRelations.TeamRelation checkClientTeamRelation(Player attackerPlayer, Player targetPlayer) {
        if (!FTBTeamsAPI.api().isClientManagerLoaded()) {
            return null;
        }
        ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
        Optional attackerKnownPlayerOpt = manager.getKnownPlayer(attackerPlayer.getUUID());
        if (attackerKnownPlayerOpt.isEmpty()) {
            return null;
        }
        Optional targetKnownPlayerOpt = manager.getKnownPlayer(targetPlayer.getUUID());
        if (targetKnownPlayerOpt.isEmpty()) {
            return null;
        }
        KnownClientPlayer attackerKnownPlayer = (KnownClientPlayer)attackerKnownPlayerOpt.get();
        KnownClientPlayer targetKnownPlayer = (KnownClientPlayer)targetKnownPlayerOpt.get();
        if (attackerKnownPlayer.teamId().equals(targetKnownPlayer.teamId())) {
            return new EntityRelations.TeamRelation(true, false);
        }
        return null;
    }

    private static EntityRelations.TeamRelation checkServerTeamRelation(Player attackerPlayer, Player targetPlayer) {
        if (!FTBTeamsAPI.api().isManagerLoaded()) {
            return null;
        }
        TeamManager manager = FTBTeamsAPI.api().getManager();
        if (manager.arePlayersInSameTeam(attackerPlayer.getUUID(), targetPlayer.getUUID())) {
            return new EntityRelations.TeamRelation(true, false);
        }
        return null;
    }
}

