/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import java.util.function.Function;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.entity.player.Player;

public class MeleeCompat {
    public static Function<Player, Attack> attackProperties = player -> {
        boolean isCombo = (float)player.getLastHurtMobTimestamp() == player.getCurrentItemAttackStrengthDelay() * 20.0f;
        boolean isOffhand = false;
        return new Attack(isCombo, isOffhand);
    };

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("bettercombat")) {
            attackProperties = player -> {
                AttackHand attack = ((EntityPlayer_BetterCombat)player).getCurrentAttack();
                if (attack != null) {
                    boolean isCombo = attack.combo().total() == attack.combo().current();
                    boolean isOffhand = attack.isOffHand();
                    return new Attack(isCombo, isOffhand);
                }
                return Attack.EMPTY;
            };
        }
    }

    public record Attack(boolean isCombo, boolean isOffhand) {
        public static final Attack EMPTY = new Attack(false, false);
    }
}

