/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import org.jetbrains.annotations.Nullable;

public class SlotModCompat {
    @Nullable
    public static Function<Player, ItemStack> spellBookResolver = player -> ItemStack.EMPTY;
    @Nullable
    public static Function<SpellBookArs, ISpellBookItem> spellBookFactory = null;
    @Nullable
    public static Function<SpellScrollArs, Item> spellScrollFactory = null;

    public static ItemStack getEquippedSpellBook(Player player) {
        return spellBookResolver.apply(player);
    }

    public static void setSpellBookFactory(Function<SpellBookArs, ISpellBookItem> factory) {
        if (spellBookFactory != null) {
            return;
        }
        spellBookFactory = factory;
    }

    public static void setSpellScrollFactory(Function<SpellScrollArs, Item> factory) {
        if (spellScrollFactory != null) {
            return;
        }
        spellScrollFactory = factory;
    }

    public record SpellScrollArs(Item.Properties settings) {
    }

    public record SpellBookArs(ResourceLocation poolId, Item.Properties settings) {
    }
}

