/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fx;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SpellEngineSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry GENERIC_ARCANE_CASTING = SpellEngineSounds.add(new Entry("generic_arcane_casting"));
    public static final Entry GENERIC_ARCANE_RELEASE = SpellEngineSounds.add(new Entry("generic_arcane_release"));
    public static final Entry GENERIC_FIRE_CASTING = SpellEngineSounds.add(new Entry("generic_fire_casting"));
    public static final Entry GENERIC_FIRE_RELEASE = SpellEngineSounds.add(new Entry("generic_fire_release"));
    public static final Entry GENERIC_FIRE_IGNITE = SpellEngineSounds.add(new Entry("generic_fire_ignite"));
    public static final Entry GENERIC_FIRE_IMPACT_1 = SpellEngineSounds.add(new Entry("generic_fire_impact_1"));
    public static final Entry GENERIC_FIRE_IMPACT_2 = SpellEngineSounds.add(new Entry("generic_fire_impact_2"));
    public static final Entry GENERIC_FIRE_IMPACT_3 = SpellEngineSounds.add(new Entry("generic_fire_impact_3"));
    public static final Entry GENERIC_FROST_CASTING = SpellEngineSounds.add(new Entry("generic_frost_casting"));
    public static final Entry GENERIC_FROST_RELEASE = SpellEngineSounds.add(new Entry("generic_frost_release"));
    public static final Entry GENERIC_FROST_IMPACT = SpellEngineSounds.add(new Entry("generic_frost_impact"));
    public static final Entry GENERIC_HEALING_CASTING = SpellEngineSounds.add(new Entry("generic_healing_casting"));
    public static final Entry GENERIC_HEALING_RELEASE = SpellEngineSounds.add(new Entry("generic_healing_release"));
    public static final Entry GENERIC_HEALING_IMPACT_1 = SpellEngineSounds.add(new Entry("generic_healing_impact_1"));
    public static final Entry GENERIC_HEALING_IMPACT_2 = SpellEngineSounds.add(new Entry("generic_healing_impact_2"));
    public static final Entry GENERIC_HEALING_IMPACT_3 = SpellEngineSounds.add(new Entry("generic_healing_impact_3"));
    public static final Entry GENERIC_HEALING_IMPACT_4 = SpellEngineSounds.add(new Entry("generic_healing_impact_4"));
    public static final Entry GENERIC_POISON_IMPACT = SpellEngineSounds.add(new Entry("generic_poison_impact"));
    public static final Entry GENERIC_LIGHTNING_CASTING = SpellEngineSounds.add(new Entry("generic_lightning_casting"));
    public static final Entry GENERIC_LIGHTNING_RELEASE = SpellEngineSounds.add(new Entry("generic_lightning_release"));
    public static final Entry GENERIC_SOUL_CASTING = SpellEngineSounds.add(new Entry("generic_soul_casting"));
    public static final Entry GENERIC_SOUL_RELEASE = SpellEngineSounds.add(new Entry("generic_soul_release"));
    public static final Entry GENERIC_WIND_CHARGING = SpellEngineSounds.add(new Entry("generic_wind_charging"));
    public static final Entry STUN_GENERIC = SpellEngineSounds.add(new Entry("stun_generic"));
    public static final Entry GENERIC_DISPEL_1 = SpellEngineSounds.add(new Entry("generic_dispel_1"));
    public static final Entry SPELL_COOLDOWN_IMPACT = SpellEngineSounds.add(new Entry("spell_cooldown_impact"));
    public static final Entry SPEED_BOOST = SpellEngineSounds.add(new Entry("speed_boost"));
    public static final Entry RADIANCE_IMPACT = SpellEngineSounds.add(new Entry("radiance_impact"));
    public static final Entry SIGNAL_INSTANT_CAST = SpellEngineSounds.add(new Entry("signal_instant_cast"));
    public static final Entry SIGNAL_SPELL_CRIT = SpellEngineSounds.add(new Entry("signal_spell_crit"));
    public static final Entry LEECHING_IMPACT = SpellEngineSounds.add(new Entry("leeching_impact"));
    public static final Entry POISON_CLOUD_SPAWN = SpellEngineSounds.add(new Entry("poison_cloud_spawn"));
    public static final Entry POISON_CLOUD_TICK = SpellEngineSounds.add(new Entry("poison_cloud_tick"));
    public static final Entry DODGE = SpellEngineSounds.add(new Entry("dodge").variants(2));
    public static final Entry BIND_SPELL = SpellEngineSounds.add(new Entry("bind_spell"));
    public static final Entry SPELLBOOK_EQUIP = SpellEngineSounds.add(new Entry("spellbook_equip"));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }

        public void register() {
            if (this.entry == null) {
                this.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)this.id(), (Object)this.soundEvent());
            }
        }
    }
}

