/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.base.Suppliers;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.effect.InstantCast;
import net.spell_engine.api.effect.StatusEffectClassification;
import net.spell_engine.api.entity.SpellEntity;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellEvents;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.spell.weakness.ScopedWeakness;
import net.spell_engine.api.spell.weakness.SpellSchoolWeakness;
import net.spell_engine.api.tags.SpellEngineEntityTags;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.entity.DamageSourceExtension;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.Ammo;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.SpellModifiers;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.casting.SpellBatcher;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCastSyncHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.AttributeModifierUtil;
import net.spell_engine.utils.ItemCooldownManagerExtension;
import net.spell_engine.utils.PatternMatching;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.StatusEffectUtil;
import net.spell_engine.utils.TargetHelper;
import net.spell_engine.utils.VectorHelper;
import net.spell_engine.utils.WorldScheduler;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellHelper {
    public static float launchPointOffsetDefault = 0.5f;
    private static final float knockbackDefaultStrength = 0.4f;

    public static SpellCast.Attempt attemptCasting(Player player, ItemStack itemStack, ResourceLocation spellId) {
        return SpellHelper.attemptCasting(player, itemStack, spellId, true);
    }

    public static SpellCast.Attempt attemptCasting(Player player, ItemStack itemStack, ResourceLocation spellId, boolean checkAmmo) {
        Ammo.Result ammoResult;
        SpellCasterEntity caster = (SpellCasterEntity)player;
        Holder.Reference spellEntry = SpellRegistry.from(player.level()).getHolder(spellId).orElse(null);
        if (spellEntry == null) {
            return SpellCast.Attempt.none();
        }
        Spell spell = (Spell)spellEntry.value();
        if (caster.getCooldownManager().isCoolingDown(spellId)) {
            return SpellCast.Attempt.failOnCooldown(new SpellCast.Attempt.OnCooldownInfo());
        }
        if (checkAmmo && !(ammoResult = Ammo.ammoForSpell(player, spell, itemStack)).satisfied()) {
            return SpellCast.Attempt.failMissingItem(new SpellCast.Attempt.MissingItemInfo(ammoResult.item()));
        }
        return SpellCast.Attempt.success();
    }

    public static float hasteAffectedValue(float value, float haste) {
        return value / haste;
    }

    public static float hasteAffectedValue(LivingEntity caster, SpellSchool school, float value) {
        return SpellHelper.hasteAffectedValue(caster, school, value, null);
    }

    public static float hasteAffectedValue(LivingEntity caster, SpellSchool school, float value, ItemStack provisionedWeapon) {
        float haste = SpellPower.getHaste((LivingEntity)caster, (SpellSchool)school);
        return SpellHelper.hasteAffectedValue(value, haste);
    }

    public static float getRange(Player player, Holder<Spell> spellEntry) {
        Spell spell = (Spell)spellEntry.value();
        float range = spell.range;
        if (spell.range_mechanic != null) {
            switch (spell.range_mechanic) {
                case MELEE: {
                    range = (float)(player.entityInteractionRange() + (double)spell.range);
                }
            }
        }
        for (Spell.Modifier modifier : SpellModifiers.of(player, spellEntry)) {
            if (modifier.range_add == 0.0f) continue;
            range += modifier.range_add;
        }
        return range;
    }

    public static float getCastDuration(LivingEntity caster, Spell spell) {
        return SpellHelper.getCastDuration(caster, spell, null);
    }

    public static float getCastDuration(LivingEntity caster, Spell spell, ItemStack provisionedWeapon) {
        if (spell.active != null && spell.active.cast == null) {
            return 0.0f;
        }
        return SpellHelper.hasteAffectedValue(caster, spell.school, spell.active.cast.duration, provisionedWeapon);
    }

    public static SpellCast.Duration getCastTimeDetails(LivingEntity caster, Spell spell) {
        if (spell.active == null) {
            return SpellCast.Duration.EMPTY;
        }
        float haste = spell.active.cast.haste_affected ? SpellPower.getHaste((LivingEntity)caster, (SpellSchool)spell.school) : 1.0f;
        float duration = SpellHelper.hasteAffectedValue(spell.active.cast.duration, haste);
        return new SpellCast.Duration(haste, Math.round(duration * 20.0f));
    }

    public static float getCooldownDuration(LivingEntity caster, Holder<Spell> spellEntry) {
        return SpellHelper.getCooldownDuration(caster, spellEntry, null);
    }

    public static boolean isInstantCast(Holder<Spell> spellEntry, LivingEntity caster) {
        Spell spell = (Spell)spellEntry.value();
        if (spell.active == null) {
            return true;
        }
        return spell.active.cast.duration == 0.0f || !SpellHelper.isChanneled(spell) && InstantCast.instantify(spellEntry, caster);
    }

    public static float getCooldownDuration(LivingEntity caster, Holder<Spell> spellEntry, ItemStack provisionedWeapon) {
        Spell spell = (Spell)spellEntry.value();
        float duration = spell.cost.cooldown.duration;
        if (caster instanceof Player) {
            Player player = (Player)caster;
            duration -= SpellModifiers.cooldownDeduction(player, spellEntry);
        }
        if (duration > 0.0f && SpellEngineMod.config.haste_affects_cooldown && spell.cost.cooldown.haste_affected) {
            duration = SpellHelper.hasteAffectedValue(caster, spell.school, duration, provisionedWeapon);
        }
        return Math.max(duration, 0.0f);
    }

    public static boolean isChanneled(Spell spell) {
        return SpellHelper.channelValueMultiplier(spell) != 0.0f;
    }

    public static boolean isInstant(Spell spell) {
        if (spell.active == null) {
            return true;
        }
        return spell.active.cast.duration == 0.0f;
    }

    public static float channelValueMultiplier(Spell spell) {
        if (spell.active == null) {
            return 0.0f;
        }
        int ticks = spell.active.cast.channel_ticks;
        if (ticks <= 0) {
            return 0.0f;
        }
        return (float)ticks / 20.0f;
    }

    public static void startCasting(Player player, ResourceLocation spellId, float speed, int length) {
        Holder.Reference spellEntry = SpellRegistry.from(player.level()).getHolder(spellId).orElse(null);
        if (spellEntry == null) {
            return;
        }
        Spell spell = (Spell)spellEntry.value();
        if (spell.active == null) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCast.Process process = new SpellCast.Process((Holder<Spell>)spellEntry, itemStack.getItem(), speed, length, player.level().getGameTime());
        SpellCastSyncHelper.setCasting(player, process);
        SoundHelper.playSound(player.level(), (Entity)player, spell.active.cast.start_sound);
    }

    public static void performSpell(Level world, Player player, Holder<Spell> spellEntry, SpellTarget.SearchResult targetResult, SpellCast.Action action, float progress) {
        if (player.isSpectator()) {
            return;
        }
        Spell spell = (Spell)spellEntry.value();
        ResourceLocation spellId = ((ResourceKey)spellEntry.unwrapKey().get()).location();
        ItemStack heldItemStack = player.getMainHandItem();
        SpellContainerSource.SourcedContainer spellSource = SpellContainerSource.getFirstSourceOfSpell(spellId, player);
        if (spellSource == null) {
            return;
        }
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, heldItemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCasterEntity caster = (SpellCasterEntity)player;
        List<Entity> targets = targetResult.entities();
        float castingSpeed = caster.getCurrentCastingSpeed();
        progress = Math.max(Math.min(progress, 1.0f), 0.0f);
        float channelMultiplier = 1.0f;
        int channelTickIndex = 0;
        int incrementChannelTicks = 0;
        boolean shouldPerformImpact = true;
        com.google.common.base.Supplier trackingPlayers = Suppliers.memoize(() -> PlayerLookup.tracking((Entity)player));
        switch (action) {
            case CHANNEL: {
                channelTickIndex = caster.getChannelTickIndex();
                incrementChannelTicks = 1;
                channelMultiplier = SpellHelper.channelValueMultiplier(spell);
                break;
            }
            case RELEASE: {
                if (SpellHelper.isChanneled(spell)) {
                    shouldPerformImpact = false;
                    channelMultiplier = 1.0f;
                } else {
                    channelMultiplier = progress >= 1.0f ? 1.0f : 0.0f;
                }
                SpellCastSyncHelper.clearCasting(player);
                break;
            }
        }
        Ammo.Result ammoResult = Ammo.ammoForSpell(player, spell, heldItemStack);
        if (channelMultiplier > 0.0f && ammoResult.satisfied()) {
            Spell.Target targeting = spell.target;
            boolean finished = action == SpellCast.Action.RELEASE || action == SpellCast.Action.TRIGGER && spell.type == Spell.Type.PASSIVE;
            boolean success = true;
            if (targeting.cap > 0) {
                targets = targets.stream().sorted(Comparator.comparingDouble(target -> target.distanceToSqr(player.position()))).limit(targeting.cap).toList();
            }
            Consumer<DeliveryCompletion> completion = null;
            if (finished) {
                float finalProgress = progress;
                List<Entity> finalTargets = targets;
                completion = arg_0 -> SpellHelper.lambda$performSpell$3(player, spell, spellEntry, world, (Supplier)trackingPlayers, castingSpeed, finalProgress, spellSource, spellId, heldItemStack, ammoResult, finalTargets, action, arg_0);
            }
            if (shouldPerformImpact) {
                success = false;
                ImpactContext context = new ImpactContext(channelMultiplier, 1.0f, null, SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)player), SpellHelper.focusMode(spell), channelTickIndex);
                switch (targeting.type) {
                    case NONE: {
                        success = SpellHelper.deliver(world, spellEntry, player, List.of(), context, null, completion);
                        break;
                    }
                    case CASTER: {
                        List<DeliveryTarget> targetsWithContext = List.of(new DeliveryTarget((Entity)player, context));
                        success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, null, completion);
                        break;
                    }
                    case AIM: {
                        Spell.Target.Aim aim = targeting.aim;
                        Optional firstTarget = targets.stream().findFirst();
                        List<DeliveryTarget> targetsWithContext = List.of();
                        if (firstTarget.isPresent()) {
                            Entity target2 = (Entity)firstTarget.get();
                            ImpactContext targetSpecificContext = context;
                            targetsWithContext = List.of(new DeliveryTarget(target2, targetSpecificContext));
                        }
                        if (!aim.required || firstTarget.isPresent()) {
                            success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, targetResult.location(), completion);
                        }
                        if (success || !aim.required || !firstTarget.isEmpty() || !(player instanceof ServerPlayer)) break;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)new Packets.SpellMessage("hud.cast_attempt_error.missing_target", ChatFormatting.RED));
                        break;
                    }
                    case AREA: {
                        Vec3 center = player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0);
                        Spell.Target.Area area = spell.target.area;
                        float range = SpellHelper.getRange(player, spellEntry) * player.getScale();
                        ImpactContext centeredContext = context;
                        double squaredRange = range * range;
                        List<DeliveryTarget> targetsWithContext = targets.stream().map(target -> {
                            float distanceBasedMultiplier = 1.0f;
                            switch (area.distance_dropoff) {
                                case NONE: {
                                    break;
                                }
                                case SQUARED: {
                                    distanceBasedMultiplier = (float)((squaredRange - target.distanceToSqr(center)) / squaredRange);
                                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                                }
                            }
                            return new DeliveryTarget((Entity)target, centeredContext.distance(distanceBasedMultiplier));
                        }).toList();
                        SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, null, completion, true, false);
                        break;
                    }
                    case BEAM: {
                        List<DeliveryTarget> targetsWithContext = targets.stream().map(target -> new DeliveryTarget((Entity)target, context)).toList();
                        success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, null, completion);
                        break;
                    }
                    case FROM_TRIGGER: {
                        List<DeliveryTarget> targetsWithContext = targets.stream().map(target -> new DeliveryTarget((Entity)target, context)).toList();
                        success = SpellHelper.deliver(world, spellEntry, player, targetsWithContext, context, targetResult.location(), completion);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)targeting.type));
                    }
                }
                caster.setChannelTickIndex(channelTickIndex + incrementChannelTicks);
            } else if (finished && completion != null) {
                completion.accept(new DeliveryCompletion(true));
            }
        }
    }

    private static void consumeSpellCost(Player player, float progress, SpellContainerSource.SourcedContainer spellSource, ResourceLocation spellId, Holder<Spell> spellEntry, ItemStack heldItemStack, Ammo.Result ammoResult, boolean scheduled) {
        Optional effect;
        Spell spell = (Spell)spellEntry.value();
        boolean batching = spell.cost.batching;
        if (batching && !scheduled) {
            if (((SpellBatcher)player).hasBatchedCost(spellId)) {
                return;
            }
            ((WorldScheduler)player.level()).schedule(0, () -> SpellHelper.consumeSpellCost(player, progress, spellSource, spellId, spellEntry, heldItemStack, ammoResult, true));
            ((SpellBatcher)player).batchCost(spellId, true);
            return;
        }
        SpellHelper.imposeCooldown(player, spellSource, spellId, spellEntry, progress);
        player.causeFoodExhaustion(spell.cost.exhaust * SpellEngineMod.config.spell_cost_exhaust_multiplier);
        if (SpellEngineMod.config.spell_cost_durability_allowed && spell.cost.durability > 0) {
            ItemStack stackToDamage = spellSource.itemStack() != null && spellSource.itemStack().isDamageableItem() ? spellSource.itemStack() : heldItemStack;
            stackToDamage.hurtAndBreak(spell.cost.durability, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        Ammo.consume(ammoResult, player);
        if (spell.cost.effect_id != null && (effect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)spell.cost.effect_id))).isPresent()) {
            player.removeEffect((Holder)effect.get());
        }
    }

    public static boolean deliver(Level world, Holder<Spell> spellEntry, Player caster, List<DeliveryTarget> targets, ImpactContext context, @Nullable Vec3 targetLocation, Consumer<DeliveryCompletion> completion) {
        return SpellHelper.deliver(world, spellEntry, caster, targets, context, targetLocation, completion, false, false);
    }

    public static boolean deliver(Level world, Holder<Spell> spellEntry, Player caster, List<DeliveryTarget> targets, ImpactContext context, @Nullable Vec3 targetLocation, @Nullable Consumer<DeliveryCompletion> completion, boolean forceSuccess, boolean scheduled) {
        Spell spell = (Spell)spellEntry.value();
        if (spell.deliver.delay > 0) {
            if (scheduled) {
                Predicate<Entity> validator = entity -> entity != null && !entity.isRemoved();
                if (!validator.test((Entity)caster)) {
                    return false;
                }
                targets = targets.stream().filter(target -> validator.test(target.entity)).toList();
            } else {
                List<DeliveryTarget> finalTargets = targets;
                ((WorldScheduler)world).schedule(spell.deliver.delay, () -> SpellHelper.deliver(world, spellEntry, caster, finalTargets, context, targetLocation, completion, forceSuccess, true));
                return true;
            }
        }
        boolean delivered = false;
        switch (spell.deliver.type) {
            case DIRECT: {
                boolean anySuccess = false;
                Vec3 casterPos = caster.position().add(0.0, (double)(caster.getBbHeight() / 2.0f), 0.0);
                if (targets.isEmpty() && targetLocation != null && spell.area_impact != null) {
                    Vec3 position = targetLocation.lerp(casterPos, (double)0.001f);
                    ImpactContext targetSpecificContext = context.position(position);
                    SpellHelper.performImpacts(world, (LivingEntity)caster, (Entity)caster, (Entity)caster, spellEntry, spell.impacts, targetSpecificContext);
                    anySuccess = true;
                } else {
                    for (DeliveryTarget targeted : targets) {
                        Entity target2 = targeted.entity;
                        Vec3 position = target2 == caster ? casterPos : target2.position().add(0.0, (double)(target2.getBbHeight() / 2.0f), 0.0).lerp(casterPos, (double)0.001f);
                        ImpactContext targetSpecificContext = targeted.context.position(position);
                        boolean result = SpellHelper.performImpacts(world, (LivingEntity)caster, target2, target2, spellEntry, spell.impacts, targetSpecificContext);
                        anySuccess = anySuccess || result;
                    }
                }
                delivered = anySuccess;
                break;
            }
            case PROJECTILE: {
                if (targets.isEmpty()) {
                    SpellHelper.shootProjectile(world, (LivingEntity)caster, null, spellEntry, context);
                } else {
                    for (DeliveryTarget targeted : targets) {
                        Entity target3 = targeted.entity;
                        ImpactContext targetSpecificContext = targeted.context;
                        SpellHelper.shootProjectile(world, (LivingEntity)caster, target3, spellEntry, targetSpecificContext);
                    }
                }
                delivered = true;
                break;
            }
            case METEOR: {
                boolean anyLaunched = false;
                if (targets.isEmpty() && targetLocation != null) {
                    SpellHelper.fallProjectile(world, (LivingEntity)caster, null, targetLocation, spellEntry, context);
                    anyLaunched = true;
                } else {
                    for (DeliveryTarget targeted : targets) {
                        Entity target4 = targeted.entity;
                        ImpactContext targetSpecificContext = targeted.context;
                        SpellHelper.fallProjectile(world, (LivingEntity)caster, target4, null, spellEntry, targetSpecificContext);
                        anyLaunched = true;
                    }
                }
                delivered = anyLaunched;
                break;
            }
            case CLOUD: {
                boolean placedAny = false;
                if (targets.isEmpty() && targetLocation != null) {
                    SpellHelper.placeCloud(world, (LivingEntity)caster, null, targetLocation, spellEntry, context.position(targetLocation));
                    placedAny = true;
                } else {
                    for (DeliveryTarget targeted : targets) {
                        Entity target5 = targeted.entity;
                        ImpactContext targetSpecificContext = targeted.context;
                        SpellHelper.placeCloud(world, (LivingEntity)caster, target5, null, spellEntry, targetSpecificContext);
                        placedAny = true;
                    }
                }
                delivered = placedAny;
                break;
            }
            case SHOOT_ARROW: {
                ArrowHelper.shootArrow(world, (LivingEntity)caster, spellEntry, context);
                delivered = true;
                break;
            }
            case STASH_EFFECT: {
                boolean anyAdded = false;
                Spell.Delivery.StashEffect stash = spell.deliver.stash_effect;
                ResourceLocation id = ResourceLocation.parse((String)stash.id);
                Holder.Reference effect = (Holder.Reference)BuiltInRegistries.MOB_EFFECT.getHolder(id).get();
                int amplifier = stash.amplifier;
                if (stash.amplifier_power_multiplier != 0.0f) {
                    SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)caster);
                    amplifier += (int)((double)stash.amplifier_power_multiplier * power.nonCriticalValue());
                }
                if (caster instanceof Player) {
                    Player player = caster;
                    List<Spell.Modifier> spellModifiers = SpellModifiers.of(player, spellEntry);
                    for (Spell.Modifier modifier : spellModifiers) {
                        amplifier += modifier.stash_amplifier_add;
                    }
                }
                for (DeliveryTarget targeted : targets) {
                    Entity modifier = targeted.entity();
                    if (!(modifier instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)modifier;
                    if (stash.stacking) {
                        int stack = -1;
                        MobEffectInstance existingInstance = livingEntity.getEffect((Holder)effect);
                        if (existingInstance != null) {
                            stack = existingInstance.getAmplifier();
                            livingEntity.removeEffect((Holder)effect);
                        }
                        MobEffectInstance instance = new MobEffectInstance((Holder)effect, (int)(stash.duration * 20.0f), Math.min(++stack, amplifier), false, stash.show_particles, true);
                        livingEntity.addEffect(instance);
                    } else {
                        MobEffectInstance instance = new MobEffectInstance((Holder)effect, (int)(stash.duration * 20.0f), amplifier, false, stash.show_particles, true);
                        livingEntity.addEffect(instance);
                    }
                    anyAdded = true;
                }
                delivered = anyAdded;
                break;
            }
            case CUSTOM: {
                SpellHandlers.CustomDelivery handler;
                if (spell.deliver.custom == null || (handler = SpellHandlers.customDelivery.get(spell.deliver.custom.handler)) == null) break;
                delivered = handler.onSpellDelivery(world, spellEntry, caster, targets, context, targetLocation);
            }
        }
        if (completion != null) {
            completion.accept(new DeliveryCompletion(delivered || forceSuccess));
        }
        return delivered;
    }

    public static void imposeCooldown(Player player, SpellContainerSource.SourcedContainer source, ResourceLocation spellId, Holder<Spell> spellEntry, float progress) {
        Spell spell = (Spell)spellEntry.value();
        float duration = SpellHelper.cooldownToSet((LivingEntity)player, spellEntry, progress);
        int durationTicks = Math.round(duration * 20.0f);
        if (duration > 0.0f) {
            ((SpellCasterEntity)player).getCooldownManager().set(spellId, durationTicks);
        }
        if (SpellEngineMod.config.spell_item_cooldown_lock && spell.cost.cooldown.hosting_item && source.itemStack() != null) {
            Item hostingItem = source.itemStack().getItem();
            ItemCooldowns itemCooldowns = player.getCooldowns();
            float durationLeft = (float)((ItemCooldownManagerExtension)itemCooldowns).SE_getLastCooldownDuration(hostingItem) * itemCooldowns.getCooldownPercent(hostingItem, 0.0f);
            if ((float)durationTicks > durationLeft) {
                itemCooldowns.addCooldown(hostingItem, durationTicks);
            }
        }
    }

    private static float cooldownToSet(LivingEntity caster, Holder<Spell> spellEntry, float progress) {
        Spell spell = (Spell)spellEntry.value();
        if (spell.cost.cooldown.proportional) {
            return SpellHelper.getCooldownDuration(caster, spellEntry) * progress;
        }
        return SpellHelper.getCooldownDuration(caster, spellEntry);
    }

    public static float launchHeight(LivingEntity livingEntity) {
        float eyeHeight = livingEntity.getEyeHeight();
        double shoulderDistance = (double)livingEntity.getBbHeight() * 0.15;
        return (float)(((double)eyeHeight - shoulderDistance) * (double)livingEntity.getAgeScale());
    }

    public static Vec3 launchPoint(LivingEntity caster) {
        return SpellHelper.launchPoint(caster, launchPointOffsetDefault);
    }

    public static Vec3 launchPoint(LivingEntity caster, float forward) {
        Vec3 look = caster.getLookAngle().scale((double)(forward * caster.getAgeScale()));
        return caster.position().add(0.0, (double)SpellHelper.launchHeight(caster), 0.0).add(look);
    }

    public static void shootProjectile(Level world, LivingEntity caster, Entity target, Holder<Spell> spellEntry, ImpactContext context) {
        SpellHelper.shootProjectile(world, caster, target, spellEntry, context, 0);
    }

    public static void shootProjectile(Level world, LivingEntity caster, Entity target, Holder<Spell> spellEntry, ImpactContext context, int sequenceIndex) {
        boolean allowExtraShoot;
        float directionYaw;
        if (world.isClientSide) {
            return;
        }
        Spell spell = (Spell)spellEntry.value();
        Vec3 launchPoint = SpellHelper.launchPoint(caster);
        Spell.Delivery.ShootProjectile data = spell.deliver.projectile;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        if (caster instanceof Player) {
            Player player = (Player)caster;
            List<Spell.Modifier> spellModifiers = SpellModifiers.of(player, spellEntry);
            for (Spell.Modifier modifier : spellModifiers) {
                if (modifier.projectile_launch != null) {
                    mutableLaunchProperties.mutatingCombine(modifier.projectile_launch);
                }
                if (modifier.projectile_perks == null) continue;
                mutablePerks.mutatingCombine(modifier.projectile_perks);
            }
        }
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.x(), launchPoint.y(), launchPoint.z(), SpellProjectile.Behaviour.FLY, spellEntry, context, mutablePerks);
        if (SpellEvents.PROJECTILE_SHOOT.isListened()) {
            SpellEvents.PROJECTILE_SHOOT.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellEntry, context, sequenceIndex)));
        }
        float velocity = mutableLaunchProperties.velocity;
        float divergence = projectileData.divergence;
        float directionPitch = data.inherit_shooter_pitch ? caster.getXRot() : 0.0f;
        float f = directionYaw = data.inherit_shooter_yaw ? caster.getYRot() : 0.0f;
        if (data.direct_towards_target && target != null) {
            Vec3 directionVector = target.position().subtract(caster.position()).normalize();
            directionPitch = (float)VectorHelper.pitchFromNormalized(directionVector);
            directionYaw = (float)VectorHelper.yawFromNormalized(directionVector);
        }
        if (data.inherit_shooter_velocity) {
            projectile.shootFromRotation((Entity)caster, directionPitch, directionYaw, 0.0f, velocity, divergence);
        } else {
            if (!(data.direction_offsets == null || data.direction_offsets.length <= 0 || data.direction_offsets_require_target && target == null)) {
                int baseIndex = context.isChanneled() ? context.channelTickIndex() : sequenceIndex;
                int index = baseIndex % data.direction_offsets.length;
                Spell.Delivery.ShootProjectile.DirectionOffset offset = data.direction_offsets[index];
                directionPitch += offset.pitch;
                directionYaw += offset.yaw;
            }
            Vec3 look = caster.calculateViewVector(directionPitch, directionYaw).normalize();
            projectile.shoot(look.x, look.y, look.z, velocity, divergence);
        }
        projectile.range = spell.range;
        projectile.setXRot(directionPitch);
        projectile.setYRot(directionYaw);
        projectile.setFollowedTarget(target);
        world.addFreshEntity((Entity)projectile);
        SoundHelper.playSound(world, (Entity)projectile, mutableLaunchProperties.sound);
        boolean bl = context.isChanneled() && mutableLaunchProperties.extra_launch_mod >= 0 ? context.channelTickIndex() % mutableLaunchProperties.extra_launch_mod == 0 : (allowExtraShoot = true);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0 && allowExtraShoot) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.isAlive()) {
                        return;
                    }
                    SpellHelper.shootProjectile(world, caster, target, spellEntry, context, nextSequenceIndex);
                });
            }
        }
    }

    public static boolean fallProjectile(Level world, LivingEntity caster, Entity target, @Nullable Vec3 targetLocation, Holder<Spell> spellEntry, ImpactContext context) {
        return SpellHelper.fallProjectile(world, caster, target, targetLocation, spellEntry, context, 0);
    }

    public static boolean fallProjectile(Level world, LivingEntity caster, Entity target, @Nullable Vec3 targetLocation, Holder<Spell> spellEntry, ImpactContext context, int sequenceIndex) {
        Vec3 targetPosition;
        if (world.isClientSide) {
            return false;
        }
        Vec3 vec3 = targetPosition = target != null ? target.position() : targetLocation;
        if (targetPosition == null) {
            return false;
        }
        Spell spell = (Spell)spellEntry.value();
        Spell.Delivery.Meteor meteor = spell.deliver.meteor;
        float height = meteor.launch_height;
        Vec3 launchPoint = targetPosition.add(0.0, (double)height, 0.0);
        Spell.Delivery.Meteor data = spell.deliver.meteor;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        if (caster instanceof Player) {
            Player player = (Player)caster;
            List<Spell.Modifier> spellModifiers = SpellModifiers.of(player, spellEntry);
            for (Spell.Modifier modifier : spellModifiers) {
                if (modifier.projectile_launch != null) {
                    mutableLaunchProperties.mutatingCombine(modifier.projectile_launch);
                }
                if (modifier.projectile_perks == null) continue;
                mutablePerks.mutatingCombine(modifier.projectile_perks);
            }
        }
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.x(), launchPoint.y(), launchPoint.z(), SpellProjectile.Behaviour.FALL, spellEntry, context, mutablePerks);
        if (SpellEvents.PROJECTILE_FALL.isListened()) {
            SpellEvents.PROJECTILE_FALL.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellEntry, context, sequenceIndex)));
        }
        projectile.setYRot(0.0f);
        projectile.setXRot(90.0f);
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.divergence_requires_sequence)) {
            projectile.setVelocity(0.0, -1.0, 0.0, mutableLaunchProperties.velocity, 0.5f, projectileData.divergence);
        } else {
            projectile.setDeltaMovement(new Vec3(0.0, (double)(-mutableLaunchProperties.velocity), 0.0));
        }
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.follow_target_requires_sequence)) {
            projectile.setFollowedTarget(target);
        } else {
            projectile.setFollowedTarget(null);
        }
        if (meteor.launch_radius > 0.0f && SpellHelper.launchSequenceEligible(sequenceIndex, meteor.offset_requires_sequence)) {
            double randomAngle = Math.toRadians(world.random.nextFloat() * 360.0f);
            Vec3 offset = new Vec3((double)meteor.launch_radius, 0.0, 0.0).yRot((float)randomAngle);
            projectile.setPos(projectile.position().add(offset));
        }
        projectile.yRotO = projectile.getYRot();
        projectile.xRotO = projectile.getXRot();
        projectile.range = height;
        world.addFreshEntity((Entity)projectile);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.isAlive()) {
                        return;
                    }
                    SpellHelper.fallProjectile(world, caster, target, targetLocation, spellEntry, context, nextSequenceIndex);
                });
            }
        }
        return true;
    }

    private static boolean launchSequenceEligible(int index, int rule) {
        if (rule == 0) {
            return false;
        }
        if (rule > 0) {
            return index >= rule;
        }
        return index < -1 * rule;
    }

    private static void directImpact(Level world, LivingEntity caster, Entity target, Holder<Spell> spellEntry, ImpactContext context) {
        SpellHelper.performImpacts(world, caster, target, target, spellEntry, ((Spell)spellEntry.value()).impacts, context);
    }

    private static void beamImpact(Level world, LivingEntity caster, List<Entity> targets, Holder<Spell> spellEntry, ImpactContext context) {
        for (Entity target : targets) {
            SpellHelper.performImpacts(world, caster, target, target, spellEntry, ((Spell)spellEntry.value()).impacts, context.position(target.position()));
        }
    }

    public static void fallImpact(LivingEntity caster, Entity projectile, Holder<Spell> spellEntry, ImpactContext context) {
        Vec3 adjustedCenter = context.position().add(0.0, 1.0, 0.0);
        SpellHelper.performImpacts(projectile.level(), caster, null, projectile, spellEntry, ((Spell)spellEntry.value()).impacts, context.position(adjustedCenter));
    }

    public static boolean projectileImpact(LivingEntity caster, Entity projectile, Entity target, Holder<Spell> spellEntry, ImpactContext context) {
        return SpellHelper.performImpacts(projectile.level(), caster, target, projectile, spellEntry, ((Spell)spellEntry.value()).impacts, context);
    }

    public static boolean arrowImpact(LivingEntity caster, Entity projectile, Entity target, Holder<Spell> spellEntry, ImpactContext context) {
        Spell spell = (Spell)spellEntry.value();
        if (spell.impacts != null) {
            if (context.power() == null) {
                context = context.power(SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)caster));
            }
            return SpellHelper.performImpacts(projectile.level(), caster, target, projectile, spellEntry, spell.impacts, context);
        }
        return false;
    }

    public static boolean lookupAndPerformAreaImpact(Spell.AreaImpact area_impact, Holder<Spell> spellEntry, LivingEntity caster, Entity exclude, Entity aoeSource, List<Spell.Impact> impacts, ImpactContext context, boolean additionalTargetLookup) {
        Vec3 center = context.position();
        float radius = area_impact.combinedRadius(context.power().baseValue());
        List<Entity> targets = TargetHelper.targetsFromArea(aoeSource, center, radius, area_impact.area, null);
        if (exclude != null) {
            targets.remove(exclude);
        }
        boolean result = SpellHelper.applyAreaImpact(aoeSource.level(), caster, targets, radius, area_impact.area, spellEntry, impacts, context.target(SpellTarget.FocusMode.AREA), additionalTargetLookup, area_impact.execute_action_type);
        ParticleHelper.sendBatches(aoeSource, area_impact.particles);
        SoundHelper.playSound(aoeSource.level(), aoeSource, area_impact.sound);
        return result;
    }

    private static boolean applyAreaImpact(Level world, LivingEntity caster, List<Entity> targets, float range, Spell.Target.Area area, Holder<Spell> spellEntry, List<Spell.Impact> impacts, ImpactContext context, boolean additionalTargetLookup, @Nullable Spell.Impact.Action.Type filteredAction) {
        double squaredRange = range * range;
        Vec3 center = context.position();
        boolean anyPerformed = false;
        for (Entity target : targets) {
            float distanceBasedMultiplier = 1.0f;
            switch (area.distance_dropoff) {
                case NONE: {
                    break;
                }
                case SQUARED: {
                    distanceBasedMultiplier = (float)((squaredRange - target.distanceToSqr(center)) / squaredRange);
                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                }
            }
            anyPerformed = SpellHelper.performImpacts(world, caster, target, target, spellEntry, impacts, context.distance(distanceBasedMultiplier), additionalTargetLookup, filteredAction);
        }
        return anyPerformed;
    }

    public static boolean performImpacts(Level world, LivingEntity caster, @Nullable Entity target, Entity aoeSource, Holder<Spell> spellEntry, List<Spell.Impact> impacts, ImpactContext context) {
        return SpellHelper.performImpacts(world, caster, target, aoeSource, spellEntry, impacts, context, true, null);
    }

    public static boolean performImpacts(Level world, LivingEntity caster, @Nullable Entity target, Entity aoeSource, Holder<Spell> spellEntry, List<Spell.Impact> impacts, ImpactContext context, boolean additionalTargetLookup, @Nullable Spell.Impact.Action.Type filteredAction) {
        boolean anyPerformed;
        Player player;
        Collection trackers = target != null ? PlayerLookup.tracking((Entity)target) : null;
        Spell spell = (Spell)spellEntry.value();
        SpellTarget.Intent selectedIntent = null;
        Spell.AreaImpact area_impact = spell.area_impact;
        ArrayList<Spell.Impact> mutableImpacts = new ArrayList<Spell.Impact>(impacts);
        if (caster instanceof Player) {
            Player player2 = (Player)caster;
            List<Spell.Modifier> modifiers = SpellModifiers.of(player2, spellEntry);
            for (Spell.Modifier modifier : modifiers) {
                if (modifier.mutate_impacts != null) {
                    switch (modifier.mutate_impacts) {
                        case PREPEND: {
                            mutableImpacts.addAll(0, modifier.impacts);
                            break;
                        }
                        case APPEND: {
                            mutableImpacts.addAll(modifier.impacts);
                        }
                    }
                }
                if (modifier.replacing_area_impact == null) continue;
                area_impact = modifier.replacing_area_impact;
            }
        }
        boolean perform = true;
        if (additionalTargetLookup && area_impact != null && area_impact.force_indirect) {
            perform = false;
        }
        EnumSet<Spell.Impact.Action.Type> performedActionTypes = EnumSet.noneOf(Spell.Impact.Action.Type.class);
        if (perform) {
            for (Spell.Impact impact : mutableImpacts) {
                boolean result;
                SpellTarget.Intent intent = SpellHelper.impactIntent(impact.action);
                if (!impact.action.apply_to_caster && selectedIntent != null && selectedIntent != intent || filteredAction != null && impact.action.type != filteredAction || additionalTargetLookup && !impact.action.allow_on_center_target || target == null || !(result = SpellHelper.performImpact(world, caster, target, spellEntry, impact, context, trackers))) continue;
                performedActionTypes.add(impact.action.type);
                selectedIntent = intent;
            }
        }
        if (area_impact != null && additionalTargetLookup && (SpellHelper.shouldApplyAreaImpact(area_impact, performedActionTypes) || target == null)) {
            Entity exclude = area_impact.force_indirect ? null : target;
            SpellHelper.lookupAndPerformAreaImpact(area_impact, spellEntry, caster, exclude, aoeSource, impacts, context, false);
            if (caster instanceof Player) {
                player = (Player)caster;
                ((WorldScheduler)world).schedule(0, () -> {
                    Vec3 location = target != null ? target.position() : context.position;
                    SpellTriggers.onSpellAreaImpact(player, target, location, spellEntry);
                });
            }
        }
        boolean bl = anyPerformed = !performedActionTypes.isEmpty();
        if (anyPerformed && caster instanceof Player) {
            player = (Player)caster;
            ((WorldScheduler)world).schedule(0, () -> SpellTriggers.onSpellImpactAny(player, target, aoeSource, spellEntry));
        }
        return anyPerformed;
    }

    private static boolean shouldApplyAreaImpact(Spell.AreaImpact areaImpact, EnumSet<Spell.Impact.Action.Type> performedActionTypes) {
        if (areaImpact.triggering_action_type == null) {
            return true;
        }
        return performedActionTypes.contains((Object)areaImpact.triggering_action_type);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static boolean performImpact(Level world, LivingEntity caster, Entity target, Holder<Spell> spellEntry, Spell.Impact impact, ImpactContext context, Collection<ServerPlayer> trackers) {
        block96: {
            if (!target.isAttackable()) {
                return false;
            }
            success = false;
            critical = false;
            isKnockbackPushed = false;
            spell = (Spell)spellEntry.value();
            try {
                if (impact.chance < 1.0f && world.random.nextFloat() > impact.chance) {
                    return false;
                }
                school = impact.school != null ? impact.school : spell.school;
                originalTarget = target;
                if (impact.action.apply_to_caster) {
                    target = caster;
                } else {
                    intent = SpellHelper.impactIntent(impact.action);
                    if (!EntityRelations.actionAllowed(context.focusMode(), intent, caster, target)) {
                        return false;
                    }
                    if (intent == SpellTarget.Intent.HARMFUL && context.focusMode() == SpellTarget.FocusMode.AREA && ((EntityImmunity)target).isImmuneTo(EntityImmunity.Type.AREA_EFFECT)) {
                        return false;
                    }
                }
                mergedTargetModifiers = new ArrayList<Spell.Impact.TargetModifier>(impact.target_modifiers);
                schoolWeaknesses = SpellSchoolWeakness.getWeaknesses(school);
                if (!schoolWeaknesses.isEmpty()) {
                    for (ScopedWeakness schoolWeakness : schoolWeaknesses) {
                        if (schoolWeakness.impact_type() != null && schoolWeakness.impact_type() != impact.action.type) continue;
                        mergedTargetModifiers.addFirst(schoolWeakness.weakness());
                    }
                }
                conditionResult = SpellHelper.evaluateImpactConditions(target, caster, mergedTargetModifiers);
                if (!conditionResult.allowed) {
                    return false;
                }
                targetWasAlive = true;
                if (target instanceof LivingEntity) {
                    livingEntity = (LivingEntity)target;
                    targetWasAlive = livingEntity.isAlive();
                }
                spellModifiers = List.of();
                if (caster instanceof Player) {
                    player = (Player)caster;
                    spellModifiers = SpellModifiers.ofImpact(player, spellEntry, impact);
                }
                particleMultiplier = 1.0f * context.total();
                power = context.power();
                if (power == null || power.school() != school) {
                    power = SpellPower.getSpellPower((SpellSchool)school, (LivingEntity)caster);
                }
                if (impact.attribute != null) {
                    attributeOverride = (Holder.Reference)BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)impact.attribute)).get();
                    value = impact.attribute_from_target != false && originalTarget instanceof LivingEntity != false ? ((livingEntity = (LivingEntity)originalTarget).getAttributes().hasAttribute((Holder)attributeOverride) != false ? livingEntity.getAttributeValue((Holder)attributeOverride) : 0.0) : caster.getAttributeValue((Holder)attributeOverride);
                    power = new SpellPower.Result(power.school(), value, power.criticalChance(), power.criticalDamage());
                }
                powerModifiers = new ArrayList<Spell.Impact.Modifier>(conditionResult.modifiers());
                for (Spell.Modifier spellModifier : spellModifiers) {
                    if (spellModifier.power_modifier == null) continue;
                    powerModifiers.add(spellModifier.power_modifier);
                }
                bonusPower = 1.0f + powerModifiers.stream().map((Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$17(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)()).floatValue();
                bonusCritChance = powerModifiers.stream().map((Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$18(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)());
                bonusCritDamage = powerModifiers.stream().map((Function<Spell.Impact.Modifier, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$performImpact$19(net.spell_engine.api.spell.Spell$Impact$Modifier ), (Lnet/spell_engine/api/spell/Spell$Impact$Modifier;)Ljava/lang/Float;)()).reduce(Float.valueOf(0.0f), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, sum(float float ), (Ljava/lang/Float;Ljava/lang/Float;)Ljava/lang/Float;)());
                if ((power = new SpellPower.Result(power.school(), power.baseValue() * (double)bonusPower, power.criticalChance() + (double)bonusCritChance.floatValue(), power.criticalDamage() + (double)bonusCritDamage.floatValue())).baseValue() < (double)impact.action.min_power || power.baseValue() > (double)impact.action.max_power) {
                    clampedValue = Mth.clamp((double)power.baseValue(), (double)impact.action.min_power, (double)impact.action.max_power);
                    power = new SpellPower.Result(power.school(), clampedValue, power.criticalChance(), power.criticalDamage());
                }
                switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Type[impact.action.type.ordinal()]) {
                    case 1: {
                        damageData = impact.action.damage;
                        extraKnockback = 1.0f;
                        for (Spell.Modifier spellModifier : spellModifiers) {
                            extraKnockback += spellModifier.knockback_multiply_base;
                        }
                        knockbackMultiplier = Math.max(0.0f, damageData.knockback * context.total() * extraKnockback);
                        vulnerability = SpellPower.Vulnerability.none;
                        timeUntilRegen = target.invulnerableTime;
                        if (target instanceof LivingEntity) {
                            livingEntity = (LivingEntity)target;
                            ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(context.hasOffset() != false ? 0.0f : knockbackMultiplier);
                            isKnockbackPushed = true;
                            if (damageData.bypass_iframes && SpellEngineMod.config.bypass_iframes) {
                                target.invulnerableTime = 0;
                            }
                            vulnerability = SpellPower.getVulnerability((LivingEntity)livingEntity, (SpellSchool)school);
                        }
                        result = power.random(vulnerability);
                        critical = result.isCritical();
                        amount = result.amount();
                        amount *= (double)damageData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((LivingEntity)caster, (SpellSchool)school);
                        }
                        particleMultiplier = power.criticalDamage() + (double)vulnerability.criticalDamageBonus();
                        if (caster instanceof Player) {
                            player = (Player)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        caster.setLastHurtMob(target);
                        damageSource = SpellDamageSource.create((SpellSchool)school, (LivingEntity)caster);
                        ((DamageSourceExtension)damageSource).setSpellIndirect(context.focusMode() != SpellTarget.FocusMode.DIRECT);
                        target.hurt(damageSource, (float)amount);
                        if (target instanceof LivingEntity) {
                            livingEntity = (LivingEntity)target;
                            ((ConfigurableKnockback)livingEntity).popKnockbackMultiplier_SpellEngine();
                            isKnockbackPushed = false;
                            target.invulnerableTime = timeUntilRegen;
                            if (context.hasOffset()) {
                                direction = context.knockbackDirection(livingEntity.position()).reverse();
                                livingEntity.knockback((double)(0.4f * knockbackMultiplier), direction.x, direction.z);
                            }
                        }
                        success = true;
                        break;
                    }
                    case 2: {
                        if (!(target instanceof LivingEntity)) break;
                        livingTarget = (LivingEntity)target;
                        healData = impact.action.heal;
                        particleMultiplier = power.criticalDamage();
                        result = power.random();
                        critical = result.isCritical();
                        amount = result.amount();
                        amount *= (double)healData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((LivingEntity)caster, (SpellSchool)school);
                        }
                        if (caster instanceof Player) {
                            player = (Player)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        livingTarget.heal((float)amount);
                        if (SpellEvents.HEAL.isListened()) {
                            finalAmount = (float)amount;
                            SpellEvents.HEAL.invoke((Consumer<SpellEvents.HealEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$performImpact$20(net.minecraft.world.entity.LivingEntity net.minecraft.core.Holder net.minecraft.world.entity.LivingEntity float net.spell_engine.api.spell.event.SpellEvents$HealEvent ), (Lnet/spell_engine/api/spell/event/SpellEvents$HealEvent;)V)((LivingEntity)caster, spellEntry, (LivingEntity)livingTarget, (float)finalAmount));
                        }
                        success = true;
                        break;
                    }
                    case 3: {
                        data = impact.action.status_effect;
                        if (target instanceof LivingEntity) {
                            livingTarget = (LivingEntity)target;
                            optionalEffect = Optional.empty();
                            if (data.remove != null) {
                                effects = livingTarget.getActiveEffects().stream().filter((Predicate<MobEffectInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$performImpact$21(net.spell_engine.api.spell.Spell$Impact$Action$StatusEffect net.minecraft.world.effect.MobEffectInstance ), (Lnet/minecraft/world/effect/MobEffectInstance;)Z)((Spell.Impact.Action.StatusEffect)data)).toList();
                                if (effects.isEmpty()) {
                                    return false;
                                }
                                switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$StatusEffect$Remove$Selector[data.remove.selector.ordinal()]) {
                                    case 1: {
                                        optionalEffect = Optional.of(effects.get(world.random.nextInt(effects.size()))).map((Function<MobEffectInstance, Holder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getEffect(), (Lnet/minecraft/world/effect/MobEffectInstance;)Lnet/minecraft/core/Holder;)());
                                        break;
                                    }
                                    case 2: {
                                        optionalEffect = Optional.of(effects.getFirst()).map((Function<MobEffectInstance, Holder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getEffect(), (Lnet/minecraft/world/effect/MobEffectInstance;)Lnet/minecraft/core/Holder;)());
                                    }
                                }
                            } else {
                                id = ResourceLocation.parse((String)data.effect_id);
                                optionalEffect = Optional.of((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(id).get());
                            }
                            if (optionalEffect.isEmpty()) {
                                return false;
                            }
                            effect = (Holder)optionalEffect.get();
                            if (!SpellHelper.underApplyLimit(power, livingTarget, school, data.apply_limit)) {
                                return false;
                            }
                            extraDuration = 0.0f;
                            extraAmplifier = 0;
                            extraCap = 0;
                            for (Spell.Modifier spellModifier : spellModifiers) {
                                extraDuration += spellModifier.effect_duration_add;
                                extraAmplifier += spellModifier.effect_amplifier_add;
                                extraCap += spellModifier.effect_amplifier_cap_add;
                            }
                            amplifier = data.amplifier + (int)((double)data.amplifier_power_multiplier * power.nonCriticalValue());
                            amplifier += extraAmplifier;
                            switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$StatusEffect$ApplyMode[data.apply_mode.ordinal()]) {
                                case 1: 
                                case 2: {
                                    if (target.getType().is(SpellEngineEntityTags.bosses) && (StatusEffectClassification.isMovementImpairing((Holder<MobEffect>)effect) || StatusEffectClassification.disablesMobAI((Holder<MobEffect>)effect))) {
                                        return false;
                                    }
                                    duration = Math.round((data.duration + extraDuration) * 20.0f);
                                    showParticles = data.show_particles;
                                    cap = data.amplifier_cap + (int)((double)data.amplifier_cap_power_multiplier * power.nonCriticalValue()) + extraCap;
                                    if (data.apply_mode == Spell.Impact.Action.StatusEffect.ApplyMode.ADD) {
                                        currentEffect = livingTarget.getEffect(effect);
                                        increment = amplifier;
                                        newAmplifier = Math.max(increment - 1, 0);
                                        if (currentEffect != null) {
                                            currentAmplifier = currentEffect.getAmplifier();
                                            incrementedAmplifier = currentAmplifier + increment;
                                            newAmplifier = Math.min(incrementedAmplifier, cap);
                                            if (!data.refresh_duration) {
                                                if (currentAmplifier == newAmplifier) {
                                                    return false;
                                                }
                                                duration = currentEffect.getDuration();
                                            }
                                        }
                                        amplifier = newAmplifier;
                                    } else if (cap > 0) {
                                        amplifier = Math.min(amplifier, cap);
                                    }
                                    if (caster instanceof Player) {
                                        player = (Player)caster;
                                        SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                                    }
                                    instance = new MobEffectInstance(effect, duration, amplifier, false, showParticles, true);
                                    livingTarget.addEffect(instance, (Entity)caster);
                                    success = true;
                                    break;
                                }
                                case 3: {
                                    if (data.amplifier_cap > 0) {
                                        amplifier = Math.min(amplifier, data.amplifier_cap);
                                    }
                                    if (!livingTarget.hasEffect(effect)) break;
                                    if (caster instanceof Player) {
                                        player = (Player)caster;
                                        SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                                    }
                                    currentEffect = livingTarget.getEffect(effect);
                                    newAmplifier = amplifier > 0 ? currentEffect.getAmplifier() - amplifier : -1;
                                    StatusEffectUtil.applyChanges(livingTarget, List.of(new StatusEffectUtil.Diff(currentEffect, newAmplifier)));
                                    success = true;
                                }
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (caster instanceof Player) {
                            player = (Player)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        data = impact.action.fire;
                        target.igniteForSeconds(data.duration);
                        if (target.getRemainingFireTicks() > 0) {
                            target.setRemainingFireTicks(target.getRemainingFireTicks() + data.tick_offset);
                        }
                        success = target.isOnFire();
                        break;
                    }
                    case 5: {
                        spawns = impact.action.spawns;
                        if (spawns == null || spawns.isEmpty()) {
                            return false;
                        }
                        extraTimeToLive = 0.0f;
                        for (Spell.Modifier spellModifier : spellModifiers) {
                            extraTimeToLive += spellModifier.spawn_duration_add;
                        }
                        for (Spell.Impact.Action.Spawn data : spawns) {
                            mutableData = data.copy();
                            mutableData.time_to_live_seconds = (int)((float)mutableData.time_to_live_seconds + extraTimeToLive);
                            id = ResourceLocation.parse((String)mutableData.entity_type_id);
                            type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
                            entity = type.create(world);
                            SpellHelper.applyEntityPlacement(entity, (Entity)caster, target.position(), mutableData.placement);
                            if (entity instanceof SpellEntity.Spawned) {
                                spellSpawnedEntity = (SpellEntity.Spawned)entity;
                                args = new SpellEntity.Spawned.Args(caster, spellEntry, mutableData, context);
                                spellSpawnedEntity.onSpawnedBySpell(args);
                            }
                            if (caster instanceof Player) {
                                player = (Player)caster;
                                SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                            }
                            ((WorldScheduler)world).schedule(mutableData.delay_ticks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performImpact$22(net.minecraft.world.level.Level net.minecraft.world.entity.Entity ), ()V)((Level)world, (Entity)entity));
                            success = true;
                        }
                        break;
                    }
                    case 6: {
                        data = impact.action.teleport;
                        if (!(target instanceof LivingEntity)) break;
                        livingTarget = (LivingEntity)target;
                        teleportedEntity = null;
                        destination = null;
                        startingPosition = null;
                        applyRotation = null;
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Teleport$Mode[data.mode.ordinal()]) {
                            case 1: {
                                teleportedEntity = livingTarget;
                                forward = data.forward;
                                look = target.getLookAngle();
                                startingPosition = target.position();
                                destination = TargetHelper.findTeleportDestination(teleportedEntity, look, forward.distance, data.required_clearance_block_y);
                                groundJustBelow = TargetHelper.findSolidBlockBelow((Entity)teleportedEntity, destination, target.level(), -1.5f);
                                if (groundJustBelow == null) break;
                                destination = groundJustBelow;
                                break;
                            }
                            case 2: {
                                if (livingTarget == caster) {
                                    return false;
                                }
                                look = target.getLookAngle();
                                distance = 1.0f;
                                if (data.behind_target != null) {
                                    distance = data.behind_target.distance;
                                }
                                teleportedEntity = caster;
                                startingPosition = caster.position();
                                destination = target.position().add(look.scale((double)(-distance)));
                                groundJustBelow = TargetHelper.findSolidBlockBelow((Entity)teleportedEntity, destination, target.level(), -1.5f);
                                if (groundJustBelow != null) {
                                    destination = groundJustBelow;
                                }
                                yaw = (yaw = (float)Math.toDegrees(Math.atan2(-(x = look.x), z = look.z))) < 0.0f ? yaw + 360.0f : yaw;
                                applyRotation = Float.valueOf(yaw);
                            }
                        }
                        if (destination == null || startingPosition == null || teleportedEntity == null) break;
                        ParticleHelper.sendBatches((Entity)teleportedEntity, data.depart_particles, false);
                        world.gameEvent((Holder)GameEvent.TELEPORT, startingPosition, GameEvent.Context.of((Entity)teleportedEntity));
                        if (applyRotation == null || !(teleportedEntity instanceof ServerPlayer)) ** GOTO lbl-1000
                        serverPlayer = (ServerPlayer)teleportedEntity;
                        if (world instanceof ServerLevel) {
                            serverWorld = (ServerLevel)world;
                            if (caster instanceof Player) {
                                player = (Player)caster;
                                SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                            }
                            serverPlayer.teleportTo(serverWorld, destination.x, destination.y, destination.z, applyRotation.floatValue(), serverPlayer.getXRot());
                        } else lbl-1000:
                        // 2 sources

                        {
                            teleportedEntity.randomTeleport(destination.x, destination.y, destination.z, false);
                        }
                        success = true;
                        ParticleHelper.sendBatches((Entity)teleportedEntity, data.arrive_particles, false);
                        break;
                    }
                    case 7: {
                        cooldown = impact.action.cooldown;
                        modified = false;
                        if (cooldown != null && target instanceof Player) {
                            playerTarget = (Player)target;
                            if (caster instanceof Player) {
                                player = (Player)caster;
                                SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                            }
                            cooldownManager = ((SpellCasterEntity)playerTarget).getCooldownManager();
                            if (cooldown.actives != null) {
                                spells = SpellContainerSource.activeSpellsOf(playerTarget);
                                v0 = modified = modified != false || SpellHelper.modifyCooldowns(spells, cooldown.actives, cooldownManager) != false;
                            }
                            if (cooldown.passives != null) {
                                spells = SpellContainerSource.passiveSpellsOf(playerTarget);
                                v1 = modified = modified != false || SpellHelper.modifyCooldowns(spells, cooldown.passives, cooldownManager) != false;
                            }
                            if (modified) {
                                cooldownManager.update(false);
                                cooldownManager.pushSync();
                            }
                        }
                        success = modified;
                        break;
                    }
                    case 8: {
                        if (!(target instanceof Mob)) break;
                        mob = (Mob)target;
                        aggroData = impact.action.aggro;
                        if (aggroData == null) {
                            return false;
                        }
                        if (aggroData.only_if_targeted && mob.getTarget() != caster) {
                            return false;
                        }
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Aggro$Mode[aggroData.mode.ordinal()]) {
                            case 1: {
                                mob.setTarget(caster);
                                break;
                            }
                            case 2: {
                                mob.setTarget(null);
                            }
                        }
                        success = true;
                        break;
                    }
                    case 9: {
                        if (impact.action.custom == null || (handler = SpellHandlers.customImpact.get(impact.action.custom.handler)) == null) break;
                        if (caster instanceof Player) {
                            player = (Player)caster;
                            SpellTriggers.onSpellImpactSpecific(player, target, spellEntry, impact, critical, Spell.Trigger.Stage.PRE);
                        }
                        result = handler.onSpellImpact(spellEntry, power, caster, target, context);
                        particleMultiplier = power.criticalDamage();
                        success = result.success();
                        critical = result.critical();
                    }
                }
                if (success) {
                    if (impact.particles != null) {
                        countMultiplier = critical != false ? (float)particleMultiplier : 1.0f;
                        ParticleHelper.sendBatches(target, impact.particles, countMultiplier * caster.getScale(), trackers);
                    }
                    if (impact.sound != null) {
                        SoundHelper.playSound(world, target, impact.sound);
                    }
                    if (targetWasAlive && caster instanceof Player) {
                        player = (Player)caster;
                        finalTarget = target;
                        finalCritical = critical;
                        ((WorldScheduler)world).schedule(0, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performImpact$23(net.minecraft.world.entity.player.Player net.minecraft.world.entity.Entity net.minecraft.core.Holder net.spell_engine.api.spell.Spell$Impact boolean ), ()V)((Player)player, (Entity)finalTarget, spellEntry, (Spell.Impact)impact, (boolean)finalCritical));
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to perform impact effect");
                System.err.println(e.getMessage());
                if (!isKnockbackPushed) break block96;
                ((ConfigurableKnockback)target).popKnockbackMultiplier_SpellEngine();
            }
        }
        return success;
    }

    private static boolean modifyCooldowns(List<Holder<Spell>> spells, Spell.Impact.Action.Cooldown.Modify modifier, SpellCooldownManager cooldownManager) {
        boolean modifiedAny = false;
        for (Holder<Spell> spell : spells) {
            int duration;
            int updatedDuration;
            ResourceLocation id = ((ResourceKey)spell.unwrapKey().get()).location();
            if (!PatternMatching.matches(spell, SpellRegistry.KEY, modifier.id) || (updatedDuration = (int)(((float)(duration = cooldownManager.getCooldownDuration(id)) + modifier.duration_add) * modifier.duration_multiplier)) == duration) continue;
            cooldownManager.setDurationLeft(id, updatedDuration);
            modifiedAny = true;
        }
        return modifiedAny;
    }

    public static TargetConditionResult evaluateImpactConditions(Entity target, LivingEntity caster, List<Spell.Impact.TargetModifier> target_modifiers) {
        if (target_modifiers == null) {
            return TargetConditionResult.ALLOWED;
        }
        ArrayList<Spell.Impact.Modifier> modifiers = new ArrayList<Spell.Impact.Modifier>();
        for (Spell.Impact.TargetModifier entry : target_modifiers) {
            boolean conditionMet = true;
            int i = 0;
            for (Spell.TargetCondition condition : entry.conditions) {
                boolean newResult = SpellTarget.evaluate(target, (Entity)caster, condition);
                conditionMet = i == 0 ? newResult : (entry.all_required ? conditionMet && newResult : conditionMet || newResult);
                ++i;
            }
            switch (entry.execute) {
                case ALLOW: {
                    if (conditionMet) break;
                    return TargetConditionResult.DENIED;
                }
                case DENY: {
                    if (!conditionMet) break;
                    return TargetConditionResult.DENIED;
                }
            }
            if (!conditionMet || entry.modifier == null) continue;
            modifiers.add(entry.modifier);
        }
        return new TargetConditionResult(true, modifiers);
    }

    public static void placeCloud(Level world, LivingEntity caster, @Nullable Entity target, @Nullable Vec3 location, Holder<Spell> spellEntry, ImpactContext context) {
        Spell spell = (Spell)spellEntry.value();
        List<Spell.Delivery.Cloud> clouds = spell.deliver.clouds;
        if (clouds == null || clouds.isEmpty()) {
            return;
        }
        if (target == null && location == null) {
            target = caster;
        }
        List<Object> spellModifiers = List.of();
        if (caster instanceof Player) {
            Player player = (Player)caster;
            spellModifiers = SpellModifiers.of(player, spellEntry);
        }
        float extraTimeToLive = 0.0f;
        ArrayList<Spell.EntityPlacement> extraPlacements = new ArrayList<Spell.EntityPlacement>();
        for (Spell.Modifier modifier : spellModifiers) {
            extraTimeToLive += modifier.spawn_duration_add;
            extraPlacements.addAll(modifier.additional_placements);
        }
        int index = 0;
        for (Spell.Delivery.Cloud cloud : clouds) {
            ArrayList<Spell.EntityPlacement> placements = new ArrayList<Spell.EntityPlacement>();
            placements.add(cloud.placement);
            placements.addAll(cloud.additional_placements);
            if (index == 0) {
                placements.addAll(extraPlacements);
            }
            int base_delay = cloud.delay_ticks;
            for (Spell.EntityPlacement placement : placements) {
                SpellCloud entity;
                int delay = base_delay + placement.delay_ticks;
                if (cloud.entity_type_id != null) {
                    ResourceLocation id = ResourceLocation.parse((String)cloud.entity_type_id);
                    EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
                    entity = (SpellCloud)type.create(world);
                } else {
                    entity = new SpellCloud(world);
                }
                entity.setOwner(caster);
                entity.onCreatedFromSpell(((ResourceKey)spellEntry.unwrapKey().get()).location(), cloud, context, cloud.time_to_live_seconds + extraTimeToLive);
                if (target != null) {
                    SpellHelper.applyEntityPlacement(entity, target, target.position(), placement);
                } else {
                    if (location == null) continue;
                    SpellHelper.applyEntityPlacement(caster.level(), entity, caster.getYRot(), caster.getXRot(), null, location, placement);
                }
                ((WorldScheduler)world).schedule(delay, () -> {
                    ParticleBatch[] particles;
                    world.addFreshEntity((Entity)entity);
                    Sound sound = cloud.spawn.sound;
                    if (sound != null) {
                        SoundHelper.playSound(world, entity, sound);
                    }
                    if ((particles = cloud.spawn.particles) != null) {
                        ParticleHelper.sendBatches(entity, particles);
                    }
                });
                if (!cloud.placement_delay_stacks) continue;
                base_delay = delay;
            }
            ++index;
        }
    }

    public static void applyEntityPlacement(Entity entity, Entity target, Vec3 initialPosition, Spell.EntityPlacement placement) {
        SpellHelper.applyEntityPlacement(target.level(), entity, target.getYRot(), target.getXRot(), target, initialPosition, placement);
    }

    public static void applyEntityPlacement(Level world, Entity placedEntity, float targetedYaw, float targetedPitch, @Nullable Entity rayCastEntity, Vec3 initialPosition, Spell.EntityPlacement placement) {
        Vec3 position = initialPosition;
        if (placement != null) {
            if (placement.location_offset_by_look > 0.0f) {
                float yaw = targetedYaw + placement.location_yaw_offset;
                position = position.add(Vec3.directionFromRotation((float)0.0f, (float)yaw).scale((double)placement.location_offset_by_look));
            }
            position = position.add(new Vec3((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
            if (placement.force_onto_ground) {
                Vec3 groundPosBelow;
                Vec3 searchPosition = position;
                BlockPos blockPos = BlockPos.containing((double)searchPosition.x(), (double)searchPosition.y(), (double)searchPosition.z());
                if (world.getBlockState(blockPos).isSolid()) {
                    searchPosition = searchPosition.add(0.0, 2.0, 0.0);
                }
                Vec3 vec3 = position = (groundPosBelow = TargetHelper.findSolidBlockBelow(rayCastEntity, searchPosition, world, -20.0f)) != null ? groundPosBelow : position;
            }
            if (placement.apply_yaw) {
                placedEntity.setYRot(targetedYaw);
            }
            if (placement.apply_pitch) {
                placedEntity.setXRot(targetedPitch);
            }
            position = position.add(new Vec3((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
        }
        placedEntity.setPos(position.x(), position.y(), position.z());
    }

    public static SpellTarget.FocusMode focusMode(Spell spell) {
        switch (spell.target.type) {
            case AREA: 
            case BEAM: {
                return SpellTarget.FocusMode.AREA;
            }
            case NONE: 
            case CASTER: 
            case AIM: 
            case FROM_TRIGGER: {
                return SpellTarget.FocusMode.DIRECT;
            }
        }
        return null;
    }

    public static Optional<SpellTarget.Intent> deliveryIntent(Spell spell) {
        switch (spell.deliver.type) {
            case STASH_EFFECT: {
                SpellTarget.Intent intent = SpellHelper.intentForStatusEffect(spell.deliver.stash_effect.id);
                return Optional.of(intent);
            }
        }
        return Optional.empty();
    }

    public static EnumSet<SpellTarget.Intent> impactIntents(Spell spell) {
        HashSet<SpellTarget.Intent> intents = new HashSet<SpellTarget.Intent>();
        for (Spell.Impact impact : spell.impacts) {
            intents.add(SpellHelper.impactIntent(impact.action));
        }
        return EnumSet.copyOf(intents);
    }

    public static SpellTarget.Intent impactIntent(Spell.Impact.Action action) {
        switch (action.type) {
            case DAMAGE: 
            case FIRE: 
            case AGGRO: {
                return SpellTarget.Intent.HARMFUL;
            }
            case HEAL: 
            case SPAWN: {
                return SpellTarget.Intent.HELPFUL;
            }
            case STATUS_EFFECT: {
                if (action.status_effect.remove != null) {
                    return action.status_effect.remove.select_beneficial ? SpellTarget.Intent.HARMFUL : SpellTarget.Intent.HELPFUL;
                }
                return SpellHelper.intentForStatusEffect(action.status_effect.effect_id);
            }
            case TELEPORT: {
                return action.teleport.intent;
            }
            case COOLDOWN: {
                Spell.Impact.Action.Cooldown cooldown = action.cooldown;
                if (cooldown != null) {
                    float duration_add = 0.0f;
                    float duration_multiplier = 1.0f;
                    if (cooldown.actives != null) {
                        duration_add += cooldown.actives.duration_add;
                        duration_multiplier += cooldown.actives.duration_multiplier - 1.0f;
                    }
                    if (cooldown.passives != null) {
                        duration_add += cooldown.passives.duration_add;
                        duration_multiplier += cooldown.passives.duration_multiplier - 1.0f;
                    }
                    boolean addHelpful = duration_add <= 0.0f;
                    boolean multiplierHelpful = duration_multiplier <= 1.0f;
                    return addHelpful && multiplierHelpful ? SpellTarget.Intent.HELPFUL : SpellTarget.Intent.HARMFUL;
                }
                return SpellTarget.Intent.HELPFUL;
            }
            case CUSTOM: {
                return action.custom.intent;
            }
        }
        return null;
    }

    private static SpellTarget.Intent intentForStatusEffect(String idString) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(id);
        return effect.isBeneficial() ? SpellTarget.Intent.HELPFUL : SpellTarget.Intent.HARMFUL;
    }

    public static boolean underApplyLimit(SpellPower.Result spellPower, LivingEntity target, SpellSchool school, Spell.Impact.Action.StatusEffect.ApplyLimit limit) {
        if (limit == null) {
            return true;
        }
        float power = (float)spellPower.nonCriticalValue();
        float cap = limit.health_base + power * limit.spell_power_multiplier;
        return cap >= target.getMaxHealth();
    }

    public static EstimatedOutput estimate(Spell spell, Player caster, ItemStack itemStack) {
        SpellSchool spellSchool = spell.school;
        ArrayList<EstimatedValue> damageEffects = new ArrayList<EstimatedValue>();
        ArrayList<EstimatedValue> healEffects = new ArrayList<EstimatedValue>();
        boolean isEquipped = AttributeModifierUtil.isItemStackEquipped(itemStack, caster);
        ArrayList<Spell.Impact> impacts = new ArrayList<Spell.Impact>(spell.impacts);
        if (spell.modifiers != null) {
            for (Spell.Modifier modifier : spell.modifiers) {
                impacts.addAll(modifier.impacts);
            }
        }
        for (Spell.Impact impact : impacts) {
            SpellPower.Result power;
            boolean useRealAttributes;
            Optional optionalAttribute;
            SpellSchool school = impact.school != null ? impact.school : spellSchool;
            Holder attribute = school.attributeEntry;
            boolean attributeOverride = false;
            if (impact.attribute != null && !impact.attribute.isEmpty() && (optionalAttribute = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)impact.attribute))).isPresent()) {
                attribute = (Holder)optionalAttribute.get();
                attributeOverride = true;
            }
            double flatBonusOnItemStack = AttributeModifierUtil.flatBonusFrom(itemStack, (Holder<Attribute>)attribute);
            boolean bl = useRealAttributes = isEquipped || flatBonusOnItemStack == 0.0;
            if (useRealAttributes) {
                power = SpellPower.getSpellPower((SpellSchool)school, (LivingEntity)caster);
                if (attributeOverride) {
                    double value = caster.getAttributeValue(attribute);
                    power = new SpellPower.Result(school, value, power.criticalChance(), power.criticalDamage());
                }
            } else {
                power = new SpellPower.Result(school, flatBonusOnItemStack, 0.0, 1.0);
            }
            if (power.baseValue() < (double)impact.action.min_power || power.baseValue() > (double)impact.action.max_power) {
                double clampedValue = Mth.clamp((double)power.baseValue(), (double)impact.action.min_power, (double)impact.action.max_power);
                power = new SpellPower.Result(power.school(), clampedValue, power.criticalChance(), power.criticalDamage());
            }
            switch (impact.action.type) {
                case DAMAGE: {
                    Spell.Impact.Action.Damage damageData = impact.action.damage;
                    EstimatedValue damage = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(damageData.spell_power_coefficient);
                    damageEffects.add(damage);
                    break;
                }
                case HEAL: {
                    Spell.Impact.Action.Heal healData = impact.action.heal;
                    EstimatedValue healing = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(healData.spell_power_coefficient);
                    healEffects.add(healing);
                }
            }
        }
        return new EstimatedOutput(damageEffects, healEffects);
    }

    private static /* synthetic */ void lambda$performImpact$23(Player player, Entity finalTarget, Holder spellEntry, Spell.Impact impact, boolean finalCritical) {
        SpellTriggers.onSpellImpactSpecific(player, finalTarget, (Holder<Spell>)spellEntry, impact, finalCritical, Spell.Trigger.Stage.POST);
    }

    private static /* synthetic */ void lambda$performImpact$22(Level world, Entity entity) {
        world.addFreshEntity(entity);
    }

    private static /* synthetic */ boolean lambda$performImpact$21(Spell.Impact.Action.StatusEffect data, MobEffectInstance instance) {
        return ((MobEffect)instance.getEffect().value()).isBeneficial() == data.remove.select_beneficial && PatternMatching.matches(instance.getEffect(), Registries.MOB_EFFECT, data.remove.id);
    }

    private static /* synthetic */ void lambda$performImpact$20(LivingEntity caster, Holder spellEntry, LivingEntity livingTarget, float finalAmount, SpellEvents.HealEvent listener) {
        listener.onHeal(new SpellEvents.HealEvent.Args(caster, (Holder<Spell>)spellEntry, livingTarget, finalAmount));
    }

    private static /* synthetic */ Float lambda$performImpact$19(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.critical_damage_bonus);
    }

    private static /* synthetic */ Float lambda$performImpact$18(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.critical_chance_bonus);
    }

    private static /* synthetic */ Float lambda$performImpact$17(Spell.Impact.Modifier modifier) {
        return Float.valueOf(modifier.power_multiplier);
    }

    private static /* synthetic */ void lambda$performSpell$3(Player player, Spell spell, Holder spellEntry, Level world, Supplier trackingPlayers, float castingSpeed, float finalProgress, SpellContainerSource.SourcedContainer spellSource, ResourceLocation spellId, ItemStack heldItemStack, Ammo.Result ammoResult, List finalTargets, SpellCast.Action action, DeliveryCompletion completionArgs) {
        boolean deliverySuccess = completionArgs.success();
        if (deliverySuccess) {
            ParticleHelper.sendBatches((Entity)player, spell.release.particles);
            if (spell.release.particles_scaled_with_ranged != null) {
                ParticleBatch[] scaledParticles = new ParticleBatch[spell.release.particles_scaled_with_ranged.length];
                for (int i = 0; i < spell.release.particles_scaled_with_ranged.length; ++i) {
                    ParticleBatch particles = spell.release.particles_scaled_with_ranged[i];
                    float range = SpellHelper.getRange(player, (Holder<Spell>)spellEntry);
                    scaledParticles[i] = particles.copy().scale(range);
                }
                ParticleHelper.sendBatches((Entity)player, scaledParticles);
            }
            SoundHelper.playSound(world, (Entity)player, spell.release.sound);
            AnimationHelper.sendAnimation(player, (Collection)trackingPlayers.get(), SpellCast.Animation.RELEASE, spell.release.animation, castingSpeed);
            SpellHelper.consumeSpellCost(player, finalProgress, spellSource, spellId, (Holder<Spell>)spellEntry, heldItemStack, ammoResult, false);
            SpellEvents.SpellCastEvent.Args args = new SpellEvents.SpellCastEvent.Args(player, (Holder<Spell>)spellEntry, finalTargets, action, finalProgress);
            SpellEvents.SPELL_CAST.invoke(listener -> listener.onSpellCast(args));
        }
    }

    public record ImpactContext(float channel, float distance, @Nullable Vec3 position, SpellPower.Result power, SpellTarget.FocusMode focusMode, int channelTickIndex) {
        public ImpactContext() {
            this(1.0f, 1.0f, null, null, SpellTarget.FocusMode.DIRECT, 0);
        }

        public ImpactContext channeled(float multiplier) {
            return new ImpactContext(multiplier, this.distance, this.position, this.power, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext distance(float multiplier) {
            return new ImpactContext(this.channel, multiplier, this.position, this.power, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext position(Vec3 position) {
            return new ImpactContext(this.channel, this.distance, position, this.power, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext power(SpellPower.Result spellPower) {
            return new ImpactContext(this.channel, this.distance, this.position, spellPower, this.focusMode, this.channelTickIndex);
        }

        public ImpactContext target(SpellTarget.FocusMode focusMode) {
            return new ImpactContext(this.channel, this.distance, this.position, this.power, focusMode, this.channelTickIndex);
        }

        public boolean hasOffset() {
            return this.position != null;
        }

        public Vec3 knockbackDirection(Vec3 targetPosition) {
            return targetPosition.subtract(this.position).normalize();
        }

        public boolean isChanneled() {
            return this.channel != 1.0f;
        }

        public float total() {
            return this.channel * this.distance;
        }
    }

    public record DeliveryTarget(Entity entity, ImpactContext context) {
    }

    public record DeliveryCompletion(boolean success) {
    }

    public record TargetConditionResult(boolean allowed, List<Spell.Impact.Modifier> modifiers) {
        public static final TargetConditionResult ALLOWED = new TargetConditionResult(true, List.of());
        public static final TargetConditionResult DENIED = new TargetConditionResult(false, List.of());
    }

    public record EstimatedValue(double min, double max) {
        public EstimatedValue multiply(double value) {
            return new EstimatedValue(this.min * value, this.max * value);
        }
    }

    public record EstimatedOutput(List<EstimatedValue> damage, List<EstimatedValue> heal) {
    }
}

