/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.container;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.utils.WeaponCompatibility;

public class SpellAssignments {
    public static final Map<ResourceLocation, SpellContainer> containers = new HashMap<ResourceLocation, SpellContainer>();
    public static final Map<ResourceLocation, SpellContainer> book_containers = new HashMap<ResourceLocation, SpellContainer>();
    public static List<String> encoded = List.of();

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(SpellAssignments::load);
    }

    private static void load(MinecraftServer minecraftServer) {
        SpellAssignments.loadContainers(minecraftServer.getResourceManager());
        WeaponCompatibility.initialize();
        SpellAssignments.encodeContent();
    }

    public static void loadContainers(ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap<ResourceLocation, SpellContainer> parsed = new HashMap<ResourceLocation, SpellContainer>();
        String directory = "spell_assignments";
        for (Map.Entry entry : resourceManager.listResources(directory, fileName -> fileName.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.open()));
                SpellContainer container = (SpellContainer)gson.fromJson(reader, SpellContainer.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                parsed.put(ResourceLocation.parse((String)id), container);
            }
            catch (Exception e) {
                System.err.println("Spell Engine: Failed to parse spell_assignment: " + String.valueOf(identifier) + " | Reason: " + e.getMessage());
            }
        }
        containers.clear();
        containers.putAll(parsed);
        containers.putAll(book_containers);
    }

    public static SpellContainer containerForItem(ResourceLocation itemId) {
        if (itemId == null) {
            return null;
        }
        return containers.get(itemId);
    }

    private static void encodeContent() {
        Gson gson = new Gson();
        SyncFormat sync = new SyncFormat();
        containers.forEach((key, value) -> sync.containers.put(key.toString(), (SpellContainer)value));
        String json = gson.toJson((Object)sync);
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSize = 10000;
        for (int i = 0; i < json.length(); i += chunkSize) {
            chunks.add(json.substring(i, Math.min(json.length(), i + chunkSize)));
        }
        System.out.println("Encoded SpellRegistry size (with package overhead): ??? bytes (in " + chunks.size() + " string chunks with the size of " + chunkSize + ")");
        encoded = chunks;
    }

    public static void decodeContent(List<String> chunks) {
        String json = "";
        for (String chunk : chunks) {
            json = json.concat(chunk);
        }
        Gson gson = new Gson();
        SyncFormat sync = (SyncFormat)gson.fromJson(json, SyncFormat.class);
        sync.containers.forEach((key, value) -> containers.put(ResourceLocation.parse((String)key), (SpellContainer)value));
    }

    public static class SyncFormat {
        public Map<String, SpellContainer> containers = new HashMap<String, SpellContainer>();
    }
}

