/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.target;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.entity.SpellEntityPredicates;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.utils.PatternMatching;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;

public class SpellTarget {
    public static SearchResult findTargets(Player caster, Holder<Spell> spellEntry, SearchResult previous, boolean filterInvalidTargets) {
        Spell.Target.Aim aim;
        Spell currentSpell = (Spell)spellEntry.value();
        List<Object> targets = List.of();
        List<Entity> previousTargets = previous.entities;
        Vec3 location = null;
        if (currentSpell == null || currentSpell.impacts == null) {
            return new SearchResult(targets, location);
        }
        boolean fallbackToPreviousTargets = false;
        FocusMode focusMode = SpellHelper.focusMode(currentSpell);
        Spell.Target.Type targetType = currentSpell.target.type;
        float range = SpellHelper.getRange(caster, spellEntry) * caster.getScale();
        Predicate<Entity> selectionPredicate = target -> {
            Optional<Intent> deliveryIntent = SpellHelper.deliveryIntent(currentSpell);
            boolean intentAllows = deliveryIntent.isPresent() ? EntityRelations.actionAllowed(focusMode, deliveryIntent.get(), (LivingEntity)caster, target) : false;
            for (Spell.Impact impact : currentSpell.impacts) {
                Intent intent = SpellHelper.impactIntent(impact.action);
                boolean newValue = impact.action.apply_to_caster ? target == caster : EntityRelations.actionAllowed(focusMode, intent, (LivingEntity)caster, target);
                intentAllows = intentAllows || newValue;
            }
            return !filterInvalidTargets || intentAllows;
        };
        switch (targetType) {
            case NONE: {
                break;
            }
            case CASTER: {
                targets = List.of(caster);
                break;
            }
            case AIM: {
                fallbackToPreviousTargets = currentSpell.target.aim.sticky;
                Entity target2 = TargetHelper.targetFromRaycast((Entity)caster, range, selectionPredicate);
                if (target2 != null) {
                    targets = List.of(target2);
                    break;
                }
                targets = List.of();
                break;
            }
            case BEAM: {
                targets = TargetHelper.targetsFromRaycast((Entity)caster, range, selectionPredicate);
                break;
            }
            case AREA: {
                targets = TargetHelper.targetsFromArea((Entity)caster, range, currentSpell.target.area, selectionPredicate);
                Spell.Target.Area area = currentSpell.target.area;
                if (area == null || !area.include_caster) break;
                targets.add(caster);
            }
        }
        if (fallbackToPreviousTargets && targets.isEmpty()) {
            targets = previousTargets.stream().filter(entity -> TargetHelper.isInLineOfSight((Entity)caster, entity) && !entity.isRemoved()).toList();
        }
        if ((aim = currentSpell.target.aim) != null) {
            if (aim.use_caster_as_fallback && targets.isEmpty()) {
                targets = List.of(caster);
            }
            if (!aim.required && targets.isEmpty()) {
                location = TargetHelper.locationFromRayCast((Entity)caster, range);
            }
        }
        return new SearchResult(targets, location);
    }

    public static boolean evaluate(Entity testedEntity, @Nullable Entity otherEntity, @Nullable Spell.TargetCondition condition) {
        LivingEntity livingEntity;
        float healthPercent;
        if (condition == null) {
            return true;
        }
        if (testedEntity instanceof LivingEntity && ((healthPercent = (livingEntity = (LivingEntity)testedEntity).getHealth() / livingEntity.getMaxHealth()) < condition.health_percent_above || healthPercent > condition.health_percent_below)) {
            return false;
        }
        if (condition.entity_type != null && !PatternMatching.matches(testedEntity.getType().builtInRegistryHolder(), Registries.ENTITY_TYPE, condition.entity_type)) {
            return false;
        }
        if (condition.entity_predicate_id != null) {
            SpellEntityPredicates.Entry predicate = SpellEntityPredicates.get(condition.entity_predicate_id);
            if (predicate == null) {
                return false;
            }
            SpellEntityPredicates.Input args = new SpellEntityPredicates.Input(testedEntity, otherEntity, condition.entity_predicate_param);
            if (!predicate.predicate().test(args)) {
                return false;
            }
        }
        return true;
    }

    public record SearchResult(List<Entity> entities, @Nullable Vec3 location) {
        public static SearchResult empty() {
            return new SearchResult(List.of(), null);
        }

        public static SearchResult of(List<Entity> entities) {
            return new SearchResult(entities, null);
        }

        public static SearchResult of(Entity entity) {
            return new SearchResult(List.of(entity), null);
        }

        public static SearchResult of(Vec3 location) {
            return new SearchResult(List.of(), location);
        }
    }

    public static enum FocusMode {
        DIRECT,
        AREA;

    }

    public static enum Intent {
        HELPFUL,
        HARMFUL;

    }
}

