/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.action_impair;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.EntityActionsAllowed;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityActionImpairing
implements EntityActionsAllowed.ControlledEntity {
    private EntityActionsAllowed entityActionsAllowed_SpellEngine = EntityActionsAllowed.ANY;
    @Shadow
    private boolean effectsDirty;
    @Shadow
    @Final
    private Map<Holder<MobEffect>, MobEffectInstance> activeEffects;

    @Shadow
    public abstract void stopUsingItem();

    @Inject(method={"jumpFromGround()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void jump_HEAD_Spell_Engine(CallbackInfo ci) {
        if (EntityActionsAllowed.isImpaired((LivingEntity)this, EntityActionsAllowed.Common.JUMP)) {
            ci.cancel();
        }
    }

    @Inject(method={"isImmobile()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isImmobile_HEAD_SpellEngine(CallbackInfoReturnable<Boolean> cir) {
        if (EntityActionsAllowed.isImpaired((LivingEntity)this, EntityActionsAllowed.Common.MOVE)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"updatingUsingItem()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickActiveItemStack_HEAD_SpellEngine(CallbackInfo ci) {
        if (EntityActionsAllowed.isImpaired((LivingEntity)this, EntityActionsAllowed.Player.ITEM_USE)) {
            this.stopUsingItem();
            ci.cancel();
        }
    }

    @Inject(method={"tickEffects()V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;effectsDirty:Z", shift=At.Shift.BEFORE, ordinal=0)})
    private void tickStatusEffects_HEAD_SpellEngine(CallbackInfo ci) {
        if (this.effectsDirty) {
            this.updateEntityActionsAllowed();
        }
    }

    @Override
    public void updateEntityActionsAllowed() {
        this.entityActionsAllowed_SpellEngine = EntityActionsAllowed.fromEffects(this.activeEffects.keySet());
    }

    @Override
    public EntityActionsAllowed actionImpairing() {
        return this.entityActionsAllowed_SpellEngine;
    }
}

