/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.control;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.AutoSwapHelper;
import net.spell_engine.client.input.MinecraftClientExtension;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"useItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactItem_HEAD_LockHotbar(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player instanceof LocalPlayer) {
            LocalPlayer clientPlayer = (LocalPlayer)player;
            if (SpellEngineClient.config.autoSwapHands && AutoSwapHelper.autoSwapForSpells()) {
                this.minecraft.missTime = SpellEngineMod.config.auto_swap_cooldown;
                cir.setReturnValue((Object)InteractionResult.FAIL);
                cir.cancel();
            }
            if (((MinecraftClientExtension)this.minecraft).isSpellCastLockActive()) {
                cir.setReturnValue((Object)InteractionResult.FAIL);
                cir.cancel();
            }
        }
        if (EntityActionsAllowed.isImpaired((LivingEntity)player, EntityActionsAllowed.Player.ITEM_USE, true)) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
            cir.cancel();
        }
    }
}

