/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.control;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.AutoSwapHelper;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.input.MinecraftClientExtension;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.compat.CombatRollCompat;
import net.spell_engine.internals.casting.SpellCasterClient;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class}, priority=999)
public abstract class SpellHotbarMinecraftClient
implements MinecraftClientExtension {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public Options options;
    @Shadow
    private int rightClickDelay;
    @Shadow
    public int missTime;
    @Shadow
    @Nullable
    public Screen screen;
    private boolean useKeySpellCastingLock = false;

    @Inject(method={"handleKeybinds()V"}, at={@At(value="HEAD")})
    private void handleInputEvents_HEAD_SpellHotbar(CallbackInfo ci) {
        if (this.player == null || this.options == null) {
            return;
        }
        boolean hotbarUpdated = SpellHotbar.INSTANCE.update(this.player, this.options);
        if (hotbarUpdated) {
            this.rightClickDelay = 4;
        }
        SpellHotbar.INSTANCE.prepare(this.rightClickDelay);
        if (this.player.isUsingItem()) {
            return;
        }
        SpellHotbar.Handle handled = SpellHotbar.INSTANCE.handleAll(this.player, this.options);
        if (handled != null) {
            if (this.player.isUsingItem()) {
                this.player.releaseUsingItem();
                this.rightClickDelay = 1;
            }
            if ((handled.isSuccessfulAttempt() || ((SpellCasterClient)this.player).isCastingSpell()) && handled.keyBinding() == this.options.keyUse) {
                this.useKeySpellCastingLock = true;
            }
        }
        if (this.useKeySpellCastingLock && !this.options.keyUse.isDown()) {
            this.useKeySpellCastingLock = false;
        }
        if (((SpellCasterClient)this.player).isCastingSpell()) {
            this.missTime = 2;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick_HEAD_SpellHotbar(CallbackInfo ci) {
        if (this.player == null || this.options == null) {
            return;
        }
        if (this.screen != null || CombatRollCompat.isRolling.apply((Player)this.player).booleanValue()) {
            ((SpellCasterClient)this.player).cancelSpellCast();
        }
    }

    @Inject(method={"handleKeybinds()V"}, at={@At(value="TAIL")})
    private void handleInputEvents_TAIL_SpellHotbar(CallbackInfo ci) {
        if (this.player == null || this.options == null) {
            return;
        }
        SpellHotbar.INSTANCE.syncItemUseSkill(this.player);
    }

    @WrapWithCondition(method={"handleKeybinds()V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Inventory;selected:I", ordinal=0, opcode=181)})
    private boolean handleInputEvents_OverrideNumberKeys(Inventory instance, int index) {
        boolean shouldControlSpellHotbar = false;
        if (!Keybindings.bypass_spell_hotbar.isDown()) {
            for (SpellHotbar.Slot slot : SpellHotbar.INSTANCE.slots) {
                KeyMapping keyBinding = slot.getKeyBinding(this.options);
                if (this.options.keyHotbarSlots[index] != keyBinding) continue;
                shouldControlSpellHotbar = true;
                break;
            }
        }
        return !shouldControlSpellHotbar;
    }

    @Inject(method={"startUseItem()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD_autoSwap(CallbackInfo ci) {
        if (this.useKeySpellCastingLock || ((SpellCasterClient)this.player).isCastingSpell()) {
            ci.cancel();
            return;
        }
    }

    @Inject(method={"startAttack()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD_autoSwap(CallbackInfoReturnable<Boolean> cir) {
        if (SpellEngineClient.config.autoSwapHands && AutoSwapHelper.autoSwapForAttack()) {
            this.rightClickDelay = SpellEngineMod.config.auto_swap_cooldown;
            this.missTime = SpellEngineMod.config.auto_swap_cooldown;
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Override
    public boolean isSpellCastLockActive() {
        return this.useKeySpellCastingLock;
    }
}

