/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.Synchronized;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin {
    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    private void render_TAIL_SpellEngine(LivingEntity livingEntity, float f, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, CallbackInfo ci) {
        boolean isRenderingClientPlayerInFirstPerson;
        Minecraft client = Minecraft.getInstance();
        boolean bl = isRenderingClientPlayerInFirstPerson = livingEntity == client.player && !client.gameRenderer.getMainCamera().isDetached();
        if (!isRenderingClientPlayerInFirstPerson) {
            for (Synchronized.Effect entry : Synchronized.effectsOf(livingEntity)) {
                MobEffect effect = entry.effect();
                int amplifier = entry.amplifier();
                CustomModelStatusEffect.Entry rendererEntry = CustomModelStatusEffect.entryOf(effect);
                if (rendererEntry == null) continue;
                matrixStack.pushPose();
                if (rendererEntry.args().scaleWithEntity()) {
                    float scale = livingEntity.getScale();
                    matrixStack.scale(scale, scale, scale);
                }
                rendererEntry.renderer().renderEffect(amplifier, livingEntity, delta, matrixStack, vertexConsumerProvider, light);
                matrixStack.popPose();
            }
        }
    }
}

