/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.evasion;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.entity.EvasionLogic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityEvasionMixin
implements EvasionLogic.Evader {
    private DamageSource lastEvaded = null;

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSleeping()Z")}, cancellable=true)
    private void damage_SpellEngine_Evasion(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (EvasionLogic.tryEvade(entity, amount, source)) {
            EvasionLogic.onEvade(entity, amount, source);
            this.lastEvaded = source;
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Override
    public DamageSource getLastEvaded() {
        return this.lastEvaded;
    }

    @Override
    public void setLastEvaded(DamageSource source) {
        this.lastEvaded = source;
    }
}

