/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.item;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/world/inventory/GrindstoneMenu$4"})
public class GrindstoneSlotOutputMixin {
    @Nullable
    private Level world;

    @Inject(method={"getExperienceAmount(Lnet/minecraft/world/level/Level;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExperience_enter_SpellEngine(Level world, CallbackInfoReturnable<Integer> cir) {
        this.world = world;
    }

    @Inject(method={"getExperienceFromItem(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExperience_SpellEngine(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (this.world != null && stack.is(SpellEngineItemTags.GRINDABLE)) {
            SpellContainer container = SpellContainerHelper.containerFromItemStack(stack);
            int experience = 0;
            if (container != null) {
                Registry<Spell> registry = SpellRegistry.from(this.world);
                for (String idString : container.spell_ids()) {
                    ResourceLocation id = ResourceLocation.parse((String)idString);
                    Optional spellEntry = registry.getHolder(id);
                    if (!spellEntry.isPresent()) continue;
                    Spell spell = (Spell)((Holder.Reference)spellEntry.get()).value();
                    if (spell.learn == null) continue;
                    experience += spell.tier * spell.learn.level_cost_per_tier;
                }
            }
            if (experience > 0) {
                cir.setReturnValue((Object)experience);
                cir.cancel();
                this.world = null;
            }
        }
    }
}

