/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.casting.SpellCast;
import org.jetbrains.annotations.Nullable;

public class Packets {

    public record Ack(String code) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"ack");
        public static final CustomPacketPayload.Type<Ack> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, Ack> CODEC = StreamCodec.ofMember(Ack::write, Ack::read);

        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.code);
        }

        public static Ack read(FriendlyByteBuf buffer) {
            String code = buffer.readUtf();
            return new Ack(code);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record SpellRegistrySync(List<String> chunks) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_registry_sync");
        public static final CustomPacketPayload.Type<SpellRegistrySync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, SpellRegistrySync> CODEC = StreamCodec.ofMember(SpellRegistrySync::write, SpellRegistrySync::read);

        private void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.chunks.size());
            for (String chunk : this.chunks) {
                buffer.writeUtf(chunk);
            }
        }

        private static SpellRegistrySync read(FriendlyByteBuf buffer) {
            int chunkCount = buffer.readInt();
            ArrayList<String> chunks = new ArrayList<String>();
            for (int i = 0; i < chunkCount; ++i) {
                chunks.add(buffer.readUtf());
            }
            return new SpellRegistrySync(chunks);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record ConfigSync(ServerConfig config) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"config_sync");
        public static final CustomPacketPayload.Type<ConfigSync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, ConfigSync> CODEC = StreamCodec.ofMember(ConfigSync::write, ConfigSync::read);
        private static final Gson gson = new Gson();

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(FriendlyByteBuf buffer) {
            String json = gson.toJson((Object)this.config);
            buffer.writeUtf(json);
        }

        public static ConfigSync read(FriendlyByteBuf buffer) {
            Gson gson = new Gson();
            String json = buffer.readUtf();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return new ConfigSync(config);
        }
    }

    public record SpellContainerSync(LinkedHashMap<String, SpellContainer> containers) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_container_sync");
        public static final CustomPacketPayload.Type<SpellContainerSync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, SpellContainerSync> CODEC = StreamCodec.ofMember(SpellContainerSync::write, SpellContainerSync::read);
        private static final Gson gson = new Gson();

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.containers.size());
            for (Map.Entry<String, SpellContainer> entry : this.containers.entrySet()) {
                buffer.writeUtf(entry.getKey());
                String json = gson.toJson((Object)entry.getValue());
                buffer.writeUtf(json);
            }
        }

        public static SpellContainerSync read(FriendlyByteBuf buffer) {
            int size = buffer.readInt();
            LinkedHashMap<String, SpellContainer> containers = new LinkedHashMap<String, SpellContainer>();
            for (int i = 0; i < size; ++i) {
                String key = buffer.readUtf();
                String json = buffer.readUtf();
                SpellContainer container = (SpellContainer)gson.fromJson(json, SpellContainer.class);
                containers.put(key, container);
            }
            return new SpellContainerSync(containers);
        }
    }

    public record ParticleBatches(SourceType sourceType, float countMultiplier, List<Spawn> spawns) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"particle_effects");
        public static final CustomPacketPayload.Type<ParticleBatches> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, ParticleBatches> CODEC = StreamCodec.ofMember(ParticleBatches::write, ParticleBatches::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.sourceType.ordinal());
            buffer.writeInt(this.spawns.size());
            for (Spawn spawn : this.spawns) {
                buffer.writeInt(spawn.sourceEntityId);
                buffer.writeFloat(spawn.yaw);
                buffer.writeFloat(spawn.pitch);
                buffer.writeDouble(spawn.sourceLocation.x);
                buffer.writeDouble(spawn.sourceLocation.y);
                buffer.writeDouble(spawn.sourceLocation.z);
                ParticleBatches.write(spawn.batch, (FriendlyByteBuf)buffer, this.countMultiplier);
            }
        }

        private static void write(ParticleBatch batch, FriendlyByteBuf buffer, float countMultiplier) {
            buffer.writeUtf(batch.particle_id);
            buffer.writeInt(batch.shape.ordinal());
            buffer.writeInt(batch.origin.ordinal());
            buffer.writeInt(batch.rotation != null ? batch.rotation.ordinal() : -1);
            buffer.writeFloat(batch.roll);
            buffer.writeFloat(batch.roll_offset);
            buffer.writeFloat(batch.count * countMultiplier);
            buffer.writeFloat(batch.min_speed);
            buffer.writeFloat(batch.max_speed);
            buffer.writeFloat(batch.angle);
            buffer.writeFloat(batch.extent);
            buffer.writeFloat(batch.pre_spawn_travel);
            buffer.writeBoolean(batch.invert);
            buffer.writeLong(batch.color_rgba);
            buffer.writeFloat(batch.scale);
            buffer.writeBoolean(batch.follow_entity);
            buffer.writeFloat(batch.max_age);
        }

        private static ParticleBatch readBatch(RegistryFriendlyByteBuf buffer) {
            return new ParticleBatch(buffer.readUtf(), ParticleBatch.Shape.values()[buffer.readInt()], ParticleBatch.Origin.values()[buffer.readInt()], ParticleBatch.Rotation.from(buffer.readInt()), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), buffer.readLong(), buffer.readFloat(), buffer.readBoolean(), buffer.readFloat());
        }

        public static ParticleBatches read(RegistryFriendlyByteBuf buffer) {
            SourceType sourceType = SourceType.values()[buffer.readInt()];
            int spawnCount = buffer.readInt();
            ArrayList<Spawn> spawns = new ArrayList<Spawn>();
            for (int i = 0; i < spawnCount; ++i) {
                spawns.add(new Spawn(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), ParticleBatches.readBatch(buffer)));
            }
            return new ParticleBatches(sourceType, 1.0f, spawns);
        }

        public static enum SourceType {
            ENTITY,
            COORDINATE;

        }

        public record Spawn(int sourceEntityId, float yaw, float pitch, Vec3 sourceLocation, ParticleBatch batch) {
        }
    }

    public record SpellMessage(String translationKey, ChatFormatting format) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_message");
        public static final CustomPacketPayload.Type<SpellMessage> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellMessage> CODEC = StreamCodec.ofMember(SpellMessage::write, SpellMessage::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeUtf(this.translationKey);
            buffer.writeInt(this.format.ordinal());
        }

        public static SpellMessage read(RegistryFriendlyByteBuf buffer) {
            String text = buffer.readUtf();
            ChatFormatting format = ChatFormatting.values()[buffer.readInt()];
            return new SpellMessage(text, format);
        }
    }

    public static final class SpellAnimation
    extends Record
    implements CustomPacketPayload {
        private final int playerId;
        private final SpellCast.Animation type;
        private final String name;
        private final float speed;
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_animation");
        public static final CustomPacketPayload.Type<SpellAnimation> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellAnimation> CODEC = StreamCodec.ofMember(SpellAnimation::write, SpellAnimation::read);

        public SpellAnimation(int playerId, SpellCast.Animation type, String name, float speed) {
            this.playerId = playerId;
            this.type = type;
            this.name = name;
            this.speed = speed;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.playerId);
            buffer.writeInt(this.type.ordinal());
            buffer.writeUtf(this.name);
            buffer.writeFloat(this.speed);
        }

        public static SpellAnimation read(RegistryFriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            SpellCast.Animation type = SpellCast.Animation.values()[buffer.readInt()];
            String name = buffer.readUtf();
            float speed = buffer.readFloat();
            return new SpellAnimation(playerId, type, name, speed);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpellAnimation.class, "playerId;type;name;speed", "playerId", "type", "name", "speed"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpellAnimation.class, "playerId;type;name;speed", "playerId", "type", "name", "speed"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpellAnimation.class, "playerId;type;name;speed", "playerId", "type", "name", "speed"}, this, o);
        }

        public int playerId() {
            return this.playerId;
        }

        public SpellCast.Animation type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public float speed() {
            return this.speed;
        }
    }

    public record SpellCooldownSync(int baseTick, Map<ResourceLocation, SpellCooldownManager.Entry> cooldowns) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"cooldown_sync");
        public static final CustomPacketPayload.Type<SpellCooldownSync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellCooldownSync> CODEC = StreamCodec.ofMember(SpellCooldownSync::write, SpellCooldownSync::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.baseTick);
            buffer.writeInt(this.cooldowns.size());
            for (Map.Entry<ResourceLocation, SpellCooldownManager.Entry> entry : this.cooldowns.entrySet()) {
                buffer.writeUtf(entry.getKey().toString());
                buffer.writeInt(entry.getValue().startTick());
                buffer.writeInt(entry.getValue().endTick());
            }
        }

        public static SpellCooldownSync read(RegistryFriendlyByteBuf buffer) {
            int baseTick = buffer.readInt();
            int size = buffer.readInt();
            HashMap<ResourceLocation, SpellCooldownManager.Entry> cooldowns = new HashMap<ResourceLocation, SpellCooldownManager.Entry>();
            for (int i = 0; i < size; ++i) {
                ResourceLocation spellId = ResourceLocation.parse((String)buffer.readUtf());
                int startTick = buffer.readInt();
                int endTick = buffer.readInt();
                cooldowns.put(spellId, new SpellCooldownManager.Entry(startTick, endTick));
            }
            return new SpellCooldownSync(baseTick, cooldowns);
        }
    }

    public record SpellCooldown(ResourceLocation spellId, int duration) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_cooldown");
        public static final CustomPacketPayload.Type<SpellCooldown> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellCooldown> CODEC = StreamCodec.ofMember(SpellCooldown::write, SpellCooldown::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeUtf(this.spellId.toString());
            buffer.writeInt(this.duration);
        }

        public static SpellCooldown read(RegistryFriendlyByteBuf buffer) {
            ResourceLocation spellId = ResourceLocation.parse((String)buffer.readUtf());
            int duration = buffer.readInt();
            return new SpellCooldown(spellId, duration);
        }
    }

    public record SpellRequest(SpellCast.Action action, ResourceLocation spellId, float progress, int[] targets, @Nullable Vec3 location) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"release_request");
        public static final CustomPacketPayload.Type<SpellRequest> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellRequest> CODEC = StreamCodec.ofMember(SpellRequest::write, SpellRequest::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)this.action);
            buffer.writeUtf(this.spellId.toString());
            buffer.writeFloat(this.progress);
            buffer.writeVarIntArray(this.targets);
            if (this.location != null) {
                buffer.writeBoolean(true);
                buffer.writeDouble(this.location.x);
                buffer.writeDouble(this.location.y);
                buffer.writeDouble(this.location.z);
            } else {
                buffer.writeBoolean(false);
            }
        }

        public static SpellRequest read(RegistryFriendlyByteBuf buffer) {
            SpellCast.Action action = (SpellCast.Action)buffer.readEnum(SpellCast.Action.class);
            ResourceLocation spellId = ResourceLocation.parse((String)buffer.readUtf());
            float progress = buffer.readFloat();
            int[] targets = buffer.readVarIntArray();
            Vec3 location = null;
            boolean hasLocation = buffer.readBoolean();
            if (hasLocation) {
                double x = buffer.readDouble();
                double y = buffer.readDouble();
                double z = buffer.readDouble();
                location = new Vec3(x, y, z);
            }
            return new SpellRequest(action, spellId, progress, targets, location);
        }
    }

    public record SpellCastSync(ResourceLocation spellId, float speed, int length) implements CustomPacketPayload
    {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"cast_sync");
        public static final CustomPacketPayload.Type<SpellCastSync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellCastSync> CODEC = StreamCodec.ofMember(SpellCastSync::write, SpellCastSync::read);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            if (this.spellId == null) {
                buffer.writeUtf("");
            } else {
                buffer.writeUtf(this.spellId.toString());
            }
            buffer.writeFloat(this.speed);
            buffer.writeInt(this.length);
        }

        public static SpellCastSync read(RegistryFriendlyByteBuf buffer) {
            String string = buffer.readUtf();
            ResourceLocation spellId = null;
            if (!string.isEmpty()) {
                spellId = ResourceLocation.parse((String)string);
            }
            float speed = buffer.readFloat();
            int length = buffer.readInt();
            return new SpellCastSync(spellId, speed, length);
        }
    }
}

