/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCastSyncHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.network.Packets;

public class ServerNetwork {
    public static void init() {
        PayloadTypeRegistry.configurationS2C().register(Packets.ConfigSync.PACKET_ID, Packets.ConfigSync.CODEC);
        PayloadTypeRegistry.configurationS2C().register(Packets.SpellRegistrySync.PACKET_ID, Packets.SpellRegistrySync.CODEC);
        PayloadTypeRegistry.configurationC2S().register(Packets.Ack.PACKET_ID, Packets.Ack.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((ServerConfigurationPacketListenerImpl)handler, (ResourceLocation)Packets.ConfigSync.ID)) {
                handler.addTask((net.minecraft.server.network.ConfigurationTask)new ConfigurationTask(SpellEngineMod.config));
            } else {
                handler.disconnect((Component)Component.literal((String)"Network configuration task not supported: spell_engine:config"));
            }
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((ServerConfigurationPacketListenerImpl)handler, (ResourceLocation)Packets.SpellRegistrySync.ID)) {
                if (SpellAssignments.encoded.isEmpty()) {
                    throw new AssertionError((Object)"Spell registry is empty!");
                }
                handler.addTask((net.minecraft.server.network.ConfigurationTask)new SpellRegistrySyncTask(SpellAssignments.encoded));
            } else {
                handler.disconnect((Component)Component.literal((String)"Network configuration task not supported: spell_engine:spell_registry"));
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(Packets.Ack.PACKET_ID, (packet, context) -> {
            if (packet.code().equals("spell_engine:config")) {
                context.networkHandler().completeTask(ConfigurationTask.KEY);
            }
            if (packet.code().equals("spell_engine:spell_registry")) {
                context.networkHandler().completeTask(SpellRegistrySyncTask.KEY);
            }
        });
        PayloadTypeRegistry.playC2S().register(Packets.SpellCastSync.PACKET_ID, Packets.SpellCastSync.CODEC);
        PayloadTypeRegistry.playC2S().register(Packets.SpellRequest.PACKET_ID, Packets.SpellRequest.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellCooldown.PACKET_ID, Packets.SpellCooldown.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellCooldownSync.PACKET_ID, Packets.SpellCooldownSync.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellMessage.PACKET_ID, Packets.SpellMessage.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.ParticleBatches.PACKET_ID, Packets.ParticleBatches.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellAnimation.PACKET_ID, Packets.SpellAnimation.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.SpellContainerSync.PACKET_ID, Packets.SpellContainerSync.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(Packets.SpellCastSync.PACKET_ID, (packet, context) -> {
            MinecraftServer server = context.server();
            ServerPlayer player = context.player();
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.getAllLevels(), element -> element == player.level()).orNull();
            if (world == null || world.isClientSide) {
                return;
            }
            world.getServer().executeIfPossible(() -> {
                if (packet.spellId() == null) {
                    SpellCastSyncHelper.clearCasting((Player)player);
                } else {
                    SpellHelper.startCasting((Player)player, packet.spellId(), packet.speed(), packet.length());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(Packets.SpellRequest.PACKET_ID, (packet, context) -> {
            MinecraftServer server = context.server();
            ServerPlayer player = context.player();
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.getAllLevels(), element -> element == player.level()).orNull();
            if (world == null || world.isClientSide) {
                return;
            }
            world.getServer().executeIfPossible(() -> {
                Optional spellEntry = SpellRegistry.from((Level)world).getHolder(packet.spellId());
                if (spellEntry.isEmpty()) {
                    return;
                }
                ArrayList<Entity> targets = new ArrayList<Entity>();
                for (int targetId : packet.targets()) {
                    Entity entity = world.getEntityOrPart(targetId);
                    if (entity != null) {
                        targets.add(entity);
                        continue;
                    }
                    System.err.println("Spell Engine: Trying to perform spell " + packet.spellId().toString() + " Entity not found: " + targetId);
                }
                SpellTarget.SearchResult target = new SpellTarget.SearchResult(targets, packet.location());
                SpellHelper.performSpell((Level)world, (Player)player, (Holder<Spell>)((Holder)spellEntry.get()), target, packet.action(), packet.progress());
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ServerPlayer player = handler.getPlayer();
            ((SpellCasterEntity)handler.getPlayer()).getCooldownManager().pushSync();
            SpellContainerSource.syncServerSideContainers((Player)player);
            SpellEngineMod.migrateAttributes(player);
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, target) -> {
            ((SpellCasterEntity)player).getCooldownManager().pushSync();
            SpellContainerSource.syncServerSideContainers((Player)player);
        });
    }

    public record ConfigurationTask(ServerConfig config) implements net.minecraft.server.network.ConfigurationTask
    {
        public static final String name = "spell_engine:config";
        public static final ConfigurationTask.Type KEY = new ConfigurationTask.Type("spell_engine:config");

        public ConfigurationTask.Type type() {
            return KEY;
        }

        public void start(Consumer<Packet<?>> sender) {
            Packets.ConfigSync packet = new Packets.ConfigSync(this.config);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((CustomPacketPayload)packet));
        }
    }

    public record SpellRegistrySyncTask(List<String> encodedChunks) implements net.minecraft.server.network.ConfigurationTask
    {
        public static final String name = "spell_engine:spell_registry";
        public static final ConfigurationTask.Type KEY = new ConfigurationTask.Type("spell_engine:spell_registry");

        public ConfigurationTask.Type type() {
            return KEY;
        }

        public void start(Consumer<Packet<?>> sender) {
            Packets.SpellRegistrySync packet = new Packets.SpellRegistrySync(this.encodedChunks);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((CustomPacketPayload)packet));
        }
    }
}

