/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series.datagen;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.spell_power.api.SpellPowerTags;

public class RPGSeriesDataGen {
    @SafeVarargs
    public static <E> List<E> combine(List<E> ... smallLists) {
        ArrayList<E> bigList = new ArrayList<E>();
        for (List<E> list : smallLists) {
            bigList.addAll(list);
        }
        return bigList;
    }

    public static abstract class ItemTagGenerator
    extends FabricTagProvider<Item> {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, Registries.ITEM, registriesFuture);
        }

        public void generateWeaponTags(List<Weapon.Entry> weapons) {
            for (Weapon.Entry weapon : weapons) {
                String lootTheme;
                TagKey<Item> weaponType = RPGSeriesItemTags.WeaponType.get(weapon.category());
                FabricTagProvider.FabricTagBuilder weaponTag = this.getOrCreateTagBuilder(weaponType);
                weaponTag.addOptional(weapon.id());
                int tier = weapon.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get(tier, RPGSeriesItemTags.LootCategory.WEAPONS));
                    tierTag.addOptional(weapon.id());
                }
                if ((lootTheme = weapon.lootProperties().theme()) == null || lootTheme.isEmpty()) continue;
                FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get(lootTheme));
                themeTag.addOptional(weapon.id());
            }
        }

        public void generateArmorTags(List<Armor.Entry> armors) {
            this.generateArmorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class));
        }

        public void generateArmorTags(List<Armor.Entry> armors, ArmorOptions options) {
            this.generateArmorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class), options);
        }

        public void generateArmorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType) {
            this.generateArmorTags(armors, EnumSet.of(metaType));
        }

        public void generateArmorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType, ArmorOptions options) {
            this.generateArmorTags(armors, EnumSet.of(metaType), options);
        }

        public void generateArmorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes) {
            this.generateArmorTags(armors, metaTypes, ArmorOptions.DEFAULT);
        }

        public void generateArmorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes, ArmorOptions options) {
            for (Armor.Entry armor : armors) {
                Armor.Set set = armor.armorSet();
                FabricTagProvider.FabricTagBuilder headTag = this.getOrCreateTagBuilder(ItemTags.HEAD_ARMOR);
                headTag.add(set.head);
                FabricTagProvider.FabricTagBuilder chestTag = this.getOrCreateTagBuilder(ItemTags.CHEST_ARMOR);
                chestTag.add(set.chest);
                FabricTagProvider.FabricTagBuilder legsTag = this.getOrCreateTagBuilder(ItemTags.LEG_ARMOR);
                legsTag.add(set.legs);
                FabricTagProvider.FabricTagBuilder feetTag = this.getOrCreateTagBuilder(ItemTags.FOOT_ARMOR);
                feetTag.add(set.feet);
                int tier = armor.lootProperties().tier();
                if (options.allowLootTierTags && tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get(tier, RPGSeriesItemTags.LootCategory.ARMORS));
                    for (Object object : armor.armorSet().pieceIds()) {
                        tierTag.addOptional((ResourceLocation)object);
                    }
                }
                String lootTheme = armor.lootProperties().theme();
                if (options.allowLootThemeTags && lootTheme != null && !lootTheme.isEmpty()) {
                    FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get(lootTheme));
                    for (ResourceLocation id2 : armor.armorSet().pieceIds()) {
                        themeTag.addOptional(id2);
                    }
                }
                for (RPGSeriesItemTags.ArmorMetaType armorMetaType : metaTypes) {
                    FabricTagProvider.FabricTagBuilder metaTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.ArmorType.get(armorMetaType));
                    for (ResourceLocation id : armor.armorSet().pieceIds()) {
                        metaTag.addOptional(id);
                    }
                }
            }
        }

        public void generateBowTags(List<BowEntry> bows) {
            for (BowEntry entry : bows) {
                ResourceLocation id = entry.id();
                TagKey<Item> weaponType = RPGSeriesItemTags.WeaponType.get(entry.weaponType());
                FabricTagProvider.FabricTagBuilder weaponTag = this.getOrCreateTagBuilder(weaponType);
                weaponTag.addOptional(id);
            }
            this.generateLootTags(bows.stream().collect(Collectors.toMap(BowEntry::id, BowEntry::lootProperties)), RPGSeriesItemTags.LootCategory.WEAPONS);
        }

        public void generateShieldTags(List<ShieldEntry> shields) {
            for (ShieldEntry entry : shields) {
                ResourceLocation id = entry.id();
                TagKey<Item> weaponType = RPGSeriesItemTags.WeaponType.get(Equipment.WeaponType.SHIELD);
                FabricTagProvider.FabricTagBuilder weaponTag = this.getOrCreateTagBuilder(weaponType);
                weaponTag.addOptional(id);
            }
            this.generateLootTags(shields.stream().collect(Collectors.toMap(ShieldEntry::id, ShieldEntry::lootProperties)), RPGSeriesItemTags.LootCategory.WEAPONS);
        }

        public void generateAccessoryTags(Map<ResourceLocation, Equipment.LootProperties> accessories) {
            this.generateLootTags(accessories, RPGSeriesItemTags.LootCategory.ACCESSORIES);
        }

        public void generateRelicTags(Map<ResourceLocation, Equipment.LootProperties> relics) {
            this.generateLootTags(relics, RPGSeriesItemTags.LootCategory.RELICS);
        }

        public void generateLootTags(Map<ResourceLocation, Equipment.LootProperties> items, RPGSeriesItemTags.LootCategory category) {
            for (Map.Entry<ResourceLocation, Equipment.LootProperties> entry : items.entrySet()) {
                String lootTheme;
                ResourceLocation id = entry.getKey();
                Equipment.LootProperties lootProperties = entry.getValue();
                int tier = lootProperties.tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get(tier, category));
                    tierTag.addOptional(id);
                }
                if ((lootTheme = lootProperties.theme()) == null || lootTheme.isEmpty()) continue;
                FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get(lootTheme));
                themeTag.addOptional(id);
            }
        }

        public record ArmorOptions(boolean allowLootTierTags, boolean allowLootThemeTags) {
            public static final ArmorOptions DEFAULT = new ArmorOptions(true, true);
        }
    }

    public record BowEntry(ResourceLocation id, Equipment.WeaponType weaponType, Equipment.LootProperties lootProperties) {
    }

    public record ShieldEntry(ResourceLocation id, Equipment.LootProperties lootProperties) {
    }

    public static class BaselineTagGenerator
    extends FabricTagProvider<Item> {
        public BaselineTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, Registries.ITEM, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            for (Map.Entry<Equipment.WeaponType, TagKey<Item>> entry : RPGSeriesItemTags.WeaponType.ALL.entrySet()) {
                FabricTagProvider.FabricTagBuilder fabricTagBuilder = this.getOrCreateTagBuilder(entry.getValue());
            }
            for (RPGSeriesItemTags.RoleArchetype archetype : RPGSeriesItemTags.RoleArchetype.values()) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(RPGSeriesItemTags.Archetype.tag(archetype));
                for (Map.Entry<Equipment.WeaponType, TagKey<Item>> entry : RPGSeriesItemTags.WeaponType.ALL.entrySet()) {
                    if (RPGSeriesItemTags.Archetype.classify(entry.getKey()) != archetype) continue;
                    tag.addTag(entry.getValue());
                }
            }
            for (Map.Entry entry : RPGSeriesItemTags.LootThemes.ALL.entrySet()) {
                FabricTagProvider.FabricTagBuilder fabricTagBuilder = this.getOrCreateTagBuilder((TagKey)entry.getValue());
            }
            for (int i = 0; i < 10; ++i) {
                for (RPGSeriesItemTags.LootCategory category : RPGSeriesItemTags.LootCategory.values()) {
                    FabricTagProvider.FabricTagBuilder fabricTagBuilder = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get(i, category));
                }
            }
            for (Map.Entry<RPGSeriesItemTags.ArmorMetaType, TagKey<Item>> entry : RPGSeriesItemTags.ArmorType.ALL.entrySet()) {
                FabricTagProvider.FabricTagBuilder fabricTagBuilder = this.getOrCreateTagBuilder(entry.getValue());
            }
            List<Equipment.WeaponType> fullSpellWeaponTypes = List.of(Equipment.WeaponType.DAMAGE_STAFF, Equipment.WeaponType.DAMAGE_WAND, Equipment.WeaponType.HEALING_STAFF, Equipment.WeaponType.HEALING_WAND, Equipment.WeaponType.SPELL_BLADE, Equipment.WeaponType.SPELL_SCYTHE);
            List<Equipment.WeaponType> list = List.of(Equipment.WeaponType.SWORD, Equipment.WeaponType.CLAYMORE, Equipment.WeaponType.MACE, Equipment.WeaponType.HAMMER, Equipment.WeaponType.GLAIVE);
            List<Object> spellInfinityTypes = RPGSeriesDataGen.combine(fullSpellWeaponTypes, list);
            FabricTagProvider.FabricTagBuilder spellInfinityTag = this.getOrCreateTagBuilder(SpellEngineItemTags.ENCHANTABLE_SPELL_INFINITY);
            for (Object type : spellInfinityTypes) {
                spellInfinityTag.addTag(RPGSeriesItemTags.WeaponType.get((Equipment.WeaponType)((Object)type)));
            }
            FabricTagProvider.FabricTagBuilder spellHasteTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.HASTE);
            for (Equipment.WeaponType weaponType : fullSpellWeaponTypes) {
                spellHasteTag.addTag(RPGSeriesItemTags.WeaponType.get(weaponType));
            }
            FabricTagProvider.FabricTagBuilder criticalDamageTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.CRITICAL_DAMAGE);
            for (Equipment.WeaponType type : fullSpellWeaponTypes) {
                criticalDamageTag.addTag(RPGSeriesItemTags.WeaponType.get(type));
            }
            List<Equipment.WeaponType> list2 = RPGSeriesDataGen.combine(fullSpellWeaponTypes, list);
            FabricTagProvider.FabricTagBuilder spellPowerTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.SPELL_POWER_GENERIC);
            for (Equipment.WeaponType type : list2) {
                spellPowerTag.addTag(RPGSeriesItemTags.WeaponType.get(type));
            }
            FabricTagProvider.FabricTagBuilder spellVolatilityTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.CRITICAL_CHANCE);
            spellVolatilityTag.addTag(RPGSeriesItemTags.ArmorType.get(RPGSeriesItemTags.ArmorMetaType.MAGIC));
            Equipment.WeaponType[] unbreakingTypes = Equipment.WeaponType.values();
            FabricTagProvider.FabricTagBuilder unbreakingTag = this.getOrCreateTagBuilder(ItemTags.DURABILITY_ENCHANTABLE);
            for (Equipment.WeaponType type : unbreakingTypes) {
                unbreakingTag.addTag(RPGSeriesItemTags.WeaponType.get(type));
            }
            List<Equipment.WeaponType> sharpWeaponTypes = List.of(Equipment.WeaponType.SWORD, Equipment.WeaponType.SPEAR, Equipment.WeaponType.CLAYMORE, Equipment.WeaponType.MACE, Equipment.WeaponType.HAMMER, Equipment.WeaponType.DAGGER, Equipment.WeaponType.SICKLE, Equipment.WeaponType.DOUBLE_AXE, Equipment.WeaponType.GLAIVE, Equipment.WeaponType.SPELL_BLADE, Equipment.WeaponType.SPELL_SCYTHE);
            FabricTagProvider.FabricTagBuilder sharpTag = this.getOrCreateTagBuilder(ItemTags.SHARP_WEAPON_ENCHANTABLE);
            for (Equipment.WeaponType type : sharpWeaponTypes) {
                sharpTag.addTag(RPGSeriesItemTags.WeaponType.get(type));
            }
            List<Equipment.WeaponType> meleeWeaponTypes = List.of(Equipment.WeaponType.SWORD, Equipment.WeaponType.CLAYMORE, Equipment.WeaponType.MACE, Equipment.WeaponType.HAMMER, Equipment.WeaponType.SPEAR, Equipment.WeaponType.DAGGER, Equipment.WeaponType.SICKLE, Equipment.WeaponType.DOUBLE_AXE, Equipment.WeaponType.GLAIVE);
            FabricTagProvider.FabricTagBuilder meleeTag = this.getOrCreateTagBuilder(ItemTags.SWORDS);
            for (Equipment.WeaponType weaponType : meleeWeaponTypes) {
                meleeTag.addTag(RPGSeriesItemTags.WeaponType.get(weaponType));
            }
            List<Equipment.WeaponType> bowTypes = List.of(Equipment.WeaponType.SHORT_BOW, Equipment.WeaponType.LONG_BOW);
            for (Equipment.WeaponType type : bowTypes) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(ItemTags.BOW_ENCHANTABLE);
                tag.addTag(RPGSeriesItemTags.WeaponType.get(type));
            }
            List<Equipment.WeaponType> list3 = List.of(Equipment.WeaponType.RAPID_CROSSBOW, Equipment.WeaponType.HEAVY_CROSSBOW);
            for (Equipment.WeaponType type : list3) {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(ItemTags.CROSSBOW_ENCHANTABLE);
                tag.addTag(RPGSeriesItemTags.WeaponType.get(type));
            }
        }
    }
}

