/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.spell_engine.rpg_series.loot.LootConfig;
import net.spell_engine.spellbinding.SpellBindRandomlyLootFunction;
import net.tiny_config.ConfigManager;

public class LootHelper {
    public static ConfigManager<TagCache> TAG_CACHE = new ConfigManager("tag_cache", (Object)new TagCache()).builder().setDirectory("rpg_series").sanitize(true).build();

    public static void updateTagCache(LootConfig lootConfig) {
        HashSet<String> updatedTags = new HashSet<String>();
        for (Map.Entry<String, LootConfig.Pool> entry : lootConfig.injectors.entrySet()) {
            String tableId = entry.getKey();
            LootConfig.Pool pool = entry.getValue();
            for (LootConfig.Pool.Entry itemInjectorEntry : pool.entries) {
                ArrayList<String> tagsToCache = new ArrayList<String>();
                if (itemInjectorEntry.id != null) {
                    tagsToCache.add(itemInjectorEntry.id);
                }
                if (itemInjectorEntry.filters != null) {
                    tagsToCache.addAll(itemInjectorEntry.filters);
                }
                for (String id : tagsToCache) {
                    String tagString;
                    if (!id.startsWith("#") || updatedTags.contains(tagString = id.substring(1))) continue;
                    ResourceLocation tagId = ResourceLocation.parse((String)tagString);
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId);
                    ArrayList itemList = new ArrayList();
                    BuiltInRegistries.ITEM.getTagOrEmpty(tag).forEach(itemEntry -> {
                        ResourceLocation itemId = ((ResourceKey)itemEntry.unwrapKey().get()).location();
                        itemList.add(itemId.toString());
                    });
                    ((TagCache)LootHelper.TAG_CACHE.value).cache.put(tagString, itemList);
                    updatedTags.add(tagString);
                }
            }
        }
        TAG_CACHE.save();
    }

    public static void configureV2(HolderLookup.Provider registries, ResourceLocation id, LootTable.Builder tableBuilder, LootConfig config, HashMap<String, Item> entries) {
        String tableId = id.toString();
        LootConfig.Pool pool = config.injectors.get(tableId);
        if (pool == null) {
            for (String regex : config.regex_injectors.keySet()) {
                if (!tableId.matches(regex)) continue;
                pool = config.regex_injectors.get(regex);
                break;
            }
        }
        if (pool == null) {
            return;
        }
        float rolls = pool.rolls > 0.0f ? pool.rolls : 1.0f;
        LootPool.Builder lootPoolBuilder = LootPool.lootPool();
        double attempts = Math.ceil(rolls);
        double chance = (double)pool.rolls / attempts;
        lootPoolBuilder.setRolls((NumberProvider)BinomialDistributionGenerator.binomial((int)((int)attempts), (float)((float)chance)));
        lootPoolBuilder.setBonusRolls((NumberProvider)ConstantValue.exactly((float)pool.bonus_rolls));
        for (LootConfig.Pool.Entry entry : pool.entries) {
            List<Object> filters;
            String entryId = entry.id;
            int weight = entry.weight;
            LootConfig.Pool.Entry.Enchant enchant = entry.enchant;
            LootConfig.Pool.Entry.SpellBind spellBind = entry.spell_bind;
            if (entryId == null || entryId.isEmpty()) continue;
            List<String> itemList = entryId.startsWith("#") ? ((TagCache)LootHelper.TAG_CACHE.value).cache.get(entryId.substring(1)) : List.of(entryId);
            List<Object> list = filters = entry.filters != null ? entry.filters : List.of();
            if (itemList == null) {
                System.err.println("RPG Series loot config: failed to resolve itemList for: " + entryId + " (Probably just needs a game restart)");
                continue;
            }
            for (String itemId : itemList) {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
                if (item == null) continue;
                LootPoolSingletonContainer.Builder lootEntry = LootItem.lootTableItem((ItemLike)item).setWeight(weight);
                boolean filtersMatch = entry.filters_lenient ? filters.isEmpty() : true;
                for (String string : filters) {
                    List<String> tag;
                    if (!string.startsWith("#") || (tag = ((TagCache)LootHelper.TAG_CACHE.value).cache.get(string.substring(1))) == null) continue;
                    boolean contains = tag.contains(itemId);
                    if (entry.filters_lenient) {
                        filtersMatch = filtersMatch || contains;
                        continue;
                    }
                    filtersMatch = filtersMatch && contains;
                }
                if (!filtersMatch) continue;
                if (enchant != null && enchant.isValid()) {
                    EnchantWithLevelsFunction.Builder enchantFunction = EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)registries, (NumberProvider)LootHelper.numberProvider(enchant.min_power, enchant.max_power));
                    lootEntry.apply((LootItemFunction.Builder)enchantFunction);
                }
                if (spellBind != null && spellBind.isValid()) {
                    LootItemConditionalFunction.Builder<?> function = SpellBindRandomlyLootFunction.builder(spellBind.pool, LootHelper.numberProvider(spellBind.tier_min, spellBind.tier_max), LootHelper.numberProvider(spellBind.count_min, spellBind.count_max));
                    lootEntry.apply(function);
                }
                lootPoolBuilder.add((LootPoolEntryContainer.Builder)lootEntry);
            }
        }
        tableBuilder.pool(lootPoolBuilder.build());
    }

    private static NumberProvider numberProvider(float min, float max) {
        if (max <= min) {
            return ConstantValue.exactly((float)min);
        }
        return UniformGenerator.between((float)min, (float)max);
    }

    private static List<TagKey<Item>> tagKeys(List<String> tags) {
        return tags.stream().map(LootHelper::tagKey).toList();
    }

    private static TagKey<Item> tagKey(String tag) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag));
    }

    public static class TagCache {
        public HashMap<String, List<String>> cache = new HashMap();
    }
}

