/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingBlock;
import net.spell_engine.spellbinding.SpellBindingCriteria;
import net.spell_engine.spellbinding.SpellBookCreationCriteria;

public class SpellBindingScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<SpellBindingScreenHandler> HANDLER_TYPE = new MenuType(SpellBindingScreenHandler::new, FeatureFlags.VANILLA_SET);
    public static final int MAXIMUM_SPELL_COUNT = 32;
    public static final int INIT_SYNC_ID = 14999;
    private static final int SPELL_ID_RAW_NONE = -1;
    private final Container inventory = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            SpellBindingScreenHandler.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess context;
    private boolean creative = false;
    public final int[] mode = new int[]{SpellBinding.Mode.SPELL.ordinal()};
    public final int[] spellId = new int[32];
    public final int[] spellLevelCost = new int[32];
    public final int[] spellLevelRequirement = new int[32];
    public final int[] spellPoweredByLib = new int[32];
    public final int[] spellLapisCost = new int[32];

    public SpellBindingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public SpellBindingScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(HANDLER_TYPE, syncId);
        int i;
        this.context = context;
        this.addSlot(new Slot(this, this.inventory, 0, 15, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == Items.BOOK || SpellContainerHelper.hasBindableContainer(stack);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.inventory, 1, 35, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.LAPIS_LAZULI) || stack.is(SpellEngineItemTags.SPELL_BOOK_MERGEABLE);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        for (i = 0; i < 32; ++i) {
            this.addDataSlot(DataSlot.shared((int[])this.spellId, (int)i));
            this.addDataSlot(DataSlot.shared((int[])this.spellLevelCost, (int)i));
            this.addDataSlot(DataSlot.shared((int[])this.spellLevelRequirement, (int)i));
            this.addDataSlot(DataSlot.shared((int[])this.spellPoweredByLib, (int)i));
            this.addDataSlot(DataSlot.shared((int[])this.spellLapisCost, (int)i));
        }
        this.addDataSlot(DataSlot.shared((int[])this.mode, (int)0));
        Arrays.fill(this.spellId, -1);
        Player player = playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SpellBindingCriteria.INSTANCE.trigger(serverPlayer, SpellBinding.ADVANCEMENT_VISIT_ID, true);
        }
    }

    public int getLapisCount() {
        ItemStack itemStack = this.inventory.getItem(1);
        if (itemStack.isEmpty()) {
            return 0;
        }
        return itemStack.getCount();
    }

    public void slotsChanged(Container inventory) {
        if (inventory != this.inventory) {
            return;
        }
        ItemStack mainStack = inventory.getItem(0);
        ItemStack consumableStack = inventory.getItem(1);
        if (mainStack.isEmpty() || !SpellContainerHelper.hasValidContainer(mainStack) && mainStack.getItem() != Items.BOOK) {
            this.mode[0] = SpellBinding.Mode.SPELL.ordinal();
            for (int i = 0; i < 32; ++i) {
                this.spellId[i] = -1;
                this.spellLevelCost[i] = 0;
                this.spellLevelRequirement[i] = 0;
                this.spellPoweredByLib[i] = 0;
                this.spellLapisCost[i] = 0;
            }
        } else {
            this.context.execute((world, pos) -> {
                int libraryPower = 0;
                for (BlockPos blockPos : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                    if (!EnchantingTableBlock.isValidBookShelf((Level)world, (BlockPos)pos, (BlockPos)blockPos)) continue;
                    ++libraryPower;
                }
                SpellBinding.OfferResult offerResult = SpellBinding.offersFor(world, this.creative, mainStack, consumableStack, libraryPower);
                this.mode[0] = offerResult.mode().ordinal();
                List<SpellBinding.Offer> offers = offerResult.offers();
                for (int i = 0; i < 32; ++i) {
                    if (i < offers.size()) {
                        SpellBinding.Offer offer = offers.get(i);
                        this.spellId[i] = offer.id();
                        this.spellLevelCost[i] = offer.levelCost();
                        this.spellLevelRequirement[i] = offer.levelRequirement();
                        this.spellPoweredByLib[i] = offer.isPowered() ? 1 : 0;
                        this.spellLapisCost[i] = offer.lapisCost();
                        continue;
                    }
                    this.spellId[i] = -1;
                    this.spellLevelCost[i] = 0;
                    this.spellLevelRequirement[i] = 0;
                    this.spellPoweredByLib[i] = 0;
                    this.spellLapisCost[i] = 0;
                }
                this.broadcastChanges();
            });
        }
    }

    public boolean stillValid(Player player) {
        return EnchantmentMenu.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)SpellBindingBlock.INSTANCE);
    }

    public void removed(Player player) {
        super.removed(player);
        this.context.execute((world, pos) -> this.clearContainer(player, this.inventory));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index == 1) {
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemStack2.is(Items.LAPIS_LAZULI) || itemStack2.is(SpellEngineItemTags.SPELL_BOOK_MERGEABLE)) {
                if (!this.moveItemStackTo(itemStack2, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!((Slot)this.slots.get(0)).hasItem() && ((Slot)this.slots.get(0)).mayPlace(itemStack2)) {
                ItemStack itemStack3 = itemStack2.copy();
                itemStack3.setCount(1);
                itemStack2.shrink(1);
                ((Slot)this.slots.get(0)).setByPlayer(itemStack3);
            } else {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    public boolean clickMenuButton(Player player, int id) {
        this.creative = player.isCreative();
        if (id == 14999) {
            return false;
        }
        try {
            SpellBinding.Mode mode = SpellBinding.Mode.values()[this.mode[0]];
            int rawId = this.spellId[id];
            int levelCost = this.spellLevelCost[id];
            int requiredLevel = this.spellLevelRequirement[id];
            int poweredByLib = this.spellPoweredByLib[id];
            int lapisCost = this.spellLapisCost[id];
            int lapisCount = this.getLapisCount();
            ItemStack mainStack = (ItemStack)this.getItems().get(0);
            ItemStack consumableStack = (ItemStack)this.getItems().get(1);
            Level playerWorld = player.level();
            if (poweredByLib == 0) {
                return false;
            }
            switch (mode) {
                case SPELL: {
                    Optional spellEntry = SpellRegistry.from(playerWorld).getHolder(rawId);
                    if (spellEntry.isEmpty()) {
                        return false;
                    }
                    ResourceLocation spellId = ((ResourceKey)((Holder.Reference)spellEntry.get()).unwrapKey().get()).location();
                    SpellBinding.State binding = SpellBinding.State.of(spellId, mainStack, requiredLevel, levelCost, lapisCost);
                    if (binding.state == SpellBinding.State.ApplyState.INVALID) {
                        return false;
                    }
                    if (!binding.readyToApply(player, lapisCount)) {
                        return false;
                    }
                    this.context.execute((world, pos) -> {
                        SpellContainerHelper.addSpell(world, spellId, mainStack);
                        if (consumableStack.is(SpellEngineItemTags.SPELL_BOOK_MERGEABLE)) {
                            consumableStack.shrink(1);
                        } else if (!player.isCreative()) {
                            consumableStack.shrink(binding.requirements.lapisCost());
                        }
                        SpellBindingScreenHandler.applyLevelCost(player, binding.requirements.levelCost());
                        this.inventory.setChanged();
                        this.slotsChanged(this.inventory);
                        world.playSound(null, pos, SpellEngineSounds.BIND_SPELL.soundEvent(), SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.1f + 0.9f);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            SpellContainer container = SpellContainerHelper.containerFromItemStack(mainStack);
                            ResourceLocation poolId = SpellContainerHelper.getPoolId(container);
                            if (poolId != null) {
                                List<Holder<Spell>> pool = SpellRegistry.entries(world, container.pool());
                                boolean isComplete = container.spell_ids().size() == pool.size();
                                SpellBindingCriteria.INSTANCE.trigger(serverPlayer, poolId, isComplete);
                            } else {
                                SpellBindingCriteria.INSTANCE.trigger(serverPlayer, null, false);
                            }
                        }
                    });
                    break;
                }
                case BOOK: {
                    ISpellBookItem item = SpellBinding.availableSpellBooks(player.level()).get(rawId - 1);
                    ItemStack itemStack = ((Item)item).getDefaultInstance();
                    SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
                    if (container == null || !container.isValid() || container.pool() == null) {
                        return false;
                    }
                    ResourceLocation poolId = ResourceLocation.parse((String)container.pool());
                    SpellBinding.State binding = SpellBinding.State.forBook(levelCost, requiredLevel);
                    if (binding.state == SpellBinding.State.ApplyState.INVALID) {
                        return false;
                    }
                    if (!binding.readyToApply(player, lapisCount)) {
                        return false;
                    }
                    this.context.execute((world, pos) -> {
                        ((Slot)this.slots.get(0)).setByPlayer(itemStack);
                        if (!player.isCreative()) {
                            consumableStack.shrink(binding.requirements.lapisCost());
                        }
                        SpellBindingScreenHandler.applyLevelCost(player, binding.requirements.levelCost());
                        this.inventory.setChanged();
                        this.slotsChanged(this.inventory);
                        world.playSound(null, pos, SpellEngineSounds.BIND_SPELL.soundEvent(), SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.1f + 0.9f);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            SpellBookCreationCriteria.INSTANCE.trigger(serverPlayer, poolId);
                        }
                    });
                }
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void applyLevelCost(Player player, int levelCost) {
        player.experienceLevel -= levelCost;
        if (player.experienceLevel < 0) {
            player.experienceLevel = 0;
            player.experienceProgress = 0.0f;
            player.totalExperience = 0;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.setExperienceLevels(player.experienceLevel);
        }
    }
}

