/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.container.SpellAssignments;

public class WeaponCompatibility {
    public static void initialize() {
        ServerConfig config = SpellEngineMod.config;
        SpellContainer spellProxyContainer = new SpellContainer(SpellContainer.ContentType.MAGIC, true, null, 0, List.of());
        SpellContainer arrowProxyContainer = new SpellContainer(SpellContainer.ContentType.ARCHERY, true, null, 0, List.of());
        for (ResourceLocation itemId : BuiltInRegistries.ITEM.keySet()) {
            String itemIdString = itemId.toString();
            if (WeaponCompatibility.matches(itemIdString, config.blacklist_spell_casting_regex)) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            boolean addProxy = false;
            SpellContainer.ContentType contentType = SpellContainer.ContentType.MAGIC;
            if (config.add_spell_casting_to_melee_weapons && (item instanceof SwordItem || item instanceof TridentItem || item instanceof MaceItem)) {
                addProxy = true;
            } else if (config.add_spell_casting_to_ranged_weapons && item instanceof ProjectileWeaponItem) {
                contentType = SpellContainer.ContentType.ARCHERY;
                addProxy = true;
            } else if (WeaponCompatibility.matches(itemIdString, config.add_spell_casting_regex)) {
                addProxy = true;
            }
            if (!addProxy) continue;
            switch (contentType) {
                case MAGIC: {
                    SpellAssignments.containers.putIfAbsent(itemId, spellProxyContainer);
                    break;
                }
                case ARCHERY: {
                    SpellAssignments.containers.putIfAbsent(itemId, arrowProxyContainer);
                }
            }
        }
    }

    public static boolean matches(String subject, String nullableRegex) {
        if (subject == null) {
            return false;
        }
        if (nullableRegex == null || nullableRegex.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(nullableRegex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }
}

