/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface WorldScheduler {
    public long getSchedulerTime();

    public Map<Long, List<Runnable>> getScheduledTasks();

    public ArrayList<Runnable> getImmediateTasks();

    default public void schedule(int ticks, Runnable task) {
        if (ticks < 0) {
            task.run();
            return;
        }
        if (ticks == 0) {
            this.getImmediateTasks().add(task);
            return;
        }
        long executionTime = this.getSchedulerTime() + (long)ticks;
        List list = this.getScheduledTasks().getOrDefault(executionTime, new ArrayList());
        list.add(task);
        this.getScheduledTasks().put(executionTime, list);
    }

    default public void updateScheduledTasks() {
        Map<Long, List<Runnable>> taskQueue;
        if (!this.getImmediateTasks().isEmpty()) {
            ArrayList<Runnable> copyTasks = new ArrayList<Runnable>(this.getImmediateTasks());
            this.getImmediateTasks().clear();
            for (Runnable task : copyTasks) {
                task.run();
            }
        }
        if ((taskQueue = this.getScheduledTasks()).isEmpty()) {
            return;
        }
        long currentTime = this.getSchedulerTime();
        List<Runnable> currentTasks = taskQueue.get(currentTime);
        if (currentTasks != null) {
            for (Runnable task : currentTasks) {
                task.run();
            }
            taskQueue.remove(currentTime);
        }
    }
}

