/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.spell_engine.utils.PatternMatching;
import org.jetbrains.annotations.Nullable;

public class SpellEntityPredicates {
    private static final Map<String, Entry> entries = new HashMap<String, Entry>();
    public static final Entry TYPE_MATCHES = SpellEntityPredicates.register(class_2960.method_60655((String)"spell_engine", (String)"type_matches"), args -> {
        if (args.param == null) {
            return true;
        }
        return PatternMatching.matches(args.entity.method_5864().method_40124(), class_7924.field_41266, args.param);
    });
    public static final Entry HAS_EFFECT = SpellEntityPredicates.register(class_2960.method_60655((String)"spell_engine", (String)"has_effect"), args -> {
        if (args.param == null) {
            return true;
        }
        class_1297 patt0$temp = args.entity;
        if (patt0$temp instanceof class_1309) {
            class_1309 livingEntity = (class_1309)patt0$temp;
            class_2960 id = class_2960.method_60654((String)args.param);
            Optional effect = class_7923.field_41174.method_55841(id);
            if (effect.isEmpty()) {
                return false;
            }
            return livingEntity.method_6059((class_6880)effect.get());
        }
        return false;
    });
    public static final Entry HAS_BAD_EFFECT = SpellEntityPredicates.register(class_2960.method_60655((String)"spell_engine", (String)"has_bad_effect"), args -> {
        class_1297 patt0$temp = args.entity;
        if (patt0$temp instanceof class_1309) {
            class_1309 livingEntity = (class_1309)patt0$temp;
            for (class_1293 instance : livingEntity.method_6026()) {
                class_1291 effect = (class_1291)instance.method_5579().comp_349();
                if (effect.method_5573()) continue;
                return true;
            }
        }
        return false;
    });
    public static final Entry HAS_GOOD_EFFECT = SpellEntityPredicates.register(class_2960.method_60655((String)"spell_engine", (String)"has_good_effect"), args -> {
        class_1297 patt0$temp = args.entity;
        if (patt0$temp instanceof class_1309) {
            class_1309 livingEntity = (class_1309)patt0$temp;
            for (class_1293 instance : livingEntity.method_6026()) {
                class_1291 effect = (class_1291)instance.method_5579().comp_349();
                if (!effect.method_5573()) continue;
                return true;
            }
        }
        return false;
    });
    public static final Entry IS_ON_FIRE = SpellEntityPredicates.register(class_2960.method_60655((String)"spell_engine", (String)"is_on_fire"), args -> args.entity.method_5809());
    public static final Entry IS_POISONED = SpellEntityPredicates.hasEffectOptimized(((class_5321)class_1294.field_5899.method_40230().get()).method_29177());

    public static Entry register(class_2960 id, Predicate<Input> predicate) {
        Entry entry = new Entry(id, predicate);
        entries.put(id.toString(), entry);
        return entry;
    }

    public static Entry get(class_2960 id) {
        return entries.get(id.toString());
    }

    public static Entry get(String idString) {
        return entries.get(idString);
    }

    public static Entry registerOrGet(class_2960 id, Predicate<Input> predicate) {
        Entry entry = SpellEntityPredicates.get(id);
        if (entry == null) {
            entry = SpellEntityPredicates.register(id, predicate);
        }
        return entry;
    }

    public static Entry hasEffectOptimized(class_2960 effectId) {
        class_2960 predicateId = class_2960.method_60655((String)"has_effect_optimized", (String)(effectId.method_12836() + "." + effectId.method_12832()));
        return SpellEntityPredicates.registerOrGet(predicateId, args -> {
            class_1297 patt0$temp = args.entity;
            if (patt0$temp instanceof class_1309) {
                class_1309 livingEntity = (class_1309)patt0$temp;
                return livingEntity.method_6059((class_6880)class_7923.field_41174.method_55841(effectId).orElse(null));
            }
            return false;
        });
    }

    public record Entry(class_2960 id, Predicate<Input> predicate) {
    }

    public record Input(class_1297 entity, class_1297 other, @Nullable String param) {
    }
}

