/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.config;

import java.util.LinkedHashMap;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.spell_engine.internals.target.EntityRelation;

@Config(name="server")
public class ServerConfig
implements ConfigData {
    @Comment(value="Applied as multiplier on top of spell.cast.movement_speed. Default value of 1.0 means no change.")
    public float movement_multiplier_speed_while_casting = 1.0f;
    @Comment(value="Allow spells to bypass invulnerability frames. This is required in order for high attack frequency spells (such as beams) to work.")
    public boolean bypass_iframes = true;
    @Comment(value="Spell haste reduces the cooldown time of abilities")
    public boolean haste_affects_cooldown = true;
    @Comment(value="Spell costs exhausts (hunger) will be multiplied with this value. Set `0` for no exhaust.")
    public float spell_cost_exhaust_multiplier = 1.0f;
    @Comment(value="Spells should levelCost items. Set `false` to remove rune (or other item) levelCost from all spells.")
    public boolean spell_cost_item_allowed = true;
    @Comment(value="Spells should damage items on use. Set `false` to disable.")
    public boolean spell_cost_durability_allowed = true;
    @Comment(value="The time in ticks of global cooldown to apply to all instant cast spells when casted.")
    public int spell_instant_cast_gcd = 0;
    @Comment(value="Players cannot unequip a spell book, if one of the spells in it is on cooldown.")
    public boolean spell_item_cooldown_lock = true;
    @Comment(value="Players can use the Spell Binding Table to create spell books.")
    public boolean spell_book_creation_enabled = true;
    @Comment(value="Spell book creation level levelCost")
    public int spell_book_creation_cost = 1;
    @Comment(value="Spell book creation level requirement")
    public int spell_book_creation_requirement = 1;
    @Comment(value="Spell binding level levelCost multiplier")
    public int spell_binding_level_cost_multiplier = 1;
    @Comment(value="Spell binding lapis lazuli levelCost multiplier")
    public int spell_binding_lapis_cost_multiplier = 1;
    public int spell_scroll_level_cost_per_tier = 0;
    public int spell_scroll_apply_cost_base = 1;
    @Comment(value="Allow spell containers be cached for faster improved server performance. Might be buggy.")
    public boolean spell_container_caching = true;
    @Comment(value="Allow any spell containers to be resolved from the offhand not just offhand specific ones.")
    public boolean spell_container_from_offhand_any = false;
    @Comment(value="If set true, a Fireball doesn't collide with an ally, a healing projectile doesn't collide with an enemy")
    public boolean projectiles_pass_thru_irrelevant_targets = true;
    @Comment(value="Auto swap Bow & Spear cooldown ticks to apply for attack and itemUse")
    public int auto_swap_cooldown = 5;
    @Comment(value="Apply `Spell Casting from Spell Book` capability to Swords, Tridents, Maces")
    public boolean add_spell_casting_to_melee_weapons = true;
    @Comment(value="Apply `Spell Casting from Spell Book` capability to Bows, Crossbows")
    public boolean add_spell_casting_to_ranged_weapons = true;
    @Comment(value="Apply `Spell Casting from Spell Book` capability to any item matching this regex. (Not applied of empty)")
    public String add_spell_casting_regex = "";
    @Comment(value="Do not apply `Spell Casting from Spell Book` capability to any item matching this regex. (Not applied of empty)")
    public String blacklist_spell_casting_regex = "";
    @Comment(value="Evasion to work within certain angle of attack\nExample values:\n- `0` - any attack can be evaded\n- `90` (default) - no attack from behind can be evaded\n")
    public float attribute_evasion_angle = 120.0f;
    @Comment(value="Allow evasion to work while the player is casting a spell")
    public boolean attribute_evasion_allowed_while_spell_casting = false;
    @Comment(value="Allow evasion to work while the player is using an item (e.g. eating, drawing a bow)")
    public boolean attribute_evasion_allowed_while_item_usage = false;
    @Comment(value="Relations determine which cases the effect of a player casted spell can effect a target.\n+----------------+-------+----------+----------+----------+--------+\n|                | ALLY  | FRIENDLY | NEUTRAL  | HOSTILE  | MIXED  |\n+----------------+-------+----------+----------+----------+--------+\n| DIRECT DAMAGE  | \ud83d\udeab    | \u2705       | \u2705       | \u2705       | \u2705    |\n| AREA DAMAGE    | \ud83d\udeab    | \ud83d\udeab       | \ud83d\udeab       | \u2705       | \u2705    |\n| DIRECT HEALING | \u2705    | \u2705       | \u2705       | \ud83d\udeab       | \u2705    |\n| AREA HEALING   | \u2705    | \u2705       | \ud83d\udeab       | \ud83d\udeab       | \u2705    |\n+----------------+-------+----------+----------+----------+--------+\n\nThe various relation related configs are being checked in the following order:\n- `player_relations`\n- `player_relation_to_passives`\n- `player_relation_to_hostiles`\n- `player_relation_to_other`\n(The first relation to be found for the target will be applied.)\n")
    public LinkedHashMap<String, EntityRelation> player_relations = new LinkedHashMap<String, EntityRelation>(){
        {
            this.put("minecraft:player", EntityRelation.FRIENDLY);
            this.put("minecraft:villager", EntityRelation.FRIENDLY);
            this.put("minecraft:allay", EntityRelation.FRIENDLY);
            this.put("minecraft:iron_golem", EntityRelation.FRIENDLY);
            this.put("guardvillagers:guard", EntityRelation.FRIENDLY);
            this.put("minecraft:cat", EntityRelation.FRIENDLY);
            this.put("minecraft:minecart", EntityRelation.FRIENDLY);
        }
    };
    public LinkedHashMap<String, EntityRelation> player_relation_tags = new LinkedHashMap<String, EntityRelation>(){};
    @Comment(value="Relation to self, and self owned pets (tamed entities), changing this to `FRIENDLY` will make it impossible to hit pets with weapons")
    public EntityRelation player_relation_to_owned_pets = EntityRelation.FRIENDLY;
    @Comment(value="Relation to teammates (entities in the same team), changing this to `FRIENDLY` will automatically disable friendly fire for all teams")
    public EntityRelation player_relation_to_teammates = EntityRelation.FRIENDLY;
    @Comment(value="Relation to unspecified entities those are instance of PassiveEntity(Yarn)")
    public EntityRelation player_relation_to_passives = EntityRelation.HOSTILE;
    @Comment(value="Relation to unspecified entities those are instance of HostileEntity(Yarn)")
    public EntityRelation player_relation_to_hostiles = EntityRelation.HOSTILE;
    @Comment(value="Fallback relation")
    public EntityRelation player_relation_to_other = EntityRelation.HOSTILE;
}

