/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import com.google.gson.Gson;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.render.FlyingSpellEntity;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.VectorHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellProjectile
extends class_1676
implements FlyingSpellEntity {
    public static class_1299<SpellProjectile> ENTITY_TYPE;
    private static Random random;
    public float range = 128.0f;
    private Spell.ProjectileData.Perks perks;
    private SpellHelper.ImpactContext context;
    public class_243 previousVelocity;
    private boolean hasCustomDimensions = false;
    private boolean skipTravel = false;
    private int followTicks = 0;
    protected Set<Integer> impactHistory = new HashSet<Integer>();
    private Gson gson = new Gson();
    private class_6880<Spell> spellEntry;
    private class_1297 followedTarget;
    private double distanceToFollow = 0.0;
    private class_1799 itemStackModel;
    private static String NBT_BEHAVIOUR;
    private static String NBT_SPELL_ID;
    private static String NBT_PERKS;
    private static String NBT_IMPACT_CONTEXT;
    private static String NBT_ITEM_MODEL_ID;
    private static final class_2940<String> TRACKER_SPELL_ID;
    private static final class_2940<String> TRACKER_BEHAVIOUR;
    private static final class_2940<Integer> TRACKER_TARGET_ID;
    private static final class_2940<String> TRACKER_ITEM_MODEL_ID;

    public SpellProjectile(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected SpellProjectile(class_1937 world, class_1309 owner) {
        super(ENTITY_TYPE, world);
        this.method_7432((class_1297)owner);
    }

    public SpellProjectile(class_1937 world, class_1309 caster, double x, double y, double z, Behaviour behaviour, class_6880<Spell> spellEntry, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks mutablePerks) {
        this(world, caster);
        this.method_5814(x, y, z);
        this.setBehaviour(behaviour);
        this.setSpell(spellEntry);
        this.perks = mutablePerks;
        this.context = context;
        Spell.ProjectileData projectileData = this.projectileData();
        if (projectileData.client_data != null && projectileData.client_data.model != null) {
            Spell.ProjectileModel model = projectileData.client_data.model;
            if (model.use_held_item) {
                this.setItemStackModel(caster.method_6047());
            }
        }
    }

    public Spell.ProjectileData.Perks mutablePerks() {
        return this.perks;
    }

    public Spell.ProjectileData projectileData() {
        class_6880<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return null;
        }
        Spell spell = (Spell)this.getSpellEntry().comp_349();
        Spell.Delivery release = spell.deliver;
        switch (release.type) {
            case PROJECTILE: {
                return release.projectile.projectile;
            }
            case METEOR: {
                return release.meteor.projectile;
            }
        }
        return null;
    }

    public void setVelocity(double x, double y, double z, float speed, float spread, float divergence) {
        double rotX = Math.toRadians(divergence * random.nextFloat(spread, 1.0f));
        double rotY = Math.toRadians(360.0f * random.nextFloat());
        class_243 vec3d = new class_243(x, y, z).method_1037((float)rotX).method_1024((float)rotY).method_1021((double)speed);
        this.method_18799(vec3d);
        double d = vec3d.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public class_4048 method_18377(class_4050 pose) {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.hitbox != null) {
            this.hasCustomDimensions = true;
            float width = data.hitbox.width;
            float height = data.hitbox.height;
            return class_4048.method_18384((float)width, (float)height);
        }
        return super.method_18377(pose);
    }

    public class_1297 getFollowedTarget() {
        class_1297 entityReference = null;
        if (this.method_37908().field_9236) {
            Integer id = (Integer)this.method_5841().method_12789(TRACKER_TARGET_ID);
            if (id != null && id > 0) {
                entityReference = this.method_37908().method_8469(id.intValue());
            }
        } else {
            entityReference = this.followedTarget;
        }
        if (entityReference != null && entityReference.method_5732() && entityReference.method_5805()) {
            return entityReference;
        }
        return entityReference;
    }

    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        boolean result = distance < (d0 *= 128.0) * d0;
        return result;
    }

    public void method_5773() {
        this.skipTravel = false;
        class_1297 entity = this.method_24921();
        Behaviour behaviour = this.getBehaviour();
        class_6880<Spell> spellEntry = this.getSpellEntry();
        if (!this.method_37908().field_9236) {
            if (spellEntry == null) {
                System.err.println("Spell Projectile safeguard termination, failed to resolve spell: " + String.valueOf(this.spellId()));
                this.method_5768();
                return;
            }
            switch (behaviour.ordinal()) {
                case 0: {
                    if (!(this.field_5994 >= this.range) && this.field_6012 <= 1200) break;
                    this.method_5768();
                    return;
                }
                case 1: {
                    if ((double)this.field_5994 >= (double)this.range * 0.98) {
                        this.finishFalling();
                        this.method_5768();
                        return;
                    }
                    if (this.field_6012 <= 1200) break;
                    this.method_5768();
                    return;
                }
            }
            if (this.field_5994 >= this.range || this.field_6012 > 1200) {
                this.method_5768();
                return;
            }
        }
        this.previousVelocity = new class_243(this.method_18798().field_1352, this.method_18798().field_1351, this.method_18798().field_1350);
        if (this.method_37908().field_9236 || (entity == null || !entity.method_31481()) && this.method_37908().method_22340(this.method_24515())) {
            super.method_5773();
            if (!this.method_37908().field_9236) {
                class_239 hitResult = class_1675.method_49997((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
                this.handleHitResult(hitResult, behaviour, spellEntry);
                if (hitResult.method_17783() == class_239.class_240.field_1333 && this.hasCustomDimensions) {
                    class_238 boundingBox = this.method_5829();
                    for (class_1297 areaTarget : this.method_37908().method_8333(entity, this.method_5829().method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0))) {
                        areaTarget.method_5829().method_994(boundingBox);
                        class_3966 areaHitResult = new class_3966(areaTarget);
                        this.handleHitResult((class_239)areaHitResult, behaviour, spellEntry);
                    }
                }
            }
            this.method_5852();
            if (!this.skipTravel) {
                Spell.ProjectileData data;
                this.followTarget();
                class_243 velocity = this.method_18798();
                double d = this.method_23317() + velocity.field_1352;
                double e = this.method_23318() + velocity.field_1351;
                double f = this.method_23321() + velocity.field_1350;
                class_1675.method_7484((class_1297)this, (float)0.2f);
                float g = this.getDrag();
                if (this.method_5799()) {
                    for (int i = 0; i < 4; ++i) {
                        float h = 0.25f;
                        this.method_37908().method_8406((class_2394)class_2398.field_11247, d - velocity.field_1352 * 0.25, e - velocity.field_1351 * 0.25, f - velocity.field_1350 * 0.25, velocity.field_1352, velocity.field_1351, velocity.field_1350);
                    }
                    g = 0.8f;
                }
                if ((data = this.projectileData()) != null) {
                    if (this.method_37908().field_9236) {
                        for (ParticleBatch travel_particles : data.client_data.travel_particles) {
                            ParticleHelper.play(this.method_37908(), (class_1297)this, this.method_36454(), this.method_36455(), travel_particles);
                        }
                    } else if (data.travel_sound != null && this.field_6012 % data.travel_sound_interval == 0) {
                        SoundHelper.playSound(this.method_37908(), (class_1297)this, data.travel_sound);
                    }
                }
                this.method_5814(d, e, f);
                this.field_5994 = (float)((double)this.field_5994 + velocity.method_1033());
            }
        } else {
            this.method_31472();
        }
    }

    private void handleHitResult(class_239 hitResult, Behaviour behaviour, class_6880<Spell> spellEntry) {
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            switch (behaviour.ordinal()) {
                case 0: {
                    boolean shouldCollideWithEntity = true;
                    if (hitResult.method_17783() == class_239.class_240.field_1331) {
                        class_1297 class_12972;
                        class_1297 target = ((class_3966)hitResult).method_17782();
                        Spell spell = (Spell)spellEntry.comp_349();
                        if (SpellEngineMod.config.projectiles_pass_thru_irrelevant_targets && spell != null && !spell.impacts.isEmpty() && !this.impactHistory.contains(target.method_5628()) && (class_12972 = this.method_24921()) instanceof class_1309) {
                            class_1309 owner = (class_1309)class_12972;
                            EnumSet<SpellTarget.Intent> intents = SpellHelper.impactIntents(spell);
                            boolean intentAllows = false;
                            for (SpellTarget.Intent intent : intents) {
                                intentAllows = intentAllows || EntityRelations.actionAllowed(SpellTarget.FocusMode.DIRECT, intent, owner, target);
                            }
                            shouldCollideWithEntity = intentAllows;
                        }
                    }
                    if (shouldCollideWithEntity) {
                        this.method_7488(hitResult);
                        break;
                    }
                    this.setFollowedTarget(null);
                    break;
                }
                case 1: {
                    TwoWayCollisionChecker.CollisionResult result;
                    class_1297 target;
                    Function<class_1297, TwoWayCollisionChecker.CollisionResult> reverse;
                    if (hitResult.method_17783() != class_239.class_240.field_1331 || (reverse = ((TwoWayCollisionChecker)(target = ((class_3966)hitResult).method_17782())).getReverseCollisionChecker()) == null || (result = reverse.apply((class_1297)this)) != TwoWayCollisionChecker.CollisionResult.COLLIDE) break;
                    this.finishFalling();
                }
            }
        }
    }

    private void finishFalling() {
        class_1297 owner = this.method_24921();
        if (owner == null || owner.method_31481()) {
            return;
        }
        if (owner instanceof class_1309) {
            class_1309 livingEntity = (class_1309)owner;
            SpellHelper.fallImpact(livingEntity, (class_1297)this, this.getSpellEntry(), this.context.position(this.method_19538()));
        }
    }

    private void followTarget() {
        class_1297 target = this.getFollowedTarget();
        Spell.ProjectileData data = this.projectileData();
        if (data == null) {
            return;
        }
        float homing_angle = this.projectileData().homing_angle;
        if (this.projectileData().homing_angles != null && this.followTicks < this.projectileData().homing_angles.length) {
            homing_angle = this.projectileData().homing_angles[this.followTicks];
        }
        if (target != null && homing_angle > 0.0f) {
            if (data.homing_after_relative_distance > 0.0f || data.homing_after_absolute_distance > 0.0f) {
                boolean shouldFollow;
                boolean bl = shouldFollow = (double)this.field_5994 >= this.distanceToFollow * (double)data.homing_after_relative_distance || this.field_5994 >= data.homing_after_absolute_distance;
                if (!shouldFollow) {
                    return;
                }
            }
            class_243 distanceVector = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0).method_1020(this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
            class_243 newVelocity = VectorHelper.rotateTowards(this.method_18798(), distanceVector, homing_angle);
            if (newVelocity.method_1027() > 0.0) {
                this.method_18799(newVelocity);
                ++this.followTicks;
            }
        }
    }

    protected float getDrag() {
        return 0.95f;
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 class_12972;
        class_1297 target;
        if (!this.method_37908().field_9236 && (target = entityHitResult.method_17782()) != null && !this.impactHistory.contains(target.method_5628()) && this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1309) {
            class_1309 caster = (class_1309)class_12972;
            this.setFollowedTarget(null);
            SpellHelper.ImpactContext context = this.context;
            if (context == null) {
                context = new SpellHelper.ImpactContext();
                Spell spell = (Spell)this.getSpellEntry().comp_349();
                class_1297 class_12973 = this.method_24921();
                if (class_12973 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12973;
                    if (spell != null) {
                        context = context.power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player));
                    }
                }
            }
            if (context.power() == null) {
                this.method_5768();
                return;
            }
            class_243 prevProjectilePos = new class_243(this.field_6014, this.field_6036, this.field_5969);
            class_243 hitVector = entityHitResult.method_17784().method_1020(prevProjectilePos).method_1029().method_1021((double)(this.method_17681() * 0.5f));
            class_243 hitPosition = entityHitResult.method_17784().method_1020(hitVector);
            boolean performed = SpellHelper.projectileImpact(caster, (class_1297)this, target, this.getSpellEntry(), context.position(hitPosition));
            if (performed) {
                this.chainReactionFrom(target);
                if (this.ricochetFrom(target, caster)) {
                    return;
                }
                if (this.pierced(target)) {
                    return;
                }
                this.method_5768();
            }
        }
    }

    protected boolean ricochetFrom(class_1297 target, class_1309 caster) {
        if (this.perks == null || this.perks.ricochet <= 0) {
            return false;
        }
        this.impactHistory.add(target.method_5628());
        class_238 box = this.method_5829().method_1009((double)this.perks.ricochet_range, (double)this.perks.ricochet_range, (double)this.perks.ricochet_range);
        Spell spell = (Spell)this.getSpellEntry().comp_349();
        EnumSet<SpellTarget.Intent> intents = SpellHelper.impactIntents(spell);
        Predicate<class_1297> intentMatches = entity -> {
            boolean intentAllows = false;
            for (SpellTarget.Intent intent : intents) {
                intentAllows = intentAllows || EntityRelations.actionAllowed(SpellTarget.FocusMode.AREA, intent, caster, entity);
            }
            return intentAllows;
        };
        List otherTargets = this.method_37908().method_8333((class_1297)this, box, entity -> entity.method_5732() && entity instanceof class_1309 && !this.impactHistory.contains(entity.method_5628()) && intentMatches.test((class_1297)entity) && !entity.method_19538().equals((Object)target.method_19538()));
        if (otherTargets.isEmpty()) {
            this.setFollowedTarget(null);
            return false;
        }
        otherTargets.sort(Comparator.comparingDouble(o -> o.method_5858(target)));
        class_1297 newTarget = (class_1297)otherTargets.get(0);
        this.method_33574(target.method_19538().method_1031(0.0, (double)(target.method_17682() * 0.5f), 0.0));
        this.setFollowedTarget(newTarget);
        class_243 distanceVector = newTarget.method_19538().method_1031(0.0, (double)(newTarget.method_17682() / 2.0f), 0.0).method_1020(this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
        class_243 newVelocity = distanceVector.method_1029().method_1021(this.method_18798().method_1033());
        this.method_18799(newVelocity);
        this.field_6007 = true;
        --this.perks.ricochet;
        if (this.perks.bounce_ricochet_sync) {
            --this.perks.bounce;
        }
        return true;
    }

    private boolean pierced(class_1297 target) {
        if (this.perks == null || this.perks.pierce <= 0) {
            return false;
        }
        this.impactHistory.add(target.method_5628());
        this.setFollowedTarget(null);
        --this.perks.pierce;
        double tiny = 0.01 * (double)(-1 * (this.perks.pierce % 2));
        this.method_18799(this.method_18798().method_1021(1.0 + tiny));
        this.field_6007 = true;
        return true;
    }

    private boolean bounceFrom(class_3965 blockHitResult) {
        if (this.perks == null || this.perks.bounce <= 0) {
            return false;
        }
        class_243 previousPosition = this.method_19538();
        class_243 previousDirection = this.method_18798();
        class_243 impactPosition = blockHitResult.method_17784();
        class_2350 impactSide = blockHitResult.method_17780();
        double speed = this.method_18798().method_1033();
        class_243 surfaceNormal = this.getSurfaceNormal(impactSide);
        class_243 newDirection = this.calculateBounceVector(previousDirection, surfaceNormal);
        double remainingDistance = previousDirection.method_1033() - impactPosition.method_1020(previousPosition).method_1033();
        class_243 finalPosition = impactPosition.method_1019(newDirection.method_1029().method_1021(remainingDistance));
        this.method_23327(finalPosition.method_10216(), finalPosition.method_10214(), finalPosition.method_10215());
        this.method_18799(newDirection.method_1021(speed));
        class_1675.method_7484((class_1297)this, (float)0.2f);
        --this.perks.bounce;
        if (this.perks.bounce_ricochet_sync) {
            --this.perks.ricochet;
        }
        this.field_6007 = true;
        this.skipTravel = true;
        return true;
    }

    public class_243 calculateBounceVector(class_243 previousDirection, class_243 normal) {
        return previousDirection.method_1020(normal.method_1021(2.0 * previousDirection.method_1026(normal)));
    }

    public class_243 getSurfaceNormal(class_2350 blockSide) {
        return switch (blockSide) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> new class_243(0.0, -1.0, 0.0);
            case class_2350.field_11036 -> new class_243(0.0, 1.0, 0.0);
            case class_2350.field_11043 -> new class_243(0.0, 0.0, -1.0);
            case class_2350.field_11035 -> new class_243(0.0, 0.0, 1.0);
            case class_2350.field_11039 -> new class_243(-1.0, 0.0, 0.0);
            case class_2350.field_11034 -> new class_243(1.0, 0.0, 0.0);
        };
    }

    private void chainReactionFrom(class_1297 target) {
        if (this.perks == null || this.perks.chain_reaction_size <= 0 || this.perks.chain_reaction_triggers <= 0 || this.impactHistory.contains(target)) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        class_6880<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return;
        }
        class_243 position = this.method_19538();
        int spawnCount = this.perks.chain_reaction_size;
        class_243 launchVector = new class_243(1.0, 0.0, 0.0).method_1021(this.method_18798().method_1033());
        int launchAngle = 360 / spawnCount;
        float launchAngleOffset = random.nextFloat() * (float)launchAngle;
        this.impactHistory.add(target.method_5628());
        --this.perks.chain_reaction_triggers;
        this.perks.chain_reaction_size += this.perks.chain_reaction_increment;
        for (int i = 0; i < spawnCount; ++i) {
            SpellProjectile projectile = new SpellProjectile(this.method_37908(), (class_1309)this.method_24921(), position.method_10216(), position.method_10214(), position.method_10215(), this.getBehaviour(), spellEntry, this.context, this.perks.copy());
            float angle = (float)(launchAngle * i) + launchAngleOffset;
            projectile.method_18799(launchVector.method_1024((float)Math.toRadians(angle)));
            projectile.range = this.range;
            class_1675.method_7484((class_1297)projectile, (float)0.2f);
            projectile.impactHistory = new HashSet<Integer>(this.impactHistory);
            this.method_37908().method_8649((class_1297)projectile);
        }
    }

    public SpellHelper.ImpactContext getImpactContext() {
        return this.context;
    }

    public class_1799 getItemStackModel() {
        return this.itemStackModel;
    }

    @Override
    public Spell.ProjectileModel renderData() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.client_data != null) {
            return data.client_data.model;
        }
        return null;
    }

    public class_1799 method_7495() {
        Spell.ProjectileData data = this.projectileData();
        if (data != null && data.client_data != null && data.client_data.model != null) {
            return ((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)data.client_data.model.model_id))).method_7854();
        }
        return class_1799.field_8037;
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_1297 class_12972;
        super.method_24920(blockHitResult);
        if (this.bounceFrom(blockHitResult)) {
            return;
        }
        if (this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1309) {
            class_1309 caster = (class_1309)class_12972;
            class_243 hitPosition = blockHitResult.method_17784();
            boolean bl = SpellHelper.projectileImpact(caster, (class_1297)this, null, this.getSpellEntry(), this.context.position(hitPosition));
        }
        this.method_5768();
    }

    public void setBehaviour(Behaviour behaviour) {
        this.method_5841().method_12778(TRACKER_BEHAVIOUR, (Object)behaviour.toString());
    }

    public Behaviour getBehaviour() {
        String string = (String)this.method_5841().method_12789(TRACKER_BEHAVIOUR);
        if (string == null || string.isEmpty()) {
            return Behaviour.FLY;
        }
        return Behaviour.valueOf(string);
    }

    public void setSpell(class_6880<Spell> entry) {
        this.spellEntry = entry;
        if (!this.method_37908().field_9236) {
            this.method_5841().method_12778(TRACKER_SPELL_ID, (Object)this.spellId().toString());
        }
        this.method_18382();
    }

    @Nullable
    public class_6880<Spell> getSpellEntry() {
        return this.spellEntry;
    }

    private class_2960 spellId() {
        if (this.spellEntry != null) {
            return ((class_5321)this.spellEntry.method_40230().get()).method_29177();
        }
        return null;
    }

    public void setFollowedTarget(class_1297 target) {
        this.followedTarget = target;
        this.distanceToFollow = target != null ? (double)target.method_5739((class_1297)this) : 0.0;
        int id = -1;
        if (!this.method_37908().field_9236) {
            if (target != null) {
                id = target.method_5628();
            }
            this.method_5841().method_12778(TRACKER_TARGET_ID, (Object)id);
        }
    }

    public void setItemStackModel(class_1799 itemStack) {
        class_2960 modelId = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        this.method_5841().method_12778(TRACKER_ITEM_MODEL_ID, (Object)modelId.toString());
    }

    private void updateItemModel(String idString) {
        if (idString != null && !idString.isEmpty()) {
            class_2960 id = class_2960.method_60654((String)((String)this.method_5841().method_12789(TRACKER_ITEM_MODEL_ID)));
            this.itemStackModel = ((class_1792)class_7923.field_41178.method_10223(id)).method_7854();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(NBT_BEHAVIOUR, this.getBehaviour().toString());
        if (this.spellId() != null) {
            nbt.method_10582(NBT_SPELL_ID, this.spellId().toString());
        }
        nbt.method_10582(NBT_IMPACT_CONTEXT, this.gson.toJson((Object)this.context));
        nbt.method_10582(NBT_PERKS, this.gson.toJson((Object)this.perks));
        String itemModelId = (String)this.method_5841().method_12789(TRACKER_ITEM_MODEL_ID);
        if (!itemModelId.isEmpty()) {
            nbt.method_10582(NBT_ITEM_MODEL_ID, itemModelId);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573(NBT_SPELL_ID, 8)) {
            try {
                Behaviour behaviour = Behaviour.valueOf(nbt.method_10558(NBT_BEHAVIOUR));
                this.setBehaviour(behaviour);
                class_2960 spellId = class_2960.method_60654((String)nbt.method_10558(NBT_SPELL_ID));
                this.setSpell((class_6880<Spell>)((class_6880)SpellRegistry.from(this.method_37908()).method_55841(spellId).orElse(null)));
                this.context = (SpellHelper.ImpactContext)this.gson.fromJson(nbt.method_10558(NBT_IMPACT_CONTEXT), SpellHelper.ImpactContext.class);
                this.perks = (Spell.ProjectileData.Perks)this.gson.fromJson(nbt.method_10558(NBT_PERKS), Spell.ProjectileData.Perks.class);
                if (nbt.method_10573(NBT_ITEM_MODEL_ID, 8)) {
                    this.updateItemModel(nbt.method_10558(NBT_ITEM_MODEL_ID));
                }
            }
            catch (Exception e) {
                System.err.println("SpellProjectile - Failed to read spell data from NBT " + e.getMessage());
            }
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(TRACKER_SPELL_ID, (Object)"");
        builder.method_56912(TRACKER_BEHAVIOUR, (Object)Behaviour.FLY.toString());
        builder.method_56912(TRACKER_TARGET_ID, (Object)0);
        builder.method_56912(TRACKER_ITEM_MODEL_ID, (Object)"");
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (this.method_37908().field_9236) {
            if (data.equals(TRACKER_SPELL_ID)) {
                String spellId = (String)this.method_5841().method_12789(TRACKER_SPELL_ID);
                class_6880.class_6883 spellEntry = SpellRegistry.from(this.method_37908()).method_55841(class_2960.method_60654((String)spellId)).orElse(null);
                this.setSpell((class_6880<Spell>)spellEntry);
            }
            if (data.equals(TRACKER_ITEM_MODEL_ID)) {
                this.updateItemModel((String)this.method_5841().method_12789(TRACKER_ITEM_MODEL_ID));
            }
            if (data.equals(TRACKER_TARGET_ID)) {
                Integer id = (Integer)this.method_5841().method_12789(TRACKER_TARGET_ID);
                class_1297 target = id > 0 ? this.method_37908().method_8469(id.intValue()) : null;
                this.setFollowedTarget(target);
            }
        }
    }

    static {
        random = new Random();
        NBT_BEHAVIOUR = "Behaviour";
        NBT_SPELL_ID = "Spell.ID";
        NBT_PERKS = "Perks";
        NBT_IMPACT_CONTEXT = "Impact.Context";
        NBT_ITEM_MODEL_ID = "Item.Model.ID";
        TRACKER_SPELL_ID = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13326);
        TRACKER_BEHAVIOUR = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13326);
        TRACKER_TARGET_ID = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13327);
        TRACKER_ITEM_MODEL_ID = class_2945.method_12791(SpellProjectile.class, (class_2941)class_2943.field_13326);
    }

    public static enum Behaviour {
        FLY,
        FALL;

    }
}

