/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen;

import com.shynieke.geore.Reference;
import com.shynieke.geore.block.BuddingGeoreBlock;
import com.shynieke.geore.datagen.GeOreBiomeModifiers;
import com.shynieke.geore.datagen.builder.TagSmeltingRecipeBuilder;
import com.shynieke.geore.features.GeOreConfiguredFeatures;
import com.shynieke.geore.features.GeOrePlacedFeatures;
import com.shynieke.geore.item.GeoreSpyglassItem;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Cloner;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GeOreDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput, lookupProvider));
            GeoreBlockTags blockTagsProvider = new GeoreBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.addProvider(event.includeServer(), (DataProvider)new GeoreItemTags(packOutput, lookupProvider, blockTagsProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(GeOreDatagen::getProvider), Set.of("geore")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, helper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, GeOreConfiguredFeatures::bootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, GeOrePlacedFeatures::bootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, GeOreBiomeModifiers::bootstrap);
        registryBuilder.add(Registries.BIOME, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(p_311524_ -> p_311524_.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GeOreBlockTables::new, LootContextParamSets.BLOCK)), lookupProvider);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
            super.validate(writableregistry, validationcontext, problemreporter$collector);
        }

        public static class GeOreBlockTables
        extends BlockLootSubProvider {
            private final HolderLookup.RegistryLookup<Enchantment> enchantmentLookup;

            protected GeOreBlockTables(HolderLookup.Provider lookupProvider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
                this.enchantmentLookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
            }

            protected void generate() {
                for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
                    if (reg.getName().equals("ancient_debris")) {
                        this.addAncientDebrisGeOreTables();
                        continue;
                    }
                    this.addGeOreTables(reg);
                }
            }

            protected void addGeOreTables(GeOreBlockReg blockReg) {
                this.dropSelf((Block)blockReg.getBlock().get());
                this.add((Block)blockReg.getCluster().get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
                this.dropWhenSilkTouch((Block)blockReg.getSmallBud().get());
                this.dropWhenSilkTouch((Block)blockReg.getMediumBud().get());
                this.dropWhenSilkTouch((Block)blockReg.getLargeBud().get());
                this.add((Block)blockReg.getBudding().get(), GeOreBlockTables.noDrop());
            }

            private void addAncientDebrisGeOreTables() {
                GeOreBlockReg blockReg = GeOreRegistry.ANCIENT_DEBRIS_GEORE;
                this.dropSelf((Block)blockReg.getBlock().get());
                this.add((Block)blockReg.getCluster().get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)14.0f)))));
                this.dropWhenSilkTouch((Block)blockReg.getSmallBud().get());
                this.dropWhenSilkTouch((Block)blockReg.getMediumBud().get());
                this.dropWhenSilkTouch((Block)blockReg.getLargeBud().get());
                this.add((Block)blockReg.getBudding().get(), GeOreBlockTables.noDrop());
            }

            protected Iterable<Block> getKnownBlocks() {
                return GeOreRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput output, HolderLookup.Provider holderLookup) {
            this.generateRecipes(GeOreRegistry.COAL_GEORE, output);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.TORCH, (int)2).pattern("X").pattern("#").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)GeOreRegistry.COAL_GEORE.getShard().get()).unlockedBy("has_coal_geore_shard", Recipes.has((ItemLike)((ItemLike)GeOreRegistry.COAL_GEORE.getShard().get()))).save(output, "geore:torch_from_coal_shard");
            this.generateRecipe(GeOreRegistry.COPPER_GEORE, 0.7f, (ItemLike)Items.COPPER_INGOT, output);
            this.generateRecipe(GeOreRegistry.DIAMOND_GEORE, 1.0f, (ItemLike)Items.DIAMOND, output);
            this.generateRecipe(GeOreRegistry.EMERALD_GEORE, 1.0f, (ItemLike)Items.EMERALD, output);
            this.generateRecipe(GeOreRegistry.GOLD_GEORE, 1.0f, (ItemLike)Items.GOLD_INGOT, output);
            this.generateRecipe(GeOreRegistry.IRON_GEORE, 0.7f, (ItemLike)Items.IRON_INGOT, output);
            this.generateRecipe(GeOreRegistry.LAPIS_GEORE, 0.2f, (ItemLike)Items.LAPIS_LAZULI, output);
            this.generateRecipe(GeOreRegistry.QUARTZ_GEORE, 0.2f, (ItemLike)Items.QUARTZ, output);
            this.generateRecipe(GeOreRegistry.REDSTONE_GEORE, 0.7f, (ItemLike)Items.REDSTONE, output);
            this.generateRecipes(GeOreRegistry.ANCIENT_DEBRIS_GEORE, output);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ANCIENT_DEBRIS).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)GeOreRegistry.ANCIENT_DEBRIS_GEORE.getShard().get()).unlockedBy("has_ancient_debris_geore_shard", Recipes.has((ItemLike)((ItemLike)GeOreRegistry.ANCIENT_DEBRIS_GEORE.getShard().get()))).save(output, "geore:ancient_debris_from_ancient_debris_shard");
            this.generateTagRecipe(GeOreRegistry.RUBY_GEORE, 0.7f, this.getCommonTag("gems/ruby"), output);
            this.generateTagRecipe(GeOreRegistry.SAPPHIRE_GEORE, 0.7f, this.getCommonTag("gems/sapphire"), output);
            this.generateTagRecipe(GeOreRegistry.TOPAZ_GEORE, 0.7f, this.getCommonTag("gems/topaz"), output);
            this.generateTagRecipe(GeOreRegistry.ZINC_GEORE, 0.7f, this.getCommonTag("ingots/zinc"), output);
            this.generateTagRecipe(GeOreRegistry.URANINITE_GEORE, 0.7f, this.getCommonTag("raw_materials/uraninite"), output);
            this.generateTagRecipe(GeOreRegistry.BLACK_QUARTZ_GEORE, 0.7f, this.getCommonTag("gems/black_quartz"), output);
            this.generateTagRecipe(GeOreRegistry.MONAZITE_GEORE, 0.7f, this.getCommonTag("dusts/monazite"), output);
            this.generateTagRecipe(GeOreRegistry.ALUMINUM_GEORE, 0.7f, this.getCommonTag("ingots/aluminum"), output);
            this.generateTagRecipe(GeOreRegistry.LEAD_GEORE, 0.7f, this.getCommonTag("ingots/lead"), output);
            this.generateTagRecipe(GeOreRegistry.NICKEL_GEORE, 0.7f, this.getCommonTag("ingots/nickel"), output);
            this.generateTagRecipe(GeOreRegistry.OSMIUM_GEORE, 0.7f, this.getCommonTag("ingots/osmium"), output);
            this.generateTagRecipe(GeOreRegistry.PLATINUM_GEORE, 0.7f, this.getCommonTag("ingots/platinum"), output);
            this.generateTagRecipe(GeOreRegistry.SILVER_GEORE, 0.7f, this.getCommonTag("ingots/silver"), output);
            this.generateTagRecipe(GeOreRegistry.TIN_GEORE, 0.7f, this.getCommonTag("ingots/tin"), output);
            this.generateTagRecipe(GeOreRegistry.TUNGSTEN_GEORE, 0.7f, this.getCommonTag("ingots/tungsten"), output);
            this.generateTagRecipe(GeOreRegistry.URANIUM_GEORE, 0.7f, this.getCommonTag("ingots/uranium"), output);
        }

        private void generateRecipe(GeOreBlockReg reg, float xp, ItemLike result, RecipeOutput output) {
            this.generateRecipes(reg, output);
            this.smeltToOre(reg, xp, result, output);
        }

        private void generateTagRecipe(GeOreBlockReg reg, float xp, TagKey<Item> result, RecipeOutput output) {
            this.generateRecipes(reg, output);
            this.smeltToOre(reg, xp, reg.getName(), result, output);
        }

        private TagKey<Item> getCommonTag(String path) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
        }

        private void generateRecipes(GeOreBlockReg blockReg, RecipeOutput output) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockReg.getBlock().get())).define(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).pattern("SS").pattern("SS").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)blockReg.getSpyglass().get())).define(Character.valueOf('#'), (ItemLike)blockReg.getShard().get()).define(Character.valueOf('X'), (ItemLike)Items.COPPER_INGOT).pattern(" # ").pattern(" X ").pattern(" X ").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
        }

        private void smeltToOre(GeOreBlockReg blockReg, float xp, ItemLike item, RecipeOutput output) {
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output, Reference.modLoc(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath() + "_from_smelting_" + blockReg.getShard().getId().getPath()));
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output, Reference.modLoc(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath() + "_from_blasting_" + blockReg.getShard().getId().getPath()));
        }

        private void smeltToOre(GeOreBlockReg blockReg, float xp, String type, TagKey<Item> oreTag, RecipeOutput output) {
            RecipeOutput tagOutput = output.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(oreTag.location()))});
            Ingredient outputIngredient = Ingredient.of(oreTag);
            TagSmeltingRecipeBuilder.smelting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), RecipeCategory.MISC, outputIngredient, xp, 200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(tagOutput, Reference.modLoc(type + "_from_smelting_" + blockReg.getShard().getId().getPath()));
            TagSmeltingRecipeBuilder.blasting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), RecipeCategory.MISC, outputIngredient, xp, 100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", Recipes.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(tagOutput, Reference.modLoc(type + "_from_blasting_" + blockReg.getShard().getId().getPath()));
        }
    }

    public static class GeoreBlockTags
    extends BlockTagsProvider {
        public GeoreBlockTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, "geore", existingFileHelper);
        }

        private static TagKey<Block> modTag(String name) {
            return BlockTags.create((ResourceLocation)Reference.modLoc(name));
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(Tags.Blocks.RELOCATION_NOT_SUPPORTED).add((Object)((Block)GeOreRegistry.COAL_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.COPPER_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.DIAMOND_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.EMERALD_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.GOLD_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.IRON_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.LAPIS_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.QUARTZ_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.REDSTONE_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.RUBY_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.SAPPHIRE_GEORE.getBudding().get())).add((Object)((Block)GeOreRegistry.TOPAZ_GEORE.getBudding().get()));
            for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
                this.addMineable(reg);
                this.addCrystalSounds(reg);
                this.addGeore(reg);
            }
        }

        private void addMineable(GeOreBlockReg blockReg) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)blockReg.getCluster().get())).add((Object)((Block)blockReg.getSmallBud().get())).add((Object)((Block)blockReg.getMediumBud().get())).add((Object)((Block)blockReg.getLargeBud().get())).add((Object)((Block)blockReg.getBlock().get())).add((Object)((Block)blockReg.getBudding().get()));
        }

        private void addCrystalSounds(GeOreBlockReg blockReg) {
            this.tag(BlockTags.CRYSTAL_SOUND_BLOCKS).add((Object)((Block)blockReg.getBlock().get())).add((Object)((Block)blockReg.getBudding().get()));
        }

        private void addGeore(GeOreBlockReg blockReg) {
            TagKey<Block> budsTag = GeoreBlockTags.modTag("buds/geore_" + blockReg.getName());
            this.tag(budsTag).add((Object[])new Block[]{(Block)blockReg.getSmallBud().get(), (Block)blockReg.getMediumBud().get(), (Block)blockReg.getLargeBud().get()});
            this.tag(Tags.Blocks.BUDS).addTag(budsTag);
            TagKey<Block> clustersTag = GeoreBlockTags.modTag("clusters/geore_" + blockReg.getName());
            this.tag(clustersTag).add((Object)((Block)blockReg.getCluster().get()));
            this.tag(Tags.Blocks.CLUSTERS).addTag(clustersTag);
            this.tag(Tags.Blocks.BUDDING_BLOCKS).add((Object)((Block)blockReg.getBudding().get()));
            TagKey<Block> blockTag = GeoreBlockTags.modTag("storage_blocks/geore_" + blockReg.getName());
            this.tag(blockTag).add((Object)((Block)blockReg.getBlock().get()));
        }
    }

    public static class GeoreItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> GEORE_BUDDING = GeoreItemTags.modTag("geore_budding");
        public static final TagKey<Item> GEORE_CLUSTERS = GeoreItemTags.modTag("geore_clusters");
        public static final TagKey<Item> GEORE_SMALL_BUDS = GeoreItemTags.modTag("geore_small_buds");
        public static final TagKey<Item> GEORE_MEDIUM_BUDS = GeoreItemTags.modTag("geore_medium_buds");
        public static final TagKey<Item> GEORE_LARGE_BUDS = GeoreItemTags.modTag("geore_large_buds");
        public static final TagKey<Item> GEORE_SHARDS = GeoreItemTags.modTag("geore_shards");
        public static final TagKey<Item> GEORE_BLOCKS = GeoreItemTags.modTag("geore_blocks");

        public GeoreItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), "geore", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ItemTags.COALS).add((Object)((Item)GeOreRegistry.COAL_GEORE.getShard().get()));
            for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
                this.addGeore(reg);
                this.addStorage(reg);
            }
            this.tag(Tags.Items.BUDDING_BLOCKS).addTag(GEORE_BUDDING);
            this.tag(Tags.Items.BUDS).addTags(new TagKey[]{GEORE_SMALL_BUDS, GEORE_MEDIUM_BUDS, GEORE_LARGE_BUDS});
            this.tag(Tags.Items.CLUSTERS).addTag(GEORE_CLUSTERS);
        }

        private void addStorage(GeOreBlockReg blockReg) {
            TagKey<Item> itemTag = GeoreItemTags.modTag("storage_blocks/geore_" + blockReg.getName());
            this.tag(itemTag).add((Object)((AmethystBlock)blockReg.getBlock().get()).asItem());
        }

        private void addGeore(GeOreBlockReg blockReg) {
            this.tag(GEORE_BUDDING).add((Object)((BuddingGeoreBlock)((Object)blockReg.getBudding().get())).asItem());
            TagKey<Item> smallBudsTag = GeoreItemTags.modTag("geore_small_buds/" + blockReg.getName());
            this.tag(GEORE_SMALL_BUDS).addTag(smallBudsTag);
            this.tag(smallBudsTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
            TagKey<Item> mediumBudsTag = GeoreItemTags.modTag("geore_medium_buds/" + blockReg.getName());
            this.tag(GEORE_MEDIUM_BUDS).addTag(mediumBudsTag);
            this.tag(mediumBudsTag).add((Object)((AmethystClusterBlock)blockReg.getSmallBud().get()).asItem());
            TagKey<Item> largeBudsTag = GeoreItemTags.modTag("geore_large_buds/" + blockReg.getName());
            this.tag(GEORE_LARGE_BUDS).addTag(largeBudsTag);
            this.tag(largeBudsTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
            TagKey<Item> clusterTag = GeoreItemTags.modTag("geore_clusters/" + blockReg.getName());
            this.tag(GEORE_CLUSTERS).addTag(clusterTag);
            this.tag(clusterTag).add((Object)((AmethystClusterBlock)blockReg.getCluster().get()).asItem());
            TagKey<Item> shardTag = GeoreItemTags.modTag("geore_shards/" + blockReg.getName());
            this.tag(GEORE_SHARDS).addTag(shardTag);
            this.tag(shardTag).add((Object)((Item)blockReg.getShard().get()));
            TagKey<Item> blockTag = GeoreItemTags.modTag("geore_blocks/" + blockReg.getName());
            this.tag(GEORE_BLOCKS).addTag(blockTag);
            this.tag(blockTag).add((Object)((AmethystBlock)blockReg.getBlock().get()).asItem());
        }

        private static TagKey<Item> modTag(String name) {
            return ItemTags.create((ResourceLocation)Reference.modLoc(name));
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "geore", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.geore", "GeOre");
            this.generateLang("Coal", GeOreRegistry.COAL_GEORE);
            this.generateLang("Copper", GeOreRegistry.COPPER_GEORE);
            this.generateLang("Diamond", GeOreRegistry.DIAMOND_GEORE);
            this.generateLang("Emerald", GeOreRegistry.EMERALD_GEORE);
            this.generateLang("Gold", GeOreRegistry.GOLD_GEORE);
            this.generateLang("Iron", GeOreRegistry.IRON_GEORE);
            this.generateLang("Lapis", GeOreRegistry.LAPIS_GEORE);
            this.generateLang("Quartz", GeOreRegistry.QUARTZ_GEORE);
            this.generateLang("Redstone", GeOreRegistry.REDSTONE_GEORE);
            this.generateLang("Ancient Debris", GeOreRegistry.ANCIENT_DEBRIS_GEORE);
            this.generateLang("Ruby", GeOreRegistry.RUBY_GEORE);
            this.generateLang("Sapphire", GeOreRegistry.SAPPHIRE_GEORE);
            this.generateLang("Topaz", GeOreRegistry.TOPAZ_GEORE);
            this.generateLang("Zinc", GeOreRegistry.ZINC_GEORE);
            this.generateLang("Uraninite", GeOreRegistry.URANINITE_GEORE);
            this.generateLang("Black Quartz", GeOreRegistry.BLACK_QUARTZ_GEORE);
            this.generateLang("Monazite", GeOreRegistry.MONAZITE_GEORE);
            this.generateLang("Aluminum", GeOreRegistry.ALUMINUM_GEORE);
            this.generateLang("Lead", GeOreRegistry.LEAD_GEORE);
            this.generateLang("Nickel", GeOreRegistry.NICKEL_GEORE);
            this.generateLang("Osmium", GeOreRegistry.OSMIUM_GEORE);
            this.generateLang("Platinum", GeOreRegistry.PLATINUM_GEORE);
            this.generateLang("Silver", GeOreRegistry.SILVER_GEORE);
            this.generateLang("Tin", GeOreRegistry.TIN_GEORE);
            this.generateLang("Tungsten", GeOreRegistry.TUNGSTEN_GEORE);
            this.generateLang("Uranium", GeOreRegistry.URANIUM_GEORE);
            this.add("geore.configuration.title", "Grimoire of Gaia Settings");
            this.addConfig("Client", "Client", "Client Settings");
            this.addConfig("spyglassIntensity", "Spyglass Intensity", "The intensity of the spyglass color overlay (0.5 = 50%) [Default: 0.5]");
            this.addConfig("General", "General", "General settings");
            this.addConfig("generateCoalGeore", "Generate Coal GeOre", "Generate Coal GeOre [Default: true]");
            this.addConfig("generateCopperGeore", "Generate Copper GeOre", "Generate Copper GeOre [Default: true]");
            this.addConfig("generateDiamondGeore", "Generate Diamond GeOre", "Generate Diamond GeOre [Default: true]");
            this.addConfig("generateEmeraldGeore", "Generate Emerald GeOre", "Generate Emerald GeOre [Default: true]");
            this.addConfig("generateGoldGeore", "Generate Gold GeOre", "Generate Gold GeOre [Default: true]");
            this.addConfig("generateIronGeore", "Generate Iron GeOre", "Generate Iron GeOre [Default: true]");
            this.addConfig("generateLapisGeore", "Generate Lapis GeOre", "Generate Lapis GeOre [Default: true]");
            this.addConfig("generateQuartzGeore", "Generate Quartz GeOre", "Generate Quartz GeOre [Default: true]");
            this.addConfig("generateQuartzInNetherGeore", "Generate Quartz In Nether GeOre", "Generate Quartz In Nether GeOre [Default: true]");
            this.addConfig("generateRedstoneGeore", "Generate Redstone GeOre", "Generate Redstone GeOre [Default: true]");
            this.addConfig("generateBuddingAncientDebris", "Generate Budding Ancient Debris", "Generate Budding Ancient Debris [Default: true]");
            this.addConfig("disablePistonPushForBuddingGeOre", "Disable Piston Push For Budding GeOre", "Disable piston push for budding GeOre (Overrides the vanilla behavior of breaking the block upon being pushed) [Default: false]");
            this.addConfig("ModdedGeneration", "Modded Generation", "Modded Generation Settings");
            this.addConfig("generateRubyGeore", "Generate Ruby GeOre", "Generate Ruby GeOre [Default: false]");
            this.addConfig("generateSapphireGeore", "Generate Sapphire GeOre", "Generate Sapphire GeOre [Default: false]");
            this.addConfig("generateTopazGeore", "Generate Topaz GeOre", "Generate Topaz GeOre [Default: false]");
            this.addConfig("generateZincGeore", "Generate Zinc GeOre", "Generate Zinc GeOre [Default: false]");
            this.addConfig("generateUraniniteGeore", "Generate Uraninite GeOre", "Generate Uraninite GeOre [Default: false]");
            this.addConfig("generateBlackQuartzGeore", "Generate Black Quartz GeOre", "Generate Black Quartz GeOre [Default: false]");
            this.addConfig("generateMonaziteGeore", "Generate Monazite GeOre", "Generate Monazite GeOre [Default: false]");
            this.addConfig("generateAluminumGeore", "Generate Aluminum GeOre", "Generate Aluminum GeOre [Default: false]");
            this.addConfig("generateLeadGeore", "Generate Lead GeOre", "Generate Lead GeOre [Default: false]");
            this.addConfig("generateNickelGeore", "Generate Nickel GeOre", "Generate Nickel GeOre [Default: false]");
            this.addConfig("generateOsmiumGeore", "Generate Osmium GeOre", "Generate Osmium GeOre [Default: false]");
            this.addConfig("generatePlatinumGeore", "Generate Platinum GeOre", "Generate Platinum GeOre [Default: false]");
            this.addConfig("generateSilverGeore", "Generate Silver GeOre", "Generate Silver GeOre [Default: false]");
            this.addConfig("generateTinGeore", "Generate Tin GeOre", "Generate Tin GeOre [Default: false]");
            this.addConfig("generateTungstenGeore", "Generate Tungsten GeOre", "Generate Tungsten GeOre [Default: false]");
            this.addConfig("generateUraniumGeore", "Generate Uranium GeOre", "Generate Uranium GeOre [Default: false]");
        }

        public void generateLang(String name, GeOreBlockReg blockReg) {
            this.addBlock((Supplier)blockReg.getBlock(), "Block Of " + name + " Geore");
            this.addBlock((Supplier)blockReg.getBudding(), "Budding " + name + " Geore");
            this.addBlock((Supplier)blockReg.getSmallBud(), "Small " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getMediumBud(), "Medium " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getLargeBud(), "Large " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getCluster(), name + " Geore Cluster");
            this.addItem((Supplier)blockReg.getShard(), name + " Geore Shard");
            this.addItem((Supplier)blockReg.getSpyglass(), name + " Geore Spyglass");
        }

        private void addConfig(String path, String name, String description) {
            this.add("geore.configuration." + path, name);
            this.add("geore.configuration." + path + ".tooltip", description);
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "geore", helper);
        }

        protected void registerModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.ANCIENT_DEBRIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.ZINC_GEORE);
            this.generateGeoreModels(GeOreRegistry.URANINITE_GEORE);
            this.generateGeoreModels(GeOreRegistry.BLACK_QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.MONAZITE_GEORE);
            this.generateGeoreModels(GeOreRegistry.ALUMINUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.LEAD_GEORE);
            this.generateGeoreModels(GeOreRegistry.NICKEL_GEORE);
            this.generateGeoreModels(GeOreRegistry.OSMIUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.PLATINUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.SILVER_GEORE);
            this.generateGeoreModels(GeOreRegistry.TIN_GEORE);
            this.generateGeoreModels(GeOreRegistry.TUNGSTEN_GEORE);
            this.generateGeoreModels(GeOreRegistry.URANIUM_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.cubeAll(blockReg.getBlock().getId().getPath(), this.modLoc("block/" + blockReg.getBlock().getId().getPath()));
            this.cubeAll(blockReg.getBudding().getId().getPath(), this.modLoc("block/" + blockReg.getBudding().getId().getPath()));
            this.crossBlock((Block)blockReg.getCluster().get());
            this.crossBlock((Block)blockReg.getSmallBud().get());
            this.crossBlock((Block)blockReg.getMediumBud().get());
            this.crossBlock((Block)blockReg.getLargeBud().get());
        }

        private void crossBlock(Block block) {
            String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
            ((BlockModelBuilder)this.cross(path, this.modLoc("block/" + path))).renderType("cutout");
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "geore", helper);
        }

        protected void registerModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.ANCIENT_DEBRIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.ZINC_GEORE);
            this.generateGeoreModels(GeOreRegistry.URANINITE_GEORE);
            this.generateGeoreModels(GeOreRegistry.BLACK_QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.MONAZITE_GEORE);
            this.generateGeoreModels(GeOreRegistry.ALUMINUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.LEAD_GEORE);
            this.generateGeoreModels(GeOreRegistry.NICKEL_GEORE);
            this.generateGeoreModels(GeOreRegistry.OSMIUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.PLATINUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.SILVER_GEORE);
            this.generateGeoreModels(GeOreRegistry.TIN_GEORE);
            this.generateGeoreModels(GeOreRegistry.TUNGSTEN_GEORE);
            this.generateGeoreModels(GeOreRegistry.URANIUM_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.singleTexture(blockReg.getShard().getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", Reference.modLoc("item/" + blockReg.getShard().getId().getPath()));
            this.withExistingParent(blockReg.getBlock().getId().getPath(), Reference.modLoc("block/" + blockReg.getBlock().getId().getPath()));
            this.withExistingParent(blockReg.getBudding().getId().getPath(), Reference.modLoc("block/" + blockReg.getBudding().getId().getPath()));
            this.makeCluster(blockReg.getCluster());
            this.makeSmallBud(blockReg.getSmallBud());
            this.makeMediumBud(blockReg.getMediumBud());
            this.makeLargeBud(blockReg.getLargeBud());
            this.makeSpyglass(blockReg.getSpyglass());
        }

        private void makeSpyglass(DeferredHolder<Item, GeoreSpyglassItem> spyglass) {
            String path = spyglass.getId().getPath();
            ModelBuilder spyglass_gui = ((ItemModelBuilder)this.withExistingParent(path + "_gui", this.mcLoc("spyglass"))).texture("layer0", this.modLoc("item/" + path));
            ModelBuilder spyglass_hand = ((ItemModelBuilder)this.withExistingParent(path + "_in_hand", this.mcLoc("spyglass_in_hand"))).texture("spyglass", this.modLoc("item/" + path + "_model"));
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(path, "neoforge:item/default")).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_hand))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).end();
        }

        private void makeCluster(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.HEAD).translation(0.0f, 14.0f, -5.0f).end();
        }

        private void makeSmallBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(0.0f, 6.0f, 0.0f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIXED).translation(0.0f, 7.0f, 0.0f).end();
        }

        private void makeMediumBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.FIXED).translation(0.0f, 6.0f, 0.0f).end();
        }

        private void makeLargeBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
            String path = deferredHolder.getId().getPath();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.FIXED).translation(0.0f, 4.0f, 0.0f).end();
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "geore", helper);
        }

        protected void registerStatesAndModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.ANCIENT_DEBRIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.ZINC_GEORE);
            this.generateGeoreModels(GeOreRegistry.URANINITE_GEORE);
            this.generateGeoreModels(GeOreRegistry.BLACK_QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.MONAZITE_GEORE);
            this.generateGeoreModels(GeOreRegistry.ALUMINUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.LEAD_GEORE);
            this.generateGeoreModels(GeOreRegistry.NICKEL_GEORE);
            this.generateGeoreModels(GeOreRegistry.OSMIUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.PLATINUM_GEORE);
            this.generateGeoreModels(GeOreRegistry.SILVER_GEORE);
            this.generateGeoreModels(GeOreRegistry.TIN_GEORE);
            this.generateGeoreModels(GeOreRegistry.TUNGSTEN_GEORE);
            this.generateGeoreModels(GeOreRegistry.URANIUM_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.simpleBlock((Block)blockReg.getBlock().get());
            this.simpleBlock((Block)blockReg.getBudding().get());
            this.clusterBlock((Block)blockReg.getCluster().get());
            this.clusterBlock((Block)blockReg.getLargeBud().get());
            this.clusterBlock((Block)blockReg.getMediumBud().get());
            this.clusterBlock((Block)blockReg.getSmallBud().get());
        }

        private void clusterBlock(Block block) {
            ModelFile.ExistingModelFile clusterBlock = this.models().getExistingFile(this.modLoc("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath()));
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)clusterBlock).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)clusterBlock).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(270).addModel();
        }
    }
}

