/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.utils.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.codedsakura.blossom.lib.utils.CubicBezierCurve;
import java.lang.reflect.Type;

public class CubicBezierCurveSerializer
implements JsonDeserializer<CubicBezierCurve>,
JsonSerializer<CubicBezierCurve> {
    public CubicBezierCurve deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        double[] values = new double[4];
        JsonArray valuesElement = jsonObject.get("values").getAsJsonArray();
        if (valuesElement.size() != 4) {
            throw new JsonParseException("CubicBezierCurve values must be exactly 4 elements long!");
        }
        for (int i = 0; i < 4; ++i) {
            values[i] = valuesElement.get(i).getAsDouble();
        }
        double start = jsonObject.get("start").getAsDouble();
        double end = jsonObject.get("end").getAsDouble();
        int stepCount = jsonObject.get("stepCount").getAsInt();
        boolean enabled = jsonObject.get("enabled").getAsBoolean();
        return new CubicBezierCurve(values, start, end, stepCount, enabled);
    }

    public JsonElement serialize(CubicBezierCurve cubicBezierCurve, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("enabled", Boolean.valueOf(cubicBezierCurve.isEnabled()));
        JsonArray valuesList = new JsonArray();
        for (double point : cubicBezierCurve.getPoints()) {
            valuesList.add((Number)point);
        }
        jsonObject.add("values", (JsonElement)valuesList);
        jsonObject.addProperty("start", (Number)cubicBezierCurve.getStart());
        jsonObject.addProperty("end", (Number)cubicBezierCurve.getEnd());
        jsonObject.addProperty("stepCount", (Number)cubicBezierCurve.getStepCount());
        return jsonObject;
    }
}

