/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.codedsakura.blossom.lib.BlossomGlobals;
import dev.codedsakura.blossom.lib.config.ConfigManager;
import dev.codedsakura.blossom.lib.permissions.Permissions;
import dev.codedsakura.blossom.lib.teleport.TeleportUtils;
import dev.codedsakura.blossom.lib.text.DimName;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.PlayerSetFoV;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_3222;

public class BlossomLib
implements ModInitializer {
    private static final ArrayList<LiteralArgumentBuilder<class_2168>> COMMANDS = new ArrayList();
    private static final ArrayList<Consumer<CommandDispatcher<class_2168>>> COMMAND_CONSUMERS = new ArrayList();

    public void onInitialize() {
        ServerTickEvents.END_SERVER_TICK.register(_server -> TeleportUtils.tick());
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blossomlib").requires(Permissions.require("blossom.lib.base-command", 2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload-configs").requires(Permissions.require("blossom.lib.base-command.reload-configs", 3))).executes(ctx -> {
                ConfigManager.refreshAll();
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.configs-reload", new Object[0]);
                return 1;
            })).then(class_2170.method_9244((String)"module", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
                String start = builder.getRemaining().toLowerCase();
                ConfigManager.getAllRegistered().stream().map(Class::getSimpleName).sorted(String::compareToIgnoreCase).filter(c -> c.toLowerCase().startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                return builder.buildFuture();
            }).executes(ctx -> {
                String module = StringArgumentType.getString((CommandContext)ctx, (String)"module");
                Class target = ConfigManager.getAllRegistered().stream().filter(c -> c.getSimpleName().equals(module)).findFirst().orElseThrow();
                ConfigManager.refresh(target);
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.config-reload", target);
                return 1;
            })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clear-countdowns").requires(Permissions.require("blossom.lib.base-command.clear.countdowns", 2))).executes(ctx -> {
                TeleportUtils.clearAll();
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.clear-countdowns.all", new Object[0]);
                return 1;
            })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
                class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"player");
                TeleportUtils.cancelCountdowns(player.method_5667());
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.clear-countdowns.one", player);
                return 1;
            })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clear-cooldowns").requires(Permissions.require("blossom.lib.base-command.clear.cooldowns", 2))).executes(ctx -> {
                TeleportUtils.cancelAllCooldowns();
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.clear-cooldowns.all", new Object[0]);
                return 1;
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
                class_3222 player = class_2186.method_9315((CommandContext)ctx, (String)"player");
                TeleportUtils.cancelCooldowns(player.method_5667());
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.clear-cooldowns.one", player);
                return 1;
            })).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
                String start = builder.getRemaining().toLowerCase();
                TeleportUtils.getCooldowns(class_2186.method_9315((CommandContext)ctx, (String)"player").method_5667()).stream().map(Class::getSimpleName).sorted(String::compareToIgnoreCase).filter(c -> c.toLowerCase().startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                return builder.buildFuture();
            }).executes(ctx -> {
                String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
                UUID player = class_2186.method_9315((CommandContext)ctx, (String)"player").method_5667();
                Class target = TeleportUtils.getCooldowns(player).stream().filter(c -> c.getSimpleName().equals(type)).findFirst().orElseThrow();
                TeleportUtils.cancelCooldown(player, target);
                TextUtils.sendOps((CommandContext<class_2168>)ctx, "blossom.clear-cooldowns.type", player, type);
                return 1;
            }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(Permissions.require("blossom.lib.base-command.debug", 4))).then(class_2170.method_9247((String)"countdown").then(class_2170.method_9244((String)"standStill", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
                int standStill = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"standStill");
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                if (player == null) {
                    return 1;
                }
                TextUtils.send((CommandContext<class_2168>)ctx, "blossom.debug.countdown.start", standStill);
                TeleportUtils.genericCountdown(null, standStill, player, () -> {
                    BlossomGlobals.LOGGER.info("debug countdown done");
                    TextUtils.send((CommandContext<class_2168>)ctx, "blossom.debug.countdown.end", new Object[0]);
                });
                return 1;
            })))).then(class_2170.method_9247((String)"teleport").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"standStill", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"rot", (ArgumentType)class_2270.method_9717()).executes(ctx -> {
                class_241 rot = class_2270.method_9716((CommandContext)ctx, (String)"rot").method_9709((class_2168)ctx.getSource());
                int standStill = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"standStill");
                TextUtils.send((CommandContext<class_2168>)ctx, "blossom.debug.teleport.no-cooldown", standStill);
                return TeleportUtils.teleport(null, standStill, ((class_2168)ctx.getSource()).method_44023(), () -> new TeleportUtils.TeleportDestination(((class_2168)ctx.getSource()).method_9225(), class_2277.method_9736((CommandContext)ctx, (String)"pos"), rot.field_1342, rot.field_1343)) ? 1 : 0;
            })))).then(class_2170.method_9244((String)"cooldown", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9735((boolean)true)).then(class_2170.method_9244((String)"rot", (ArgumentType)class_2270.method_9717()).executes(ctx -> {
                class_241 rot = class_2270.method_9716((CommandContext)ctx, (String)"rot").method_9709((class_2168)ctx.getSource());
                int standStill = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"standStill");
                int cooldown = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cooldown");
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                if (player == null) {
                    return 1;
                }
                TextUtils.send((CommandContext<class_2168>)ctx, "blossom.debug.teleport.cooldown", standStill, cooldown);
                return TeleportUtils.teleport(null, standStill, cooldown, BlossomLib.class, player, () -> new TeleportUtils.TeleportDestination(((class_2168)ctx.getSource()).method_9225(), class_2277.method_9736((CommandContext)ctx, (String)"pos"), rot.field_1342, rot.field_1343)) ? 1 : 0;
            }))))))).then(class_2170.method_9247((String)"fov").then(class_2170.method_9244((String)"multiplier", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
                PlayerSetFoV.setPlayerFoV(Objects.requireNonNull(((class_2168)ctx.getSource()).method_44023()), FloatArgumentType.getFloat((CommandContext)ctx, (String)"multiplier"));
                return 1;
            })))).then(class_2170.method_9247((String)"dimName").then(class_2170.method_9244((String)"identifier", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
                TextUtils.send((CommandContext<class_2168>)ctx, "Result: %s", DimName.get(class_2232.method_9443((CommandContext)ctx, (String)"identifier")));
                return 1;
            })))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpcancel").requires(Permissions.require("blossom.tpcancel", true))).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_9207();
                if (TeleportUtils.hasCountdowns(player.method_5667())) {
                    TeleportUtils.cancelCountdowns(player.method_5667());
                    TextUtils.send((CommandContext<class_2168>)ctx, "blossom.tpcancel", new Object[0]);
                } else {
                    TextUtils.send((CommandContext<class_2168>)ctx, "blossom.tpcancel.fail", new Object[0]);
                }
                return 1;
            }));
            COMMANDS.forEach((Consumer<LiteralArgumentBuilder<class_2168>>)((Consumer<LiteralArgumentBuilder>)arg_0 -> ((CommandDispatcher)dispatcher).register(arg_0)));
            COMMAND_CONSUMERS.forEach((Consumer<Consumer<CommandDispatcher<class_2168>>>)((Consumer<Consumer>)consumer -> consumer.accept(dispatcher)));
        });
        BlossomGlobals.LOGGER.info("BlossomLib has starting");
    }

    public static void addCommand(LiteralArgumentBuilder<class_2168> command) {
        COMMANDS.add(command);
    }

    public static void registerCommand(Consumer<CommandDispatcher<class_2168>> callback) {
        COMMAND_CONSUMERS.add(callback);
    }
}

