/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.teleport;

import dev.codedsakura.blossom.lib.BlossomGlobals;
import dev.codedsakura.blossom.lib.teleport.TeleportConfig;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.HashablePair;
import dev.codedsakura.blossom.lib.utils.PlayerSetFoV;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1259;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TeleportUtils {
    private static final ArrayList<CounterRunnable> TASKS = new ArrayList();
    private static final HashMap<HashablePair<UUID, Class<?>>, Long> COOLDOWNS = new HashMap();
    private static final HashMap<UUID, TeleportDestination> LAST_TELEPORT = new HashMap();
    private static final ArrayList<LastTeleportAddHook> LAST_TELEPORT_ADD_HOOKS = new ArrayList();
    private static final String IDENTIFIER = "blossom:standstill";

    public static void tick() {
        TASKS.forEach(CounterRunnable::run);
        TASKS.removeIf(CounterRunnable::shouldRemove);
    }

    public static void genericCountdown(@Nullable TeleportConfig customConfig, double standStillTime, final class_3222 who, final Runnable onDone) {
        BlossomGlobals.LOGGER.debug("Create new genericCountdown for {} ({} s)", (Object)who.method_5667(), (Object)standStillTime);
        final MinecraftServer server = who.method_51469().method_8503();
        final class_243[] lastPos = new class_243[]{who.method_73189()};
        final TeleportConfig config = customConfig == null ? BlossomGlobals.CONFIG.baseTeleportation : customConfig.cloneMerge();
        class_3002 commandBossBar = null;
        final int standTicks = (int)(standStillTime * 20.0);
        if (config.bossBar.enabled) {
            class_2960 id = class_2960.method_60654((String)("blossom:standstill_" + who.method_5845()));
            commandBossBar = Optional.ofNullable(server.method_3837().method_12971(id)).orElseGet(() -> server.method_3837().method_12970(id, (class_2561)TextUtils.translation("blossom.countdown.boss_bar.name", class_2561.method_43470((String)Integer.toString(standTicks)).method_27694(style -> style.method_27703(TextUtils.parseColor(BlossomGlobals.CONFIG.colors.variable)))).method_27694(style -> style.method_27703(TextUtils.parseColor(config.bossBar.textColor)))));
            commandBossBar.method_5416(Arrays.stream(class_1259.class_1260.values()).filter(c -> c.method_5421().equals(config.bossBar.color)).findFirst().orElse(class_1259.class_1260.field_5783));
            commandBossBar.method_14094();
            commandBossBar.method_14088(who);
        }
        who.field_13987.method_14364((class_2596)new class_5905(0, 10, 5));
        final class_3002 finalCommandBossBar = commandBossBar;
        final float[] lastFovMultiplier = new float[]{1.0f};
        int endAt = config.fovEffectAfter.isEnabled() ? -config.fovEffectAfter.getStepCount() - 1 : 0;
        TASKS.add(new CounterRunnable(standTicks, endAt, who.method_5667()){

            private void handleZero() {
                if (this.counter != 0) {
                    return;
                }
                BlossomGlobals.LOGGER.debug("genericCountdown for {} has ended", (Object)this.player);
                this.cleanUp();
                if (config.titleMessage.enabled) {
                    who.field_13987.method_14364((class_2596)new class_5903((class_2561)config.titleMessage.subtitleDone.getText("blossom.countdown.title.done.subtitle")));
                    who.field_13987.method_14364((class_2596)new class_5904((class_2561)config.titleMessage.titleDone.getText("blossom.countdown.title.done.title")));
                }
                if (config.actionBarMessageEnabled) {
                    who.method_7353((class_2561)TextUtils.translation("blossom.countdown.action_bar.done", new Object[0]), true);
                }
                onDone.run();
            }

            private void changeFov() {
                float newFov;
                int stepIndex = config.fovEffectBefore.getStepCount() + 1 - this.counter;
                if (config.fovEffectBefore.isEnabled() && this.counter > 0 && stepIndex >= 0) {
                    newFov = (float)config.fovEffectBefore.getData().get(stepIndex).doubleValue();
                    PlayerSetFoV.setPlayerFoV(who, 2.0f * newFov - lastFovMultiplier[0]);
                    lastFovMultiplier[0] = newFov;
                }
                if (config.fovEffectAfter.isEnabled() && this.counter < 0) {
                    stepIndex = -this.counter - 1;
                    newFov = (float)config.fovEffectAfter.getData().get(stepIndex).doubleValue();
                    PlayerSetFoV.setPlayerFoV(who, 2.0f * newFov - lastFovMultiplier[0]);
                    lastFovMultiplier[0] = newFov;
                }
            }

            private boolean isStill() {
                if (this.counter < 1) {
                    return true;
                }
                class_243 pos = who.method_73189();
                double dist = lastPos[0].method_1022(pos);
                if (dist < 0.05) {
                    if (dist != 0.0) {
                        lastPos[0] = pos;
                    }
                    return true;
                }
                BlossomGlobals.LOGGER.debug("genericCountdown for {} has been reset after {} ticks", (Object)this.player, (Object)(standTicks - this.counter));
                lastFovMultiplier[0] = 1.0f;
                PlayerSetFoV.setPlayerFoV(who, 1.0f);
                lastPos[0] = pos;
                return false;
            }

            private void updateCountdown() {
                if (this.counter < 1) {
                    return;
                }
                int remaining = (int)Math.floor((float)this.counter / 20.0f + 1.0f);
                if (finalCommandBossBar != null) {
                    finalCommandBossBar.method_5408((float)this.counter / (float)standTicks);
                    finalCommandBossBar.method_5413((class_2561)TextUtils.translation("blossom.countdown.boss_bar.name", class_2561.method_43470((String)Integer.toString(remaining)).method_27694(style -> style.method_27703(TextUtils.parseColor(BlossomGlobals.CONFIG.colors.variable)))).method_27694(style -> style.method_27703(TextUtils.parseColor(config2.bossBar.textColor))));
                }
                if (config.actionBarMessageEnabled) {
                    who.method_7353((class_2561)TextUtils.translation("blossom.countdown.action_bar.counting", remaining), true);
                }
                if (config.titleMessage.enabled) {
                    who.field_13987.method_14364((class_2596)new class_5903((class_2561)config.titleMessage.subtitleCounting.getText("blossom.countdown.title.counting.subtitle", remaining)));
                    who.field_13987.method_14364((class_2596)new class_5904((class_2561)config.titleMessage.titleCounting.getText("blossom.countdown.title.counting.title", remaining)));
                }
            }

            @Override
            protected void run() {
                this.handleZero();
                this.changeFov();
                if (!this.isStill()) {
                    if (config.cancelOnMove) {
                        this.remove();
                        return;
                    }
                    this.counter = standTicks;
                    return;
                }
                this.updateCountdown();
                --this.counter;
            }

            @Override
            protected void cleanUp() {
                if (finalCommandBossBar != null) {
                    finalCommandBossBar.method_14089(who);
                    server.method_3837().method_12973(finalCommandBossBar);
                }
                if (this.counter != 0) {
                    PlayerSetFoV.setPlayerFoV(who, 1.0f);
                }
            }
        });
    }

    public static void cancelCountdowns(UUID player) {
        TASKS.stream().filter(task -> task.player.compareTo(player) == 0).forEach(CounterRunnable::remove);
    }

    public static boolean hasCountdowns(UUID player) {
        return TASKS.stream().anyMatch(task -> task.player.compareTo(player) == 0);
    }

    public static void clearAll() {
        TASKS.forEach(CounterRunnable::remove);
    }

    public static boolean teleport(@Nullable TeleportConfig customConfig, double standStillTime, class_3222 who, GetDestination getWhere) {
        return TeleportUtils.teleport(customConfig, standStillTime, 0L, TeleportUtils.class, who, getWhere);
    }

    public static boolean teleport(@Nullable TeleportConfig customConfig, double standStillTime, long cooldownTime, Class<?> cooldownClass, class_3222 who, GetDestination getWhere) {
        long timeLeft;
        if (TeleportUtils.hasCountdowns(who.method_5667())) {
            who.method_7353((class_2561)TextUtils.fTranslation("blossom.error.has-countdown", TextUtils.Type.ERROR, new Object[0]), false);
            return false;
        }
        HashablePair pair = new HashablePair(who.method_5667(), cooldownClass);
        if (COOLDOWNS.containsKey(pair) && (timeLeft = COOLDOWNS.get(pair) - new Date().getTime() / 1000L) > 0L) {
            who.method_7353((class_2561)TextUtils.fTranslation("blossom.error.has-cooldown", TextUtils.Type.ERROR, timeLeft), false);
            return false;
        }
        TeleportUtils.genericCountdown(customConfig, standStillTime, who, () -> {
            TeleportConfig config;
            TeleportConfig teleportConfig = config = customConfig == null ? BlossomGlobals.CONFIG.baseTeleportation : customConfig.cloneMerge();
            if (config.allowBack) {
                TeleportUtils.addLastTeleport(who.method_5667(), new TeleportDestination((class_1657)who));
            }
            TeleportDestination where = getWhere.get();
            who.method_48105(where.world, where.x, where.y, where.z, Set.of(), where.yaw, where.pitch, false);
            COOLDOWNS.put(pair, new Date().getTime() / 1000L + cooldownTime);
        });
        return true;
    }

    public static void cancelCooldown(UUID player, Class<?> targetClass) {
        HashablePair key = new HashablePair(player, targetClass);
        COOLDOWNS.remove(key);
    }

    public static void cancelCooldowns(UUID player) {
        COOLDOWNS.keySet().removeIf(key -> ((UUID)key.getLeft()).compareTo(player) == 0);
    }

    public static void cancelAllCooldowns() {
        COOLDOWNS.clear();
    }

    public static boolean hasCooldown(UUID player, Class<?> targetClass) {
        HashablePair key = new HashablePair(player, targetClass);
        return COOLDOWNS.containsKey(key);
    }

    public static List<Class<?>> getCooldowns(UUID player) {
        return COOLDOWNS.keySet().stream().filter(key -> ((UUID)key.getLeft()).compareTo(player) == 0).map(HashablePair::getRight).collect(Collectors.toList());
    }

    public static void addLastTeleportAddHook(LastTeleportAddHook hook) {
        LAST_TELEPORT_ADD_HOOKS.add(hook);
    }

    private static void addLastTeleport(UUID player, TeleportDestination destination) {
        LAST_TELEPORT.put(player, destination);
        LAST_TELEPORT_ADD_HOOKS.forEach(hook -> hook.run(player, destination, LAST_TELEPORT));
    }

    public static TeleportDestination getLastTeleport(UUID player) {
        return LAST_TELEPORT.get(player);
    }

    public static HashMap<UUID, TeleportDestination> getAllLastTeleports() {
        return LAST_TELEPORT;
    }

    public static interface GetDestination {
        public TeleportDestination get();
    }

    public static class TeleportDestination {
        public final class_3218 world;
        public final double x;
        public final double y;
        public final double z;
        public final float yaw;
        public final float pitch;

        public TeleportDestination(class_3218 world, class_243 pos, float yaw, float pitch) {
            this(world, pos.field_1352, pos.field_1351, pos.field_1350, yaw, pitch);
        }

        public TeleportDestination(class_3218 world, double x, double y, double z, class_241 rotation) {
            this(world, x, y, z, rotation.field_1343, rotation.field_1342);
        }

        public TeleportDestination(class_3218 world, class_243 pos, class_241 rotation) {
            this(world, pos.field_1352, pos.field_1351, pos.field_1350, rotation.field_1343, rotation.field_1342);
        }

        public TeleportDestination(class_1657 player) {
            this((class_3218)player.method_73183(), player.method_73189(), player.method_36454(), player.method_36455());
        }

        public TeleportDestination(class_3218 world, double x, double y, double z, float yaw, float pitch) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public String toString() {
            return "TeleportDestination{world=" + String.valueOf(this.world) + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + "}";
        }
    }

    public static interface LastTeleportAddHook {
        public void run(UUID var1, TeleportDestination var2, HashMap<UUID, TeleportDestination> var3);
    }

    private static abstract class CounterRunnable {
        int counter;
        int endAt;
        UUID player;
        boolean forceRemove = false;

        public CounterRunnable(int counter, int endAt, UUID player) {
            this.counter = counter;
            this.endAt = endAt;
            this.player = player;
        }

        protected abstract void run();

        protected abstract void cleanUp();

        boolean shouldRemove() {
            return this.forceRemove || this.counter < this.endAt;
        }

        void remove() {
            this.cleanUp();
            this.forceRemove = true;
        }
    }
}

