/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.utils;

import dev.codedsakura.blossom.lib.BlossomGlobals;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class CustomLogger {
    private static LoggerContext CONTEXT = null;

    private static void initialize() {
        Configurator.reconfigure();
        if (BlossomGlobals.CONFIG.logging.disableCustomLogger) {
            CONTEXT = LoggerContext.getContext((boolean)true);
            return;
        }
        Appender sysOut = LoggerContext.getContext((boolean)false).getConfiguration().getAppender("SysOut");
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.add(((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("fileLog", "File").addAttribute("fileName", BlossomGlobals.CONFIG.logging.fileLogPath)).addAttribute("append", BlossomGlobals.CONFIG.logging.fileLogAppend)).add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.DENY).addAttribute("level", BlossomGlobals.CONFIG.logging.fileLogLevel))).add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%d{yyyy-MM-dd HH:mm:ss}] [%t/%5level] (%logger{1}): %msg%n%throwable")));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.TRACE).add(builder.newAppenderRef("fileLog")));
        CONTEXT = LoggerContext.getContext((boolean)true);
        CONTEXT.setConfiguration(builder.build(false));
        Configuration configuration = CONTEXT.getConfiguration();
        configuration.addAppender(sysOut);
        configuration.getRootLogger().addAppender(sysOut, Level.getLevel((String)BlossomGlobals.CONFIG.logging.consoleLogLevel), null);
    }

    public static Logger createLogger(String name) {
        if (CONTEXT == null) {
            CustomLogger.initialize();
        }
        return CONTEXT.getLogger(name);
    }
}

