/*
 * Decompiled with CFR 0.152.
 */
package com.ashkiano.toggleop;

import com.ashkiano.toggleop.Metrics;
import com.ashkiano.toggleop.ToggleOpCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONObject;

public class ToggleOp
extends JavaPlugin {
    public void onEnable() {
        String[] languages;
        this.saveDefaultConfig();
        File languageFolder = new File(this.getDataFolder(), "languages");
        if (!languageFolder.exists()) {
            languageFolder.mkdirs();
        }
        for (String lang : languages = new String[]{"en", "cs", "de", "sk", "es", "ru"}) {
            File langFile = new File(languageFolder, lang + ".yml");
            if (langFile.exists()) continue;
            this.saveResource("languages/" + lang + ".yml", false);
        }
        String languageCode = this.getConfig().getString("language", "en");
        this.getCommand("toggleop").setExecutor((CommandExecutor)new ToggleOpCommand(this, languageCode));
        this.getLogger().info("Thank you for using the ToggleOp plugin! If you enjoy using this plugin, please consider making a donation to support the development. You can donate at: https://donate.ashkiano.com");
        Metrics metrics = new Metrics(this, 18886);
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        try {
            String pluginName = this.getDescription().getName();
            URL url = new URL("https://plugins.ashkiano.com/version_check.php?plugin=" + pluginName);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String jsonResponse = response.toString();
                JSONObject jsonObject = new JSONObject(jsonResponse);
                if (jsonObject.has("error")) {
                    this.getLogger().warning("Error when checking for updates: " + jsonObject.getString("error"));
                } else {
                    String latestVersion = jsonObject.getString("latest_version");
                    String currentVersion = this.getDescription().getVersion();
                    if (currentVersion.equals(latestVersion)) {
                        this.getLogger().info("This plugin is up to date!");
                    } else {
                        this.getLogger().warning("There is a newer version (" + latestVersion + ") available! Please update!");
                    }
                }
            } else {
                this.getLogger().warning("Failed to check for updates. Response code: " + responseCode);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to check for updates. Error: " + e.getMessage());
        }
    }
}

