/*
 * Decompiled with CFR 0.152.
 */
package com.ashkiano.toggleop;

import com.ashkiano.toggleop.ToggleOp;
import java.io.File;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ToggleOpCommand
implements CommandExecutor {
    private ToggleOp plugin;
    private FileConfiguration langConfig;
    private String noPermissionMessage;
    private String nonPlayerMessage;
    private String revokeOpMessage;
    private String grantOpMessage;

    public ToggleOpCommand(ToggleOp plugin, String languageCode) {
        this.plugin = plugin;
        File langFile = new File(plugin.getDataFolder() + "/languages", languageCode + ".yml");
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        this.noPermissionMessage = this.langConfig.getString("messages.noPermission", "You do not have permission to use this command!");
        this.nonPlayerMessage = this.langConfig.getString("messages.nonPlayer", "Only players can use this command!");
        this.revokeOpMessage = this.langConfig.getString("messages.revokeOp", "OP status has been revoked.");
        this.grantOpMessage = this.langConfig.getString("messages.grantOp", "OP status has been granted.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.nonPlayerMessage);
            return true;
        }
        Player player = (Player)sender;
        String permission = this.plugin.getConfig().getString("permission", "toggleop");
        if (player.hasPermission(permission)) {
            if (player.isOp()) {
                player.setOp(false);
                player.sendMessage(this.revokeOpMessage);
            } else {
                player.setOp(true);
                player.sendMessage(this.grantOpMessage);
            }
        } else {
            player.sendMessage(this.noPermissionMessage);
        }
        return true;
    }
}

