/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import brentmaas.buildguide.common.shape.ShapeSet;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Shape {
    public ArrayList<Property<?>> properties = new ArrayList();
    public IShapeBuffer buffer;
    private int nBlocks = 0;
    public boolean ready = false;
    public boolean vertexBufferUnpacked = false;
    protected ShapeSet shapeSet;
    protected double originOffsetX = 0.0;
    protected double originOffsetY = 0.0;
    protected double originOffsetZ = 0.0;
    private static ExecutorService executor = Executors.newCachedThreadPool();
    public ReentrantLock lock = new ReentrantLock();
    private Future<?> future = null;
    private long completedAt = 0L;
    public boolean error = false;

    protected abstract void updateShape(IShapeBuffer var1) throws Exception;

    public void update() {
        BaseScreen.shouldUpdatePersistence = true;
        this.ready = false;
        this.vertexBufferUnpacked = false;
        if (((Boolean)BuildGuide.config.asyncEnabled.value).booleanValue()) {
            this.cancelFuture();
        }
        if (this.buffer != null) {
            this.buffer.close();
        }
        this.future = executor.submit(() -> {
            try {
                this.lock.lock();
                this.ready = false;
                this.vertexBufferUnpacked = false;
                this.error = false;
                this.doUpdate();
            }
            catch (InterruptedException e) {
                this.error = true;
            }
            catch (Exception e) {
                this.error = true;
                BuildGuide.logHandler.debugThrowable("An exception occurred while generating a shape.", e);
            }
            finally {
                this.completedAt = System.currentTimeMillis();
                this.ready = true;
                this.lock.unlock();
            }
        });
        if (!((Boolean)BuildGuide.config.asyncEnabled.value).booleanValue()) {
            try {
                this.future.get();
            }
            catch (Exception e) {
                this.error = true;
                e.printStackTrace();
            }
        }
    }

    private void cancelFuture() {
        if (this.future != null && !this.future.isDone() && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
    }

    private void doUpdate() throws Exception {
        this.nBlocks = 0;
        this.buffer = BuildGuide.shapeHandler.newBuffer();
        this.buffer.setColour((int)(255.0f * this.shapeSet.getShapeColourR()), (int)(255.0f * this.shapeSet.getShapeColourG()), (int)(255.0f * this.shapeSet.getShapeColourB()), (int)(255.0f * this.shapeSet.getShapeColourA()));
        this.updateShape(this.buffer);
        this.buffer.setColour((int)(255.0f * this.shapeSet.getOriginColourR()), (int)(255.0f * this.shapeSet.getOriginColourG()), (int)(255.0f * this.shapeSet.getOriginColourB()), (int)(255.0f * this.shapeSet.getOriginColourA()));
        this.addOriginCube(this.buffer);
    }

    private void addCube(IShapeBuffer buffer, double x, double y, double z, double s) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        buffer.pushVertex(x, y, z);
        buffer.pushVertex(x, y, z + s);
        buffer.pushVertex(x, y + s, z + s);
        buffer.pushVertex(x, y + s, z);
        buffer.pushVertex(x, y, z);
        buffer.pushVertex(x + s, y, z);
        buffer.pushVertex(x + s, y, z + s);
        buffer.pushVertex(x, y, z + s);
        buffer.pushVertex(x, y, z);
        buffer.pushVertex(x, y + s, z);
        buffer.pushVertex(x + s, y + s, z);
        buffer.pushVertex(x + s, y, z);
        buffer.pushVertex(x + s, y, z);
        buffer.pushVertex(x + s, y + s, z);
        buffer.pushVertex(x + s, y + s, z + s);
        buffer.pushVertex(x + s, y, z + s);
        buffer.pushVertex(x, y + s, z);
        buffer.pushVertex(x, y + s, z + s);
        buffer.pushVertex(x + s, y + s, z + s);
        buffer.pushVertex(x + s, y + s, z);
        buffer.pushVertex(x, y, z + s);
        buffer.pushVertex(x + s, y, z + s);
        buffer.pushVertex(x + s, y + s, z + s);
        buffer.pushVertex(x, y + s, z + s);
    }

    protected void addShapeCube(IShapeBuffer buffer, int x, int y, int z) throws InterruptedException {
        this.addCube(buffer, (double)x + 0.5 - this.shapeSet.getShapeCubeSize() / 2.0, (double)y + 0.5 - this.shapeSet.getShapeCubeSize() / 2.0, (double)z + 0.5 - this.shapeSet.getShapeCubeSize() / 2.0, this.shapeSet.getShapeCubeSize());
        ++this.nBlocks;
    }

    protected void addOriginCube(IShapeBuffer buffer) throws InterruptedException {
        this.addCube(buffer, 0.5 - this.shapeSet.getOriginCubeSize() / 2.0 + this.originOffsetX, 0.5 - this.shapeSet.getOriginCubeSize() / 2.0 + this.originOffsetY, 0.5 - this.shapeSet.getOriginCubeSize() / 2.0 + this.originOffsetZ, this.shapeSet.getOriginCubeSize());
    }

    protected void setOriginOffset(double dx, double dy, double dz) {
        this.originOffsetX = dx;
        this.originOffsetY = dy;
        this.originOffsetZ = dz;
    }

    public void onSelectedInGUI() {
        for (int i = 0; i < this.properties.size(); ++i) {
            this.properties.get(i).setX(180);
            this.properties.get(i).setY(70 + i * 20);
            this.properties.get(i).setVisibility(true);
        }
    }

    public void onDeselectedInGUI() {
        for (Property<?> p : this.properties) {
            p.setVisibility(false);
        }
    }

    public int getNumberOfBlocks() {
        if (!this.ready) {
            return 0;
        }
        return this.nBlocks;
    }

    public long getHowLongAgoCompletedMillis() {
        return System.currentTimeMillis() - this.completedAt;
    }

    public final String getTranslationKey() {
        return ShapeRegistry.getTranslationKey(this);
    }

    public String toPersistence() {
        Object persistenceData = "";
        for (Property<?> property : this.properties) {
            persistenceData = (String)persistenceData + property.getStringValue() + ",";
        }
        return ((String)persistenceData).substring(0, ((String)persistenceData).length() - 1);
    }

    public void restorePersistence(String persistenceData) {
        String[] splitData = persistenceData.split(",");
        boolean success = true;
        for (int i = 0; i < Math.min(this.properties.size(), splitData.length); ++i) {
            success &= this.properties.get(i).setValueFromString(splitData[i]);
        }
        this.error = !success;
    }
}

