/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.screen.widget.IWidget;
import java.util.ArrayList;

public class PropertyFloat
extends Property<Float> {
    private ITextField valueTextField;
    private Runnable onPress;

    public PropertyFloat(float value, AbstractScreenHandler.Translatable name, Runnable onPress) {
        super(Float.valueOf(value), name);
        this.onPress = onPress;
    }

    @Override
    protected void initWidgets(ArrayList<IWidget> widgetList) {
        widgetList.add(BuildGuide.widgetHandler.createButton(this.x + 90, this.y, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> {
            this.value = Float.valueOf(((Float)this.value).floatValue() - 1.0f);
            this.valueTextField.setTextValue(String.valueOf(this.value));
            this.valueTextField.setTextColour(0xFFFFFF);
            if (this.onPress != null) {
                this.onPress.run();
            }
        }));
        this.valueTextField = BuildGuide.widgetHandler.createTextField(this.x + 110, this.y, 50, 20, "");
        this.valueTextField.setTextValue(String.valueOf(this.value));
        this.valueTextField.setTextColour(0xFFFFFF);
        widgetList.add(this.valueTextField);
        widgetList.add(BuildGuide.widgetHandler.createButton(this.x + 160, this.y, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
            try {
                float newval = Float.parseFloat(this.valueTextField.getTextValue());
                this.value = Float.valueOf(newval);
                this.valueTextField.setTextColour(0xFFFFFF);
                if (this.onPress != null) {
                    this.onPress.run();
                }
            }
            catch (NumberFormatException e) {
                this.valueTextField.setTextColour(0xFF0000);
            }
        }));
        widgetList.add(BuildGuide.widgetHandler.createButton(this.x + 190, this.y, 20, 20, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> {
            this.value = Float.valueOf(((Float)this.value).floatValue() + 1.0f);
            this.valueTextField.setTextValue(String.valueOf(this.value));
            this.valueTextField.setTextColour(0xFFFFFF);
            if (this.onPress != null) {
                this.onPress.run();
            }
        }));
    }

    @Override
    public void setValue(Float value) {
        super.setValue(value);
        this.getWidgetList();
        this.valueTextField.setTextValue("" + value);
        this.valueTextField.setTextColour(0xFFFFFF);
    }

    @Override
    public String getStringValue() {
        return ((Float)this.value).toString();
    }

    @Override
    public boolean setValueFromString(String value) {
        try {
            this.setValue(Float.valueOf(Float.parseFloat(value)));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

