/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.neoforge;

import brentmaas.buildguide.common.AbstractLegacyRenderHandler;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;
import brentmaas.buildguide.neoforge.shape.ShapeBuffer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL32;

public class RenderHandler
extends AbstractLegacyRenderHandler {
    private Camera cameraInstance;
    private PoseStack poseStackInstance;
    private Matrix4f projectionMatrixInstance;

    @Override
    public void register() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderBlock(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            this.poseStackInstance = new PoseStack();
            this.poseStackInstance.mulPose(event.getPoseStack().last().pose());
            Matrix4f rotationMatrix = new Matrix4f();
            this.cameraInstance = Minecraft.getInstance().gameRenderer.getMainCamera();
            rotationMatrix.rotate((float)((double)this.cameraInstance.getXRot() * Math.PI / 180.0), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
            rotationMatrix.rotate((float)((double)(this.cameraInstance.getYRot() - 180.0f) * Math.PI / 180.0), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
            this.poseStackInstance.mulPose(rotationMatrix);
            this.projectionMatrixInstance = event.getProjectionMatrix();
            this.render();
        }
    }

    @Override
    public void renderShapeBuffer(Shape shape) {
        ((ShapeBuffer)shape.buffer).render(this.poseStackInstance.last().pose(), this.projectionMatrixInstance);
    }

    @Override
    protected void setupRenderingShapeSet(ShapeSet shapeSet) {
        this.poseStackInstance.pushPose();
        Vec3 projectedView = this.cameraInstance.getPosition();
        this.poseStackInstance.translate(-projectedView.x + (double)shapeSet.getOriginX(), -projectedView.y + (double)shapeSet.getOriginY(), -projectedView.z + (double)shapeSet.getOriginZ());
    }

    @Override
    protected void endRenderingShapeSet() {
        this.poseStackInstance.popPose();
    }

    @Override
    protected boolean depthTestEnabled() {
        return GL32.glIsEnabled((int)2929);
    }

    @Override
    protected boolean depthMaskEnabled() {
        return GL32.glGetBoolean((int)2930);
    }

    @Override
    protected boolean blendEnabled() {
        return GL32.glIsEnabled((int)3042);
    }

    @Override
    protected void setDepthTest(boolean enabled) {
        if (enabled) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
    }

    @Override
    protected void setDepthMask(boolean enabled) {
        RenderSystem.depthMask((boolean)enabled);
    }

    @Override
    protected void setBlend(boolean enabled) {
        if (enabled) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
    }

    @Override
    protected void setupNotCulling() {
        RenderSystem.polygonMode((int)1032, (int)6914);
    }

    @Override
    protected void setupBlendFunc() {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    protected void pushProfiler(String key) {
        Profiler.get().push(key);
    }

    @Override
    protected void popProfiler() {
        Profiler.get().pop();
    }
}

