/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeCircle
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, new AbstractScreenHandler.Translatable("property.buildguide.direction", new Object[0]), () -> this.update(), this.directionNames);
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, new AbstractScreenHandler.Translatable("property.buildguide.radius", new Object[0]), () -> this.update());
    private PropertyNonzeroInt propertyDepth = new PropertyNonzeroInt(1, new AbstractScreenHandler.Translatable("property.buildguide.depth", new Object[0]), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, new AbstractScreenHandler.Translatable("property.buildguide.evenmode", new Object[0]), () -> this.update());

    public ShapeCircle() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyDepth);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float radius = ((Float)this.propertyRadius.value).floatValue();
        int depth = (Integer)this.propertyDepth.value;
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        this.setOriginOffset(this.propertyDir.value == direction.X ? 0.0 : offset, this.propertyDir.value == direction.Y ? 0.0 : offset, this.propertyDir.value == direction.Z ? 0.0 : offset);
        for (int x = (int)Math.floor((double)(-radius) + offset); x <= (int)Math.ceil((double)radius + offset); ++x) {
            for (int y = (int)Math.floor((double)(-radius) + offset); y <= (int)Math.ceil((double)radius + offset); ++y) {
                double r2 = ((double)x - offset) * ((double)x - offset) + ((double)y - offset) * ((double)y - offset);
                if (!(r2 >= ((double)radius - 0.5) * ((double)radius - 0.5)) || !(r2 <= ((double)radius + 0.5) * ((double)radius + 0.5))) continue;
                block7: for (int z = depth > 0 ? 0 : depth + 1; z < (depth > 0 ? depth : 1); ++z) {
                    switch (((direction)((Object)this.propertyDir.value)).ordinal()) {
                        case 0: {
                            this.addShapeCube(buffer, z, x, y);
                            continue block7;
                        }
                        case 1: {
                            this.addShapeCube(buffer, x, z, y);
                            continue block7;
                        }
                        case 2: {
                            this.addShapeCube(buffer, x, y, z);
                        }
                    }
                }
            }
        }
    }

    private static enum direction {
        X,
        Y,
        Z;

    }
}

