/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.fabric.shape;

import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.fabric.RenderHandler;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10366;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ShapeBuffer
implements IShapeBuffer {
    private class_9799 byteBufferBuilder = new class_9799(28);
    private class_287 bufferBuilder = new class_287(this.byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1576);
    private GpuBuffer vertexBuffer;
    private GpuBuffer indexBuffer;
    private int indexCount;
    private int defaultR = 255;
    private int defaultG = 255;
    private int defaultB = 255;
    private int defaultA = 255;

    @Override
    public void setColour(int r, int g, int b, int a) {
        this.defaultR = r;
        this.defaultG = g;
        this.defaultB = b;
        this.defaultA = a;
    }

    @Override
    public void pushVertex(double x, double y, double z) {
        this.bufferBuilder.method_22912((float)x, (float)y, (float)z).method_1336(this.defaultR, this.defaultG, this.defaultB, this.defaultA);
    }

    @Override
    public void end() {
        class_9801 meshData = this.bufferBuilder.method_60794();
        this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Build Guide vertices", 28, meshData.method_60818());
        this.indexCount = meshData.method_60822().comp_751();
        this.indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(this.indexCount);
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
    }

    public void render(Matrix4f model, Matrix4f projection) {
        class_276 renderTarget = class_310.method_1551().method_1522();
        GpuTextureView colourTexture = renderTarget.method_71639();
        GpuTextureView depthTexture = renderTarget.method_71640();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)RenderHandler.projectionMatrixBuffer.method_71123(new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)model)), (class_10366)RenderSystem.getProjectionType());
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Build Guide", colourTexture, OptionalInt.empty(), depthTexture, OptionalDouble.empty());){
            renderPass.setPipeline(RenderHandler.getRenderPipeline());
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setIndexBuffer(this.indexBuffer, RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_31924());
            renderPass.setVertexBuffer(0, this.vertexBuffer);
            renderPass.drawIndexed(0, 0, this.indexCount, 1);
        }
        RenderSystem.restoreProjectionMatrix();
    }
}

