/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.neoforge.screen;

import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.IScreenWrapper;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.ISelectorList;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import brentmaas.buildguide.common.screen.widget.ISlider;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.neoforge.screen.widget.ButtonImpl;
import brentmaas.buildguide.neoforge.screen.widget.CheckboxRunnableButtonImpl;
import brentmaas.buildguide.neoforge.screen.widget.SelectorListImpl;
import brentmaas.buildguide.neoforge.screen.widget.ShapeListImpl;
import brentmaas.buildguide.neoforge.screen.widget.SliderImpl;
import brentmaas.buildguide.neoforge.screen.widget.TextFieldImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ScreenWrapper
extends Screen
implements IScreenWrapper {
    private BaseScreen attachedScreen;
    private GuiGraphics guiGraphicsInstance;

    public ScreenWrapper(Component title) {
        super(title);
    }

    public void init() {
        super.init();
        this.attachedScreen.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.guiGraphicsInstance = guiGraphics;
        this.attachedScreen.render();
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
    }

    public boolean isPauseScreen() {
        return this.attachedScreen.isPauseScreen();
    }

    public void onClose() {
        super.onClose();
        this.attachedScreen.onScreenClosed();
    }

    @Override
    public void attachScreen(BaseScreen screen) {
        this.attachedScreen = screen;
        screen.setWrapper(this);
    }

    @Override
    public void show() {
        Minecraft.getInstance().setScreen((Screen)this);
    }

    @Override
    public void addButton(IButton button) {
        this.addRenderableWidget((GuiEventListener)((ButtonImpl)button));
    }

    @Override
    public void addTextField(ITextField textField) {
        this.addRenderableWidget((GuiEventListener)((TextFieldImpl)textField));
    }

    @Override
    public void addCheckbox(ICheckboxRunnableButton checkbox) {
        ((CheckboxRunnableButtonImpl)checkbox).initCheckboxIfNull();
        this.addRenderableWidget((GuiEventListener)((CheckboxRunnableButtonImpl)checkbox).checkbox);
    }

    @Override
    public void addSlider(ISlider slider) {
        slider.updateText();
        this.addRenderableWidget((GuiEventListener)((SliderImpl)slider));
    }

    @Override
    public void addShapeList(IShapeList shapeList) {
        this.addRenderableWidget((GuiEventListener)((ShapeListImpl)shapeList));
    }

    @Override
    public void addSelectorList(ISelectorList selectorList) {
        this.addRenderableWidget((GuiEventListener)((SelectorListImpl)selectorList));
    }

    @Override
    public void drawShadow(String text, int x, int y, int colour) {
        this.guiGraphicsInstance.drawString(this.font, text, x, y, colour, true);
    }

    @Override
    public int getTextWidth(String text) {
        return this.font.width(text);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

