/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge;

import brentmaas.buildguide.common.AbstractRenderHandler;
import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeSet;
import brentmaas.buildguide.forge.shape.ShapeBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderHandler
extends AbstractRenderHandler {
    private Camera cameraInstance;
    private PoseStack poseStackInstance;
    private Matrix4f projectionMatrixInstance;
    private static final RenderPipeline.Snippet BUILD_GUIDE_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.DEBUG_FILLED_SNIPPET}).withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA)).withCull(true).withDepthWrite(false).buildSnippet();
    private static final RenderPipeline BUILD_GUIDE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{BUILD_GUIDE_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"buildguide", (String)"pipeline/build_guide")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
    private static final RenderPipeline BUILD_GUIDE_DEPTH_TEST = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{BUILD_GUIDE_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"buildguide", (String)"pipeline/build_guide_depth_test")).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();

    @Override
    public void register() {
    }

    public void onRenderBlock(Matrix4f projectionMatrix) {
        this.poseStackInstance = new PoseStack();
        this.poseStackInstance.pushPose();
        Matrix4f rotationMatrix = new Matrix4f();
        this.cameraInstance = Minecraft.getInstance().gameRenderer.getMainCamera();
        rotationMatrix.rotate((float)((double)this.cameraInstance.getXRot() * Math.PI / 180.0), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        rotationMatrix.rotate((float)((double)(this.cameraInstance.getYRot() - 180.0f) * Math.PI / 180.0), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        this.poseStackInstance.mulPose((Matrix4fc)rotationMatrix);
        this.projectionMatrixInstance = projectionMatrix;
        this.render();
        this.poseStackInstance.popPose();
    }

    @Override
    public void renderShapeBuffer(Shape shape) {
        ((ShapeBuffer)shape.buffer).render(this.poseStackInstance.last().pose(), this.projectionMatrixInstance);
    }

    @Override
    protected void setupRenderingShapeSet(ShapeSet shapeSet) {
        this.poseStackInstance.pushPose();
        Vec3 projectedView = this.cameraInstance.getPosition();
        this.poseStackInstance.translate(-projectedView.x + (double)shapeSet.getOriginX(), -projectedView.y + (double)shapeSet.getOriginY(), -projectedView.z + (double)shapeSet.getOriginZ());
    }

    @Override
    protected void endRenderingShapeSet() {
        this.poseStackInstance.popPose();
    }

    @Override
    protected void pushProfiler(String key) {
        Profiler.get().push(key);
    }

    @Override
    protected void popProfiler() {
        Profiler.get().pop();
    }

    public static RenderPipeline getRenderPipeline() {
        return BuildGuide.stateManager.getState().isDepthTest() ? BUILD_GUIDE_DEPTH_TEST : BUILD_GUIDE;
    }
}

