/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.neoforge.shape;

import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.neoforge.RenderHandler;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ShapeBuffer
implements IShapeBuffer {
    private ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(28);
    private BufferBuilder bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
    private GpuBuffer vertexBuffer;
    private GpuBuffer indexBuffer;
    private int indexCount;
    private int defaultR = 255;
    private int defaultG = 255;
    private int defaultB = 255;
    private int defaultA = 255;

    @Override
    public void setColour(int r, int g, int b, int a) {
        this.defaultR = r;
        this.defaultG = g;
        this.defaultB = b;
        this.defaultA = a;
    }

    @Override
    public void pushVertex(double x, double y, double z) {
        this.bufferBuilder.addVertex((float)x, (float)y, (float)z).setColor(this.defaultR, this.defaultG, this.defaultB, this.defaultA);
    }

    @Override
    public void end() {
        MeshData meshData = this.bufferBuilder.build();
        this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Build Guide vertices", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.vertexBuffer());
        this.indexCount = meshData.drawState().indexCount();
        this.indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS).getBuffer(this.indexCount);
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
    }

    public void render(Matrix4f model, Matrix4f projection) {
        RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
        GpuTexture colourTexture = renderTarget.getColorTexture();
        GpuTexture depthTexture = renderTarget.getDepthTexture();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)model), (ProjectionType)RenderSystem.getProjectionType());
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(colourTexture, OptionalInt.empty(), depthTexture, OptionalDouble.empty());){
            renderPass.setPipeline(RenderHandler.getRenderPipeline());
            renderPass.setIndexBuffer(this.indexBuffer, RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS).type());
            renderPass.setVertexBuffer(0, this.vertexBuffer);
            renderPass.drawIndexed(0, this.indexCount);
        }
        RenderSystem.restoreProjectionMatrix();
    }
}

