/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.ConfigurationScreen;
import brentmaas.buildguide.common.screen.ShapeScreen;
import brentmaas.buildguide.common.screen.ShapelistScreen;
import brentmaas.buildguide.common.screen.VisualisationScreen;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeCircle;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import brentmaas.buildguide.common.shape.ShapeSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;

public class State {
    private static final String PERSISTENCE_ENABLED = "enabled";
    private static final String PERSISTENCE_DEPTHTEST = "depthTest";
    private static final String PERSISTENCE_SHAPESET = "shapeSet";
    private static final String PERSISTENCE_ISHAPESET = "iShapeSet";
    private static final String PERSISTENCE_ISHAPENEW = "iShapeNew";
    private boolean initialised = false;
    public ArrayList<ShapeSet> shapeSets = new ArrayList();
    private int iShapeSet = 0;
    private int iShapeNew = ShapeRegistry.getShapeId(ShapeCircle.class);
    private boolean enabled = false;
    private boolean depthTest = true;
    public ActiveScreen currentScreen = ActiveScreen.Shape;

    public BaseScreen createNewScreen(ActiveScreen newActiveScreen) {
        this.currentScreen = newActiveScreen;
        return this.createNewScreen();
    }

    public BaseScreen createNewScreen() {
        switch (this.currentScreen.ordinal()) {
            case 1: {
                return new VisualisationScreen();
            }
            case 2: {
                return new ShapelistScreen();
            }
            case 3: {
                return new ConfigurationScreen();
            }
        }
        return new ShapeScreen();
    }

    public Shape getCurrentShape() {
        return this.shapeSets.size() > 0 ? this.shapeSets.get(this.iShapeSet).getShape() : null;
    }

    public int getCurrentShapeIndex() {
        return this.shapeSets.size() > 0 ? this.shapeSets.get(this.iShapeSet).getIndex() : 0;
    }

    public ShapeSet getShapeSet(int index) {
        return this.shapeSets.size() > 0 ? this.shapeSets.get(index) : null;
    }

    public ShapeSet getCurrentShapeSet() {
        return this.getShapeSet(this.iShapeSet);
    }

    public void removeShapeSet(int index) {
        this.shapeSets.remove(index);
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void pushNewShapeSet() {
        ShapeSet newShapeSet = new ShapeSet(this.iShapeNew);
        newShapeSet.resetOrigin();
        if (((Boolean)BuildGuide.config.shapeListRandomColorsDefaultEnabled.value).booleanValue()) {
            Random random = new Random();
            newShapeSet.setShapeColour(random.nextFloat(), random.nextFloat(), random.nextFloat(), newShapeSet.getShapeColourA());
            newShapeSet.setOriginColour(random.nextFloat(), random.nextFloat(), random.nextFloat(), newShapeSet.getOriginColourA());
        }
        this.shapeSets.add(newShapeSet);
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void initCheck() {
        if (!this.initialised) {
            if (this.shapeSets.size() == 0) {
                this.pushNewShapeSet();
                this.shapeSets.get(0).updateAllShapes();
            }
            for (ShapeSet s : this.shapeSets) {
                if (s.hasOrigin()) continue;
                s.resetOrigin();
            }
            this.initialised = true;
        }
    }

    public void setShape(int i) {
        this.shapeSets.get(this.iShapeSet).setIndex(i);
    }

    public int getShapeSetIndex() {
        return this.iShapeSet;
    }

    public void setShapeSetIndex(int iShapeSet) {
        this.iShapeSet = iShapeSet;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public boolean isShapeAvailable() {
        return this.shapeSets.size() > 0;
    }

    public int getNumberOfShapeSets() {
        return this.shapeSets.size();
    }

    public void resetOrigin() {
        this.shapeSets.get(this.iShapeSet).resetOrigin();
    }

    public void setOriginX(int index, int x) {
        this.shapeSets.get(index).setOriginX(x);
    }

    public void setOriginX(int x) {
        this.setOriginX(this.iShapeSet, x);
    }

    public void setOriginY(int index, int y) {
        this.shapeSets.get(index).setOriginY(y);
    }

    public void setOriginY(int y) {
        this.setOriginY(this.iShapeSet, y);
    }

    public void setOriginZ(int index, int z) {
        this.shapeSets.get(index).setOriginZ(z);
    }

    public void setOriginZ(int z) {
        this.setOriginZ(this.iShapeSet, z);
    }

    public void setOrigin(int index, int x, int y, int z) {
        this.shapeSets.get(index).setOrigin(x, y, z);
    }

    public void setOrigin(int x, int y, int z) {
        this.setOrigin(this.iShapeSet, x, y, z);
    }

    public void shiftOrigin(int index, int dx, int dy, int dz) {
        this.shapeSets.get(index).shiftOrigin(dx, dy, dz);
    }

    public void shiftOrigin(int dx, int dy, int dz) {
        this.shiftOrigin(this.iShapeSet, dx, dy, dz);
    }

    public void shiftOrigins(int dx, int dy, int dz) {
        for (ShapeSet s : this.shapeSets) {
            s.shiftOrigin(dx, dy, dz);
        }
    }

    public int getNumberOfBlocks() {
        int num = 0;
        for (ShapeSet s : this.shapeSets) {
            if (!s.isVisible()) continue;
            num += s.getShape().getNumberOfBlocks();
        }
        return num;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public int getIShapeNew() {
        return this.iShapeNew;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setDepthTest(boolean depthTest) {
        this.depthTest = depthTest;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setIShapeNew(int iShapeNew) {
        this.iShapeNew = iShapeNew;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void loadPersistence(File persistenceFile) throws IOException {
        Scanner scanner = new Scanner(persistenceFile);
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            int separatorIndex = line.indexOf("=");
            if (separatorIndex <= 0) continue;
            String key = line.substring(0, separatorIndex);
            String value = line.substring(separatorIndex + 1);
            if (key.equals(PERSISTENCE_ENABLED)) {
                this.enabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals(PERSISTENCE_DEPTHTEST)) {
                this.depthTest = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals(PERSISTENCE_SHAPESET)) {
                this.pushNewShapeSet();
                this.shapeSets.get(this.shapeSets.size() - 1).restorePersistence(value);
                this.shapeSets.get(this.shapeSets.size() - 1).updateShape();
                continue;
            }
            if (key.equals(PERSISTENCE_ISHAPESET)) {
                this.iShapeSet = Integer.parseInt(value);
                continue;
            }
            if (!key.equals(PERSISTENCE_ISHAPENEW)) continue;
            this.iShapeNew = Integer.parseInt(value);
        }
        scanner.close();
        this.iShapeSet = Math.max(0, Math.min(this.shapeSets.size() - 1, this.iShapeSet));
        this.iShapeNew = Math.max(0, Math.min(ShapeRegistry.getNumberOfShapes() - 1, this.iShapeNew));
    }

    public void savePersistence(File persistenceFile) throws IOException {
        Object persistenceData = "";
        persistenceData = (String)persistenceData + "enabled=" + this.enabled + "\n";
        persistenceData = (String)persistenceData + "depthTest=" + this.depthTest + "\n";
        for (ShapeSet s : this.shapeSets) {
            persistenceData = (String)persistenceData + "shapeSet=" + s.toPersistence() + "\n";
        }
        persistenceData = (String)persistenceData + "iShapeSet=" + this.iShapeSet + "\n";
        persistenceData = (String)persistenceData + "iShapeNew=" + this.iShapeNew + "\n";
        persistenceFile.createNewFile();
        FileOutputStream fileStream = new FileOutputStream(persistenceFile);
        OutputStreamWriter fileWriter = new OutputStreamWriter(fileStream);
        BufferedWriter writer = new BufferedWriter(fileWriter);
        writer.write((String)persistenceData);
        writer.close();
        fileWriter.close();
        fileStream.close();
    }

    public static enum ActiveScreen {
        Shape,
        Visualisation,
        Shapelist,
        Settings;

    }
}

