/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.widget.IWidget;
import java.util.ArrayList;

public abstract class Property<T> {
    protected int x = 180;
    protected int y = 70;
    public T value;
    protected AbstractScreenHandler.Translatable name;
    private ArrayList<IWidget> widgetList = null;
    protected boolean visible = true;

    public Property(T value, AbstractScreenHandler.Translatable name) {
        this.value = value;
        this.name = name;
    }

    protected abstract void initWidgets(ArrayList<IWidget> var1);

    public ArrayList<IWidget> getWidgetList() {
        if (this.widgetList == null) {
            this.widgetList = new ArrayList();
            this.initWidgets(this.widgetList);
        }
        return this.widgetList;
    }

    public void addToScreen(BaseScreen screen) {
        for (IWidget widget : this.getWidgetList()) {
            screen.addWidget(widget);
        }
    }

    public void setValue(T value) {
        this.value = value;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public abstract String getStringValue();

    public abstract boolean setValueFromString(String var1);

    public void setName(AbstractScreenHandler.Translatable name) {
        this.name = name;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
        for (IWidget widget : this.getWidgetList()) {
            widget.setYPosition(y);
        }
    }

    public void setVisibility(boolean visible) {
        for (IWidget widget : this.getWidgetList()) {
            widget.setVisibility(visible);
        }
        this.visible = visible;
    }

    public void render(BaseScreen screen) {
        this.drawString(screen, this.name.toString(), this.x + 5, this.y + 5, 0xFFFFFF);
    }

    public void drawString(BaseScreen screen, String text, int x, int y, int colour) {
        if (this.visible) {
            screen.drawShadowLeft(text, x, y, 0xFFFFFF);
        }
    }

    public void drawStringCentred(BaseScreen screen, String text, int x, int y, int colour) {
        if (this.visible) {
            screen.drawShadowCentred(text, x, y, 0xFFFFFF);
        }
    }
}

