/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.IWidget;
import java.util.ArrayList;

public class PropertyBoolean
extends Property<Boolean> {
    private ICheckboxRunnableButton button;
    private Runnable onPress;

    public PropertyBoolean(Boolean value, AbstractScreenHandler.Translatable name, Runnable onPress) {
        super(value, name);
        this.onPress = onPress;
    }

    @Override
    protected void initWidgets(ArrayList<IWidget> widgetList) {
        this.button = BuildGuide.widgetHandler.createCheckbox(this.x + 140, this.y, new AbstractScreenHandler.Translatable("", new Object[0]), (Boolean)this.value, false, () -> {
            this.value = this.button.isCheckboxSelected();
            if (this.onPress != null) {
                this.onPress.run();
            }
        });
        widgetList.add(this.button);
    }

    @Override
    public void setValue(Boolean value) {
        super.setValue(value);
        this.getWidgetList();
        this.button.setChecked(value);
    }

    @Override
    public String getStringValue() {
        return ((Boolean)this.value).toString();
    }

    @Override
    public boolean setValueFromString(String value) {
        if (!value.equalsIgnoreCase(Boolean.TRUE.toString()) && !value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        this.setValue(Boolean.parseBoolean(value));
        return true;
    }
}

