/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ISelectorList;
import java.util.List;

public class DropdownOverlayScreen
extends BaseScreen
implements IButton {
    private BaseScreen parent;
    private int x;
    private int y;
    private int width;
    private int height;
    private int current;
    private List<AbstractScreenHandler.Translatable> titles;
    private IDropdownCallback callback;
    private IButton openButton;
    private IButton closeButton;
    private ISelectorList shapeSelectorList;

    public DropdownOverlayScreen(BaseScreen parent, int x, int y, int width, int height, List<AbstractScreenHandler.Translatable> titles, int current, IDropdownCallback callback) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.titles = titles;
        this.current = current;
        this.callback = callback;
        this.openButton = BuildGuide.widgetHandler.createButton(x + width - height, y, height, height, new AbstractScreenHandler.Translatable("V", new Object[0]), () -> {
            this.openButton.setVisibility(false);
            BuildGuide.screenHandler.showScreen(this);
        });
    }

    @Override
    public void init() {
        super.init();
        this.closeButton = BuildGuide.widgetHandler.createButton(this.x + this.width - this.height, this.y, this.height, this.height, new AbstractScreenHandler.Translatable("X", new Object[0]), () -> {
            BuildGuide.screenHandler.showScreen(this.parent);
            this.openButton.setVisibility(true);
        });
        this.shapeSelectorList = BuildGuide.widgetHandler.createSelectorList(this.x, this.x + this.width, this.y + this.height, this.wrapper.getHeight(), this.titles, this.current, selected -> {
            this.callback.run(selected);
            BuildGuide.screenHandler.showScreen(this.parent);
            this.current = selected;
            this.openButton.setVisibility(true);
        });
        this.addWidget(this.closeButton);
        this.addWidget(this.shapeSelectorList);
    }

    @Override
    public void render() {
        super.render();
        this.drawShadowCentred(this.titles.get(this.current).toString(), this.x + this.width / 2, this.y + 5, 0xFFFFFF);
    }

    public IButton getOpenButton() {
        return this.openButton;
    }

    @Override
    public void setVisibility(boolean visible) {
        this.openButton.setVisibility(visible);
    }

    @Override
    public void setYPosition(int y) {
        this.y = y;
        this.openButton.setYPosition(y);
        this.closeButton.setYPosition(y);
    }

    @Override
    public void setActive(boolean active) {
        this.openButton.setActive(active);
    }

    public static interface IDropdownCallback {
        public void run(int var1);
    }
}

