/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeRegistry;

public class ShapeSet {
    private static final String PERSISTENCE_INDEX = "index";
    private static final String PERSISTENCE_ORIGIN = "origin";
    private static final String PERSISTENCE_VISIBLE = "visible";
    private static final String PERSISTENCE_SHAPECOLOUR = "shapeColour";
    private static final String PERSISTENCE_ORIGINCOLOUR = "originColour";
    private static final String PERSISTENCE_SHAPECUBESIZE = "shapeCubeSize";
    private static final String PERSISTENCE_ORIGINCUBESIZE = "originCubeSize";
    public Shape[] shapes = new Shape[ShapeRegistry.getNumberOfShapes()];
    private int index;
    private Origin origin;
    private boolean visible = true;
    public static final float defaultColourShapeR = 1.0f;
    public static final float defaultColourShapeG = 1.0f;
    public static final float defaultColourShapeB = 1.0f;
    public static final float defaultColourShapeA = 0.5f;
    private float colourShapeR = 1.0f;
    private float colourShapeG = 1.0f;
    private float colourShapeB = 1.0f;
    private float colourShapeA = 0.5f;
    public static final float defaultColourOriginR = 1.0f;
    public static final float defaultColourOriginG = 0.0f;
    public static final float defaultColourOriginB = 0.0f;
    public static final float defaultColourOriginA = 0.5f;
    private float colourOriginR = 1.0f;
    private float colourOriginG = 0.0f;
    private float colourOriginB = 0.0f;
    private float colourOriginA = 0.5f;
    public static final double defaultShapeCubeSize = 0.6;
    public static final double defaultOriginCubeSize = 0.2;
    private double shapeCubeSize = 0.6;
    private double originCubeSize = 0.2;

    public ShapeSet(int startIndex) {
        this.index = startIndex;
        this.shapes[this.index] = this.initialiseShape(ShapeRegistry.getClassIdentifier(this.index));
    }

    private Shape initialiseShape(String shapeId) {
        Shape newShape = ShapeRegistry.getNewInstance(shapeId);
        newShape.shapeSet = this;
        BaseScreen.shouldUpdatePersistence = true;
        return newShape;
    }

    public void resetOrigin() {
        this.origin = BuildGuide.shapeHandler.getPlayerPosition();
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void updateShape() {
        if (this.shapes[this.index] != null) {
            this.shapes[this.index].update();
        }
    }

    public void updateAllShapes() {
        for (Shape s : this.shapes) {
            if (s == null) continue;
            s.update();
        }
    }

    public void setOriginX(int x) {
        this.origin.x = x;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setOriginY(int y) {
        this.origin.y = y;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setOriginZ(int z) {
        this.origin.z = z;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setOrigin(int x, int y, int z) {
        this.origin.x = x;
        this.origin.y = y;
        this.origin.z = z;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void shiftOrigin(int dx, int dy, int dz) {
        this.origin.x += dx;
        this.origin.y += dy;
        this.origin.z += dz;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public float getShapeColourR() {
        return this.colourShapeR;
    }

    public float getShapeColourG() {
        return this.colourShapeG;
    }

    public float getShapeColourB() {
        return this.colourShapeB;
    }

    public float getShapeColourA() {
        return this.colourShapeA;
    }

    public void setShapeColour(float r, float g, float b, float a) {
        this.colourShapeR = r;
        this.colourShapeG = g;
        this.colourShapeB = b;
        this.colourShapeA = a;
        this.updateAllShapes();
    }

    public float getOriginColourR() {
        return this.colourOriginR;
    }

    public float getOriginColourG() {
        return this.colourOriginG;
    }

    public float getOriginColourB() {
        return this.colourOriginB;
    }

    public float getOriginColourA() {
        return this.colourOriginA;
    }

    public void setOriginColour(float r, float g, float b, float a) {
        this.colourOriginR = r;
        this.colourOriginG = g;
        this.colourOriginB = b;
        this.colourOriginA = a;
        this.updateAllShapes();
    }

    public void setCubeSize(double shapeCubeSize, double originCubeSize) {
        this.shapeCubeSize = shapeCubeSize;
        this.originCubeSize = originCubeSize;
        this.updateAllShapes();
    }

    public double getShapeCubeSize() {
        return this.shapeCubeSize;
    }

    public double getOriginCubeSize() {
        return this.originCubeSize;
    }

    public boolean isShapeAvailable() {
        return this.isShapeAvailable(this.index);
    }

    public boolean isShapeAvailable(int index) {
        return this.shapes[index] != null;
    }

    public Shape getShape() {
        if (this.shapes[this.index] == null) {
            this.shapes[this.index] = this.initialiseShape(ShapeRegistry.getClassIdentifier(this.index));
            this.shapes[this.index].update();
        }
        return this.shapes[this.index];
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean hasOrigin() {
        return this.origin != null;
    }

    public int getOriginX() {
        return this.origin.x;
    }

    public int getOriginY() {
        return this.origin.y;
    }

    public int getOriginZ() {
        return this.origin.z;
    }

    public String toPersistence() {
        Object persistenceData = "";
        persistenceData = (String)persistenceData + "index=" + this.index + ";";
        persistenceData = (String)persistenceData + "origin=" + this.origin.x + "," + this.origin.y + "," + this.origin.z + ";";
        persistenceData = (String)persistenceData + "visible=" + this.visible + ";";
        persistenceData = (String)persistenceData + "shapeColour=" + this.colourShapeR + "," + this.colourShapeG + "," + this.colourShapeB + "," + this.colourShapeA + ";";
        persistenceData = (String)persistenceData + "originColour=" + this.colourOriginR + "," + this.colourOriginG + "," + this.colourOriginB + "," + this.colourOriginA + ";";
        persistenceData = (String)persistenceData + "shapeCubeSize=" + this.shapeCubeSize + ";";
        persistenceData = (String)persistenceData + "originCubeSize=" + this.originCubeSize + ";";
        for (Shape s : this.shapes) {
            if (s == null) continue;
            persistenceData = (String)persistenceData + s.getClass().getName() + "=" + s.toPersistence() + ";";
        }
        return persistenceData;
    }

    public void restorePersistence(String persistenceData) {
        String[] splitData;
        for (String entry : splitData = persistenceData.split(";")) {
            int separatorIndex = entry.indexOf("=");
            if (separatorIndex <= 0) continue;
            String key = entry.substring(0, separatorIndex);
            String value = entry.substring(separatorIndex + 1);
            if (key.equals(PERSISTENCE_INDEX)) {
                this.index = Integer.parseInt(value);
                continue;
            }
            if (key.equals(PERSISTENCE_ORIGIN)) {
                String[] splitEntry = value.split(",");
                if (splitEntry.length != 3) continue;
                this.origin.x = Integer.parseInt(splitEntry[0]);
                this.origin.y = Integer.parseInt(splitEntry[1]);
                this.origin.z = Integer.parseInt(splitEntry[2]);
                continue;
            }
            if (key.equals(PERSISTENCE_VISIBLE)) {
                this.visible = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals(PERSISTENCE_SHAPECOLOUR)) {
                String[] splitEntry = value.split(",");
                if (splitEntry.length != 4) continue;
                this.colourShapeR = Float.parseFloat(splitEntry[0]);
                this.colourShapeG = Float.parseFloat(splitEntry[1]);
                this.colourShapeB = Float.parseFloat(splitEntry[2]);
                this.colourShapeA = Float.parseFloat(splitEntry[3]);
                continue;
            }
            if (key.equals(PERSISTENCE_ORIGINCOLOUR)) {
                String[] splitEntry = value.split(",");
                if (splitEntry.length != 4) continue;
                this.colourOriginR = Float.parseFloat(splitEntry[0]);
                this.colourOriginG = Float.parseFloat(splitEntry[1]);
                this.colourOriginB = Float.parseFloat(splitEntry[2]);
                this.colourOriginA = Float.parseFloat(splitEntry[3]);
                continue;
            }
            if (key.equals(PERSISTENCE_SHAPECUBESIZE)) {
                this.shapeCubeSize = Double.parseDouble(value);
                continue;
            }
            if (key.equals(PERSISTENCE_ORIGINCUBESIZE)) {
                this.originCubeSize = Double.parseDouble(value);
                continue;
            }
            int index = ShapeRegistry.getShapeId(key);
            if (index < 0) continue;
            this.shapes[index] = this.initialiseShape(key);
            this.shapes[index].restorePersistence(value);
        }
        this.index = Math.max(0, Math.min(this.shapes.length - 1, this.index));
    }

    public static class Origin {
        public int x;
        public int y;
        public int z;

        public Origin(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

