/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.widget.ISelectorList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class SelectorListImpl
extends ObjectSelectionList<Entry>
implements ISelectorList {
    protected ISelectorList.ISelectorListCallback callback;

    public SelectorListImpl(Minecraft minecraft, int left, int right, int top, int bottom, int slotHeight, List<AbstractScreenHandler.Translatable> titles, int current, ISelectorList.ISelectorListCallback callback) {
        super(minecraft, right - left, bottom - top, top, slotHeight);
        this.setX(left);
        this.callback = callback;
        for (int i = 0; i < titles.size(); ++i) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(i, titles.get(i)));
        }
        this.setSelected((AbstractSelectionList.Entry)((Entry)this.children().get(current)));
    }

    @Override
    public void setYPosition(int y) {
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), 0x33000000);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public int getRowWidth() {
        return this.width - 12;
    }

    protected int scrollBarX() {
        return this.getRight() - 6;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements ISelectorList.IEntry {
        private int index;
        private AbstractScreenHandler.Translatable title;

        public Entry(int index, AbstractScreenHandler.Translatable title) {
            this.index = index;
            this.title = title;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = Minecraft.getInstance().font;
            String string = this.title.toString();
            int n = this.getX() + 5;
            int n2 = this.getY();
            int n3 = this.getHeight();
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, string, n, n2 + (n3 - 9) / 2, -1, true);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean b) {
            SelectorListImpl.this.callback.run(this.index);
            return false;
        }

        public Component getNarration() {
            return Component.literal((String)"");
        }
    }
}

