/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class ShapeListImpl
extends ObjectSelectionList<Entry>
implements IShapeList {
    private Runnable update;

    public ShapeListImpl(Minecraft minecraft, int left, int right, int top, int bottom, int slotHeight, Runnable update) {
        super(minecraft, right - left, bottom - top, top, slotHeight);
        this.setX(left);
        this.update = update;
        for (int shapeSetId = 0; shapeSetId < BuildGuide.stateManager.getState().shapeSets.size(); ++shapeSetId) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(shapeSetId));
            if (shapeSetId != BuildGuide.stateManager.getState().getShapeSetIndex()) continue;
            this.setSelected((Entry)this.children().get(this.children().size() - 1));
        }
    }

    @Override
    public void setYPosition(int y) {
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    @Override
    public void addEntry(int shapeSetId) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(shapeSetId));
        this.setSelected((Entry)this.children().get(shapeSetId));
    }

    public void removeEntry(Entry entry) {
        for (Entry e : this.children()) {
            if (e.getShapeSetId() <= entry.getShapeSetId()) continue;
            e.setShapeSetId(e.getShapeSetId() - 1);
        }
        if (this.children().size() > entry.getShapeSetId() + 1) {
            this.setSelected((Entry)this.children().get(entry.getShapeSetId() + 1));
        } else if (this.children().size() > 1) {
            this.setSelected((Entry)this.children().get(entry.getShapeSetId() - 1));
        }
        super.removeEntry((AbstractSelectionList.Entry)entry);
    }

    @Override
    public boolean removeEntry(IShapeList.IEntry entry) {
        this.removeEntry((Entry)entry);
        return true;
    }

    public void setSelected(@Nullable Entry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            BuildGuide.stateManager.getState().setShapeSetIndex(entry.getShapeSetId());
        }
        this.update.run();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), 0x33000000);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public int getRowWidth() {
        return this.width - 12;
    }

    protected int scrollBarX() {
        return this.getRight() - 6;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements IShapeList.IEntry {
        private int shapeSetId;

        public Entry(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int colour = BuildGuide.screenHandler.getShapeProgressColour(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId).getShape());
            Font font = Minecraft.getInstance().font;
            String string = BuildGuide.screenHandler.getFormattedShapeName(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId));
            int n = this.getX() + 5;
            int n2 = this.getY();
            int n3 = this.getHeight();
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, string, n, n2 + (n3 - 9) / 2, ARGB.color((int)(colour >> 16 & 0xFF), (int)(colour >> 8 & 0xFF), (int)(colour & 0xFF)), true);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean b) {
            ShapeListImpl.this.setSelected(this);
            return false;
        }

        @Override
        public void setShapeSetId(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        @Override
        public int getShapeSetId() {
            return this.shapeSetId;
        }

        public Component getNarration() {
            return Component.literal((String)"");
        }
    }
}

